/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm.ext;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;

import javax.baja.control.*;

/**
 * BAlarmAlgorithm is the base class for all alarm
 * algorithms designed to alarm algorithms for 
 * BAlarmSourceExt.
 *
 * @author    Andy Saunders
 * @creation  13 Dec 03
 * @version   $Revision: 6$ $Date: 4/23/08 11:54:50 AM EDT$
 * @since     Baja 1.0
 */
public abstract class BAlarmAlgorithm
  extends BComponent
{ 

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAlarmAlgorithm.class);
  
////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Get this parent as a BAlarmSourceExt.
   */
  public final BAlarmSourceExt getParentExt()
  {
    BComplex parent = getParent();
    if (parent instanceof BAlarmSourceExt) // issue 11846
      return (BAlarmSourceExt)parent;

    return null;
  }

  /**
   * Get this extension's parent point, or null if
   * the parent is not an instance of BControlPoint.
   */
  public final BControlPoint getParentPoint()
  {
    BAlarmSourceExt parent = getParentExt();
    if(parent != null)
      return parent.getParentPoint();
    else
      return null;
  }

  /**
   * This causes execute to be called on the parent
   * point if getParentPoint() is not null.
   */
  public void executePoint()
  {
    if (!isRunning()) return;
    BControlPoint point = getParentPoint();
    if (point != null) point.execute();
  }  

  /**
   * Get this extension's parent point's facets, or BFacets.NULL
   * if the parent point  is not an instance of BControlPoint.
   */
  public final BFacets getPointFacets()
  {
    try
    {
      return getParentPoint().getFacets();
    }
    catch(Exception e)
    {
      return BFacets.NULL;
    }
  }

////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  /**
   * A BAlarmAlgorithm's parent must be a BAlarmSourceExt
   */
  @Override
  public boolean isParentLegal(BComponent parent)
  {
    if (parent instanceof BAlarmSourceExt)
      return true;
    else
      return false;
  }


  public boolean isGrandparentLegal(BComponent grandparent)
  {
    return true;
  }

}
