/*
 * Copyright 2000-2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm;

import javax.baja.sys.*;

/**
 * The BIRemoteAlarmSource is a marker interface that is implemented by BObjects 
 * that handle alarms sent between stations. 
 * <p>
 * ackAlarm should return immediately after sucessfully sending the alarm 
 * to the remote station. BAlarmService.routeAlarm() should then be called 
 * when the ackNotification is received from the remote station.
 *
 * @author    Blake M Puhak
 * @creation  19 Jan 04
 * @version   $Revision: 2$ $Date: 3/30/05 11:35:59 AM EST$
 * @since     Baja 1.0
 */
public interface BIRemoteAlarmSource
  extends BIAlarmSource
{

  public static final Type TYPE = Sys.loadType(BIRemoteAlarmSource.class);
  
}
