/*
 * Copyright 2000-2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm;

import javax.baja.sys.*;

/**
 * The BIAlarmSource interface must be implemented by all
 * BObjects capable of generating alarms 
 * <p>
 * This interface must be implemented by declaring the
 * following actions on the BIAlarmSource:
 * <pre>
 *    ackAlarm(ackRequest: BAlarmRecord): boolean     
 *      -- Acknowledge the alarm matching this ack request
 *      flags = readonly, hidden
 * </pre>
 *
 * @author    Dan Giorgis
 * @creation  19 Feb 01
 * @version   $Revision: 3$ $Date: 6/16/04 11:10:56 AM EDT$
 * @since     Baja 1.0
 */
public interface BIAlarmSource
  extends BInterface
{
  /**
   * Acknowledge the alarm matching the given acknowledge 
   * request.
   * Classes implementing AlarmSource must implement the ackAlarm 
   * method as an action.
   *
   * @param ackRequest The acknowledgement request alarm record.
   * @return true if alarm acked (clear ack bit in status), false if stale ack
   */
  public BBoolean ackAlarm(BAlarmRecord ackRequest);   
  
  public static final Type TYPE = Sys.loadType(BIAlarmSource.class);
  
}