function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/xprotect/rc/xprotect/XProtectCamera
 */
define(['Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/js/rc/tinyevents/tinyevents', 'nmodule/xprotect/rc/xprotect/XProtectCameraSession'], function (Promise, _, switchboard, tinyevents, XProtectCameraSession) {
  'use strict';

  var isNumber = _.isNumber;
  var LIVE = 'Live';
  var PLAYBACK = 'Playback';

  /**
   * Models an XProtect camera, its playback, and painting its camera feed to
   * the screen.
   *
   * @class
   * @alias module:nmodule/xprotect/rc/model/XProtectCamera
   */
  return /*#__PURE__*/function () {
    /**
     * @param {Object} params - Inputs to initialize the XProtectCamera.
     * @param {number} params.width - camera feed width
     * @param {number} params.height - camera feed height
     * @param {String} params.cameraId - Camera ID to connect.
     * @param {JQuery} params.canvas - canvas for the camera stream to paint to.
     */
    function XProtectCamera(params) {
      var _this = this;
      _classCallCheck(this, XProtectCamera);
      var cameraSession = params.cameraSession,
        canvas = params.canvas;
      if (!cameraSession) {
        throw new Error('XProtectCameraSession required');
      }
      this.cameraSession = cameraSession;
      this.cameraSession.on(XProtectCameraSession.FRAME_EVENT, function (frame) {
        return _this.$paintFrame(frame);
      });
      this.imageUrl = '';
      this.canvas = canvas;
      this.canvasContext = this.canvas[0].getContext('2d');
      this.image = document.createElement('img');
      this.image.addEventListener('load', function () {
        return _this.drawImage(_this.image);
      });
      switchboard(this, {
        changeStream: {
          allow: 'oneAtATime',
          onRepeat: 'preempt'
        }
      });
      tinyevents(this);
    }

    /**
     * Paint the current frame to the canvas, at the given dimensions.
     * @param {object} params
     * @param {number} params.width
     * @param {number} params.height
     */
    return _createClass(XProtectCamera, [{
      key: "drawImage",
      value: function drawImage(_ref) {
        var width = _ref.width,
          height = _ref.height;
        var image = this.image,
          canvas = this.canvas;
        canvas[0].width = width;
        canvas[0].height = height;
        this.canvasContext.drawImage(image, 0, 0, width, height);
      }

      /**
       * Switches the stream to live.
       * @returns {Promise}
       */
    }, {
      key: "live",
      value: function live() {
        return this.$stream(LIVE);
      }

      /**
       * Starts playing the stream.
       *
       * @param {object} [params]
       * @param {number} [params.speed]
       * @param {number} [params.timestamp]
       */
    }, {
      key: "play",
      value: function play() {
        var _this2 = this;
        var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$speed = _ref2.speed,
          speed = _ref2$speed === void 0 ? 1 : _ref2$speed,
          timestamp = _ref2.timestamp;
        return this.$stream(PLAYBACK, timestamp).then(function () {
          // XProtect will pause after a seek - always force a playbackSpeed if timestamp is specified
          return _this2.cameraSession.setPlaybackSpeed(speed, !!timestamp);
        });
      }

      /**
       * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} streamProperties
       */
    }, {
      key: "changeStream",
      value: function changeStream(streamProperties) {
        var width = streamProperties.width,
          height = streamProperties.height;
        if (isNumber(width) && isNumber(height)) {
          this.drawImage(streamProperties);
        }
        return this.cameraSession.changeStream(streamProperties);
      }

      /**
       * @private
       * @param {string} signalType
       * @param {number} [timestamp]
       * @returns {Promise}
       */
    }, {
      key: "$stream",
      value: function $stream(signalType, timestamp) {
        if (signalType === this.$signalType && !timestamp) {
          return Promise.resolve();
        }
        this.$signalType = signalType;
        return this.cameraSession.stream({
          signalType: signalType,
          timestamp: timestamp
        });
      }

      /**
       * Handler for ptz.
       *
       * @param {String} direction
       */
    }, {
      key: "ptzTrigger",
      value: function ptzTrigger(direction) {
        this.cameraSession.ptz(direction);
      }
    }, {
      key: "destroy",
      value: function destroy() {
        return this.cameraSession.destroy();
      }

      /**
       * @private
       * @param {object} frame
       * @param {number} frame.width
       * @param {number} frame.height
       * @param {Blob} frame.blob
       */
    }, {
      key: "$paintFrame",
      value: function $paintFrame(_ref3) {
        var width = _ref3.width,
          height = _ref3.height,
          blob = _ref3.blob;
        var image = this.image;
        var imageURL = this.imageURL;
        if (width && height) {
          image.width = width;
          image.height = height;
        }
        if (imageURL) {
          window.URL.revokeObjectURL(imageURL);
        }
        var newImageURL = window.URL.createObjectURL(blob);
        this.imageURL = newImageURL;
        image.src = newImageURL;
      }
    }]);
  }();
});
