/* global console */
/**
 * @private
 * @module nmodule/micros/rc/MicrosPointManagerModel
 */
define([
  'baja!',
  'underscore',
  'Promise',
  'nmodule/micros/rc/MicrosUtils',
  'nmodule/driver/rc/wb/mgr/PointMgrModel',
  'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo',
  'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn',
  'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn',
  'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn',
  'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn',
  'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn',
  'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn'
    ], function (
  baja,
  _,
  Promise,
  MicrosUtils,
  PointMgrModel,
  MgrTypeInfo,
  IconMgrColumn,
  NameMgrColumn,
  PathMgrColumn,
  TypeMgrColumn,
  PropertyMgrColumn,
  PropertyPathMgrColumn
    ) {

  'use strict';

  var NEW_INSTANCE_ERROR = 'pmm.newInstance.error';

  var makeColumns = function () {
    var columns = [
      new IconMgrColumn(),
      new PathMgrColumn({ flags: MicrosUtils.flags.UNSEEN }),
      new NameMgrColumn({ flags: MicrosUtils.flags.EDITABLE }),
      new TypeMgrColumn(),
      new PropertyMgrColumn('out', {displayName: MicrosUtils.microsLex('pm.out') }),
      new PropertyPathMgrColumn('proxyExt/roomNumber', {
        displayName: MicrosUtils.microsLex('pm.roomNumber'),
        flags: MicrosUtils.flags.EDITABLE,
        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
      }),
      new PropertyPathMgrColumn('proxyExt/guestReservationNumber', {
        displayName: MicrosUtils.microsLex('pm.guestReservationNumber'),
        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
      }),
      new PropertyPathMgrColumn('proxyExt/preArrival', {
        displayName: MicrosUtils.microsLex('pm.preArrival'),
        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
      }),
      new PropertyPathMgrColumn('facets', {
        displayName: MicrosUtils.webEditorsLex('facets'),
        flags: MicrosUtils.flags.UNSEEN | MicrosUtils.flags.EDITABLE,
        type: baja.lt(MicrosUtils.typeSpec.BOOLEAN_POINT)
      }),
      new PropertyPathMgrColumn('proxyExt/faultCause', {
        displayName: MicrosUtils.microsLex('pm.faultCause'),
        flags: MicrosUtils.flags.UNSEEN,
        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
      }),
      new PropertyPathMgrColumn('proxyExt/readValue', {
        displayName: MicrosUtils.microsLex('pm.readValue'),
        flags: MicrosUtils.flags.UNSEEN,
        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
      })//,
//      new PropertyPathMgrColumn('proxyExt/micros_MicrosGuestData/guestName', {
//        displayName: MicrosUtils.microsLex('pm.guestName'),
//        flags: MicrosUtils.flags.UNSEEN,
//        type: baja.lt(MicrosUtils.typeSpec.MICROS_PROXY_EXT)
//      })

    ];

    return columns;
  };


  var MicrosPointManagerModel = function (params) {

    var that = this;
    PointMgrModel.call(that, _.extend({
      columns: makeColumns(),
      component: params.component,
      folderType: MicrosUtils.typeSpec.MICROS_POINT_FOLDER,
      proxyExtType: MicrosUtils.typeSpec.MICROS_PROXY_EXT
    }, params));
  };

  MicrosPointManagerModel.prototype = Object.create(PointMgrModel.prototype);
  MicrosPointManagerModel.prototype.constructor = MicrosPointManagerModel;

  /**
   * Override point to customize how new instances of the selected type spec
   * are instantiated. The default implementation will create a point and proxy ext
   * using the type specified by the getProxyExtType() function.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
   * @returns {baja.Value|Promise}
   */
  MicrosPointManagerModel.prototype.newInstance = function (typeInfo, roomNumber) {

    var that = this,
        proxyExt,
        point;

    if (typeInfo !== MicrosUtils.typeSpec.BOOLEAN_POINT) {
      console.error( MicrosUtils.microsLex(NEW_INSTANCE_ERROR, '', [typeInfo]) );
      return Promise.resolve(null);
    }

    return MgrTypeInfo.make([typeInfo])
    .then(function (mgrTypeInfos) {
      var mTypeInfo = mgrTypeInfos[0];
      return mTypeInfo.newInstance();
     })
    .then(function (comp) {
      point = comp;
      proxyExt = baja.$(that.getProxyExtType());
      proxyExt.setRoomNumber(roomNumber);
      return point.setProxyExt(proxyExt);
    })
    .then(function () {
      return point;
    });

  };

  /**
   * Function to return an array of types to be offered upon the execution
   * of the command to add new instances.
   *
   * @returns {Array.<baja.Type>}
   */
  MicrosPointManagerModel.prototype.getNewTypes = function () {
    return [MicrosUtils.typeSpec.BOOLEAN_POINT];
  };

  return MicrosPointManagerModel;
});