/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/commands/AlarmDetailsCommand
 */
define([ 'baja!',
  'jquery',
  'Promise',
  'lex!alarm',
  'dialogs',
  'bajaux/commands/Command',
  'nmodule/alarm/rc/db/editors/AlarmDetailsTable',
  'nmodule/alarm/rc/db/editors/Sequencer',
  'nmodule/alarm/rc/db/commands/NotesCommand',
  'nmodule/js/rc/log/Log',
  'hbs!nmodule/alarm/rc/db/templates/alarmDetails',
  'css!nmodule/alarm/rc/db/templates/view' ], function (
    baja,
    $,
    Promise,
    lexs,
    dialogs,
    Command,
    AlarmDetailsTable,
    Sequencer,
    NotesCommand,
    Log,
    alarmDetailsTemplate) {

  "use strict";


  var AlarmDetailsCommand = function (params) {
    Command.call(this, params);
  };

  AlarmDetailsCommand.prototype = Object.create(Command.prototype);
  AlarmDetailsCommand.prototype.constructor = AlarmDetailsCommand;

  AlarmDetailsCommand.makeFor = function (view) {

    var ALARM_TABLE_SELECTOR = '.alarmTable',
        alarmTable,
        lex                  = lexs[0];

    function getTable() {
      return $(ALARM_TABLE_SELECTOR, view.jq()).data('widget');
    }

    function getSelectedRows() {
      alarmTable = getTable();
      return alarmTable ? alarmTable.getSelectedRows() : [];
    }

    function getSelectedIndex() {
      var i, index,
          alarmTable = getTable(),
          rows       = alarmTable.getModel().getRows(),
          selection  = alarmTable.$getSelection();

      for (i = 0; i < rows.length; i++) {
        if (selection.isSelected(i)) {
          index = i;
          break;
        }
      }

      return index;
    }

    function getSelectedAlarm() {

      var rows = getSelectedRows();

      if (rows.length) {
        if (rows.length > 1) {
          dialogs.showOk(lex.get('alarm.multipleRecords'));
          return null;
        }

        return rows[0].getSubject();
      } else {
        dialogs.showOk(lex.get('alarm.noRecordSelected'));
        return null;
      }
    }

    return new AlarmDetailsCommand({
      displayName: lex.get('command.alarmDetails.label'),
      description: lex.get('command.alarmDetails.label'),
      icon: lex.get('command.alarmDetails.icon'),
      func: function () {

        var commands = [],
            dom      = $("<div>").append($(alarmDetailsTemplate({}))),
            alarm    = getSelectedAlarm(),
            selectedIndex,
            tableSize;

        return Promise.resolve(alarm && AlarmDetailsTable.makeFor(alarm))
          .then(function (detailsTable) {

            if (detailsTable && alarmTable) {
              var cmds = Sequencer.makeFor(alarmTable, view);
              commands.push(cmds[0]);
              commands.push({ name: 'close', displayName: lex.get('alarm.dialog.close'), esc: true });
              commands.push(cmds[1]);
              commands.push(cmds[2]);

              var dlg = dialogs.show({
                title: lex.get('command.alarmDetails.label'),
                content: dom.html(),
                buttons: commands
              });

              $('.table', $('.js-dialog')).append(detailsTable.jq());

              selectedIndex = getSelectedIndex();
              tableSize = alarmTable.getModel().getRows().length;

              //determine if the first and/or last row are selected and disable prev/next buttons respectively
              if (selectedIndex === 0) {
                dlg.disableButton(cmds[0].name);
              }

              if (selectedIndex === tableSize - 1) {
                dlg.disableButton(cmds[1].name);
              }
            }
          });
      }
    });
  };

  return AlarmDetailsCommand;

});

