/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/SelectAllCommand
 */
define(['bajaux/commands/Command',
        'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (
        Command,
        alarmConsoleCommandMixIn) {

  'use strict';

  /**
   * Selects all the rows in the current table.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var SelectAllCommand = function (view) {
    Command.apply(this, [{
      module: 'alarm',
      lex: 'commands.selectAll',
      func: function () {
        var table = view.$getAlarmTable(),
            selection = table.$getSelection();

        selection.select(0, table.getModel().getRows().length);
      }
    }]);

    alarmConsoleCommandMixIn(this);

    this.$showInMenu = true;
  };

  SelectAllCommand.prototype = Object.create(Command.prototype);
  SelectAllCommand.prototype.constructor = SelectAllCommand;

  return SelectAllCommand;
});
