/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/OptionsCommand
 */
define([
  'lex!alarm,js',
  'dialogs',
  'jquery',
  'Promise',
  'bajaux/commands/Command',
  'nmodule/webEditors/rc/fe/feDialogs',
  'nmodule/alarm/rc/console/fe/OptionsEditor',
  'nmodule/webEditors/rc/fe/fe',
  'nmodule/js/rc/log/Log',
  'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'
], function (lexs,
             dialogs,
             $,
             Promise,
             Command,
             feDialogs,
             OptionsEditor,
             fe,
             Log,
             alarmConsoleCommandMixIn) {
  'use strict';

  var alarmLex = lexs[0],
      jsLex    = lexs[1];

  function options(view) {
    var viewModel = view.$getViewModel(),
        support   = viewModel.$getSupport(),
        options   = support.getAlarmConsoleOptions(),
        ed;

    return dialogs.show({
      title: viewModel.$isSingleSourceModel() ?
        alarmLex.get('alarm.console.commands.options.singleSourceView') :
        alarmLex.get('alarm.console.commands.options.multiSourceView'),
      content: function (dialog, dom) {
        return fe.buildFor({
          dom: $('<div/>').appendTo(dom),
          value: options,
          type: OptionsEditor,
          formFactor: 'compact',
          properties: {viewModel: viewModel}
        }).then(function (e) {
          ed = e;
        });
      },
      buttons: [
        {
          name: 'ok',
          displayName: jsLex.get('dialogs.ok'),
          handler: function () {
            return ed.save()
              .then(function () {
                return ed.destroy();
              })
              .catch(function error(err) {
                return dialogs.showOk(err)
                  .then(function () {
                    return Promise.reject(err);
                  });
              });
          }
        },
        {
          name: 'cancel',
          displayName: jsLex.get('dialogs.cancel'),
          handler: function () {
            return ed && ed.destroy();
          },
          esc: true
        },
        {
          name: 'resetToDefaults',
          displayName: alarmLex.get('alarm.console.commands.resetToDefaults.displayName'),
          handler: function () {
            var defaultOptions = support.getDefaultAlarmConsoleOptions();
            ed.getBuilder().getEditorFor('options').load(
              ed.$makeOptionsComponent(defaultOptions))
              .catch(Log.error);
            return false;
          }
        }
      ]
    }).promise().then(function () {
      if (viewModel.$isSingleSourceModel()) {
        return viewModel.pageSizeChanged(
          support.getAlarmConsoleOptions().singleSourceView.pageSize);
      }
    });
  }

  /**
   * Shows a dialog for the user to configure common options for the alarm console.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var OptionsCommand = function (view) {
    Command.apply(this, [{
      module: 'alarm',
      lex: 'alarm.console.commands.options',
      func: function () {
        return options(view);
      }
    }]);

    alarmConsoleCommandMixIn(this);
  };

  OptionsCommand.prototype = Object.create(Command.prototype);
  OptionsCommand.prototype.constructor = OptionsCommand;

  return OptionsCommand;
});
