/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jshint browser:true*/

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/baja/BajaAlarmConsoleAudioSupport
 */
define(['baja!',
  'Promise',
  'nmodule/alarm/rc/console/support/AlarmConsoleAudioSupport',
  'nmodule/webEditors/rc/wb/audio/AudioManager'], function (baja,
                                                            Promise,
                                                            AlarmConsoleAudioSupport,
                                                            AudioManager) {
  'use strict';

  /**
   * Support for playing audio.
   *
   * @class
   * @alias module:nmodule/alarm/rc/console/baja/BajaAlarmConsoleAudioSupport
   */
  var BajaAlarmConsoleAudioSupport = function () {
    AlarmConsoleAudioSupport.apply(this, arguments);

    this.$files = {};
  };

  BajaAlarmConsoleAudioSupport.prototype = Object.create(AlarmConsoleAudioSupport.prototype);
  BajaAlarmConsoleAudioSupport.prototype.constructor = BajaAlarmConsoleAudioSupport;

  BajaAlarmConsoleAudioSupport.prototype.play = function (sound) {
    var that = this,
        file = that.$files[sound];

    if (!file) {
      return baja.Ord.make(sound)
        .get()
        .then(function (file) {
          that.$files[sound] = file;
          AudioManager.INSTANCE.play(file);
        });
    }
    else {
      AudioManager.INSTANCE.play(file);
      return Promise.resolve();
    }
  };

  BajaAlarmConsoleAudioSupport.prototype.stopAll = function () {
    AudioManager.INSTANCE.stopAll();
  };

  return BajaAlarmConsoleAudioSupport;
});
