/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/OutOfRangeFaultAlgorithm
 */
define(['baja!',
  'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja,
                                                         AlarmAlgorithm) {

  'use strict';

  /**
   * BajaScript representation of an `alarm:OutOfRangeFaultAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/OutOfRangeFaultAlgorithm
   */
  var OutOfRangeFaultAlgorithm = function OutOfRangeFaultAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  OutOfRangeFaultAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  OutOfRangeFaultAlgorithm.prototype.constructor = OutOfRangeFaultAlgorithm;

  /**
   * Return facets from the parent point for the `highLimit` and `lowLimit`
   * slots.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  OutOfRangeFaultAlgorithm.prototype.getFacets = function (slot) {
    switch (String(slot)) {
      case 'highLimit':
      case 'lowLimit':
        return this.getPointFacets();
      default:
        return AlarmAlgorithm.prototype.getFacets.apply(this, arguments);
    }
  };

  return OutOfRangeFaultAlgorithm;
});
