/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/OutOfRangeAlgorithm
 */
define(['baja!',
  'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja,
                                                         AlarmAlgorithm) {

  'use strict';

  /**
   * BajaScript representation of an `alarm:OutOfRangeAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/OutOfRangeAlgorithm
   */
  var OutOfRangeAlgorithm = function OutOfRangeAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  OutOfRangeAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  OutOfRangeAlgorithm.prototype.constructor = OutOfRangeAlgorithm;

  /**
   * Return facets from the parent point for the `highLimit` and `lowLimit`
   * slots.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  OutOfRangeAlgorithm.prototype.getFacets = function (slot) {
    switch (String(slot)) {
      case 'highLimit':
      case 'lowLimit':
        return this.getPointFacets();
      default:
        return AlarmAlgorithm.prototype.getFacets.apply(this, arguments);
    }
  };

  return OutOfRangeAlgorithm;
});
