/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/ToggleButtonBooleanEditor
 */
define(['baja!', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, $, Promise, _, Widget, BaseEditor, BooleanEditor) {
  'use strict';

  /**
   * A field editor for working with booleans.
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/ToggleButtonBooleanEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   */

  var ToggleButtonBooleanEditor = function ToggleButtonBooleanEditor(params) {
    BooleanEditor.call(this, $.extend({
      keyName: 'ToggleButtonBooleanEditor'
    }, params));
  };

  ToggleButtonBooleanEditor.prototype = Object.create(BooleanEditor.prototype);

  ToggleButtonBooleanEditor.prototype.constructor = ToggleButtonBooleanEditor;

  /**
   * Return the checkbox element.
   *
   * @private
   * @returns {jQuery}
   */
  ToggleButtonBooleanEditor.prototype.$getToggleButton = function () {
    return this.jq().children('button');
  };

  /**
   * Creates a checkbox input.
   * @param {jQuery} dom
   */
  ToggleButtonBooleanEditor.prototype.doInitialize = function (dom) {
    var props = this.properties();
    var that = this,
        id = this.generateId(),
        input = $('<button type="button">').prop('id', id).html(_.escape(props.getValue("display")));
    var needsRoundEdgesLeft = props.getValue("roundEdgesLeft"),
        needsRoundEdgesRight = props.getValue("roundEdgesRight");
    dom.html(input);
    input.addClass('button-dow');
    input.addClass('button-unselected');
    if (needsRoundEdgesLeft) {
      input.addClass('button-roundedgeleft');
    }
    if (needsRoundEdgesRight) {
      input.addClass('button-roundedgeright');
    }
    dom.on('click', 'button', function () {
      return that.read().then(function (value) {
        that.doLoad(!value);
        that.setModified(true);
      }).catch(baja.error);
    });
  };

  /**
   * Checks or unchecks the checkbox to reflect the loaded value.
   * @param {Boolean} val
   */
  ToggleButtonBooleanEditor.prototype.doLoad = function (val) {
    this.$getToggleButton().removeClass('button-selected').removeClass('button-unselected').addClass(val ? 'button-selected' : 'button-unselected');
  };

  /**
   * Returns the checked/unchecked state of the checkbox.
   * @returns {Boolean} the boolean checked state of the checkbox
   */
  ToggleButtonBooleanEditor.prototype.doRead = function () {
    return this.$getToggleButton().hasClass("button-selected");
  };

  /**
   * Enables or disables the checkbox element.
   *
   * @param {Boolean} enabled
   */
  ToggleButtonBooleanEditor.prototype.doEnabled = function (enabled) {
    this.$getToggleButton().prop('disabled', this.isReadonly() || !enabled);
  };

  /**
   * Disables or enables the checkbox element.
   *
   * @param {Boolean} readonly
   */
  ToggleButtonBooleanEditor.prototype.doReadonly = function (readonly) {
    this.$getToggleButton().prop('disabled', !this.isEnabled() || readonly);
  };

  return ToggleButtonBooleanEditor;
});
