/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/ReportCombinerOptionalValueFE
 */
define(['baja!', 'jquery', 'underscore', 'Promise', 'bajaux/Widget', 'dialogs', 'bajaux/events', 'nmodule/analytics/rc/report/fe/ReportOptionalValueFE', 'lex!analytics'], function (baja, $, _, Promise, Widget, dialogs, events, ReportOptionalValueFE, lexicon) {

    'use strict';

    var lex = lexicon[0];
    /**
     * A field editor for selecting units for reports.
     *
     * @class
     * @alias module:nmodule/analytics/rc/report/fe/ReportCombinerOptionalValueFE
     * @extends module:nmodule/analytics/rc/report/fe/ReportOptionalValueFE
     */
    var ReportCombinerOptionalValueFE = function ReportCombinerOptionalValueFE() {
        ReportOptionalValueFE.call(this, arguments);
    };
    // Inheriting ReportOptionalValueFE from BaseEditor
    ReportCombinerOptionalValueFE.prototype = Object.create(ReportOptionalValueFE.prototype);
    // Setting the constructor
    ReportCombinerOptionalValueFE.prototype.constructor = ReportCombinerOptionalValueFE;

    /**
     * Loads a `baja.String` data value into the input element. I
     * @param {baja.String} value
     * @returns {Promise} promise to be resolved if the value is loaded,
     * or rejected if the `Data Value` could not be encoded to string
     */
    ReportCombinerOptionalValueFE.prototype.doLoad = function (value) {
        var props = this.properties();
        var dataValue = value;
        var selected = props.getValue("selected");
        if (!_.isEmpty(dataValue) && _.isString(dataValue)) {
            dataValue = baja.$("analytics:Combination").make(dataValue);
        }
        return this.buildEditor(dataValue, selected);
    };

    /**
     * return default value as BCombination
     * @returns {*}
     */
    ReportCombinerOptionalValueFE.prototype.getDefaultValue = function () {
        return baja.$("analytics:Combination");
    };

    /**
     * Get the label for interval
     */
    ReportCombinerOptionalValueFE.prototype.getLabel = function () {
        var props = this.properties(),
            propName = props.getValue("propName");
        if (propName === "rollup") {
            return lex.get("rollup");
        } else if (propName === "aggregation") {
            return lex.get("aggregation");
        } else {
            return "";
        }
    };

    return ReportCombinerOptionalValueFE;
});
