var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/MissingDataStrategyEditor
 */
define(['baja!', 'baja!analytics:AggregationStrategy,analytics:InterpolationAlgorithm',
// 'log!nmodule.analytics.rc.report.fe.MissingDataStrategyEditor',
'bajaux/Widget', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/webEditors/rc/fe/fe', 'lex!analytics', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, types,
//log,
Widget, events, subscriberMixIn, Promise, BaseEditor, ComplexDiff, fe, lexs) {

  'use strict';

  var lex = lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;

  // const logSevere = log.severe.bind(log);

  /**
   * Editor for working with `analytics:MissingDataStrategy` instances.
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/MissingDataStrategyEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @mixes module:bajaux/mixin/subscriberMixIn
   */

  var MissingDataStrategyEditor = function (_BaseEditor) {
    _inherits(MissingDataStrategyEditor, _BaseEditor);

    function MissingDataStrategyEditor() {
      _classCallCheck(this, MissingDataStrategyEditor);

      var _this = _possibleConstructorReturn(this, (MissingDataStrategyEditor.__proto__ || Object.getPrototypeOf(MissingDataStrategyEditor)).apply(this, arguments));

      subscriberMixIn(_this);
      return _this;
    }

    /**
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(MissingDataStrategyEditor, [{
      key: 'doInitialize',
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.addClass('MissingDataStrategyEditor');
        var aggS = lex.getSafe("missingdata.agg.strategy"),
            intpAlgorithm = lex.getSafe("missingdata.intrpl.strategy"),
            enabled = lex.getSafe("missingdata.enbld");
        dom.html('\n          <div>\n            <span class="mdh-label"><label>' + enabled + '</label></span>\n            <span class="mdhEnabler"></span>\n        </div>\n        <div>\n            <span class="mdh-label"><label>' + aggS + '</label></span>\n            <span class="aggregationStrategy"></span>\n        </div>\n        <div>\n            <span class="mdh-label"><label>' + intpAlgorithm + '</label></span>\n            <span class="interpolationAlgorithm"></span>\n        </div>\n        <div class="config" style="display: none">\n        </div>\n      ');

        dom.on(MODIFY_EVENT, '.editor', function () {
          _this2.setModified(true);
          return false;
        });

        dom.on(MODIFY_EVENT, '.interpolationAlgorithm', function (e, ed) {
          ed.read().then(function (selectedInterpolation) {
            _this2.$getConfigElement().toggle(selectedInterpolation.getOrdinal() === 2);
            return _this2.$buildConfigForInterpolation(selectedInterpolation.getTag());
          }).catch();
        });
        dom.on(MODIFY_EVENT, '.mdhEnabler', function (e, ed) {
          ed.read().then(function (mdhStatus) {
            return _this2.$toggleMDHEditors(mdhStatus);
          }).catch();
        });
        var editors = [fe.buildFor({
          dom: this.$getEnablerElement(),
          value: false,
          properties: {
            trueText: " ",
            falseText: " "
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getAggregationElement(),
          value: baja.$('analytics:AggregationStrategy'),
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getInterpolationElement(),
          value: baja.$('analytics:InterpolationAlgorithm'),
          formFactor: 'mini'
        }), this.$buildKNNConfig(1)];
        return Promise.all(editors);
      }

      /**
       * @param {Promise.<baja.Complex>} strat an `analytics:MissingDataStrategy`
       * @returns {Promise}
       */

    }, {
      key: 'doLoad',
      value: function doLoad(strat) {
        var _this3 = this;

        var intpAlgorithm = strat.get('interpolationAlgorithm');
        var loadList = [];
        var configElem = this.$getConfigElement();
        loadList.push(this.$getEnablerEditor().load(strat.getEnabled()));
        if (intpAlgorithm.getOrdinal() === 2) {
          configElem.show();
          loadList.push(this.$getKNNConfigEditor().load(strat.getKValue()));
        } else {
          configElem.hide();
        }
        loadList.push(this.$getAggregationEditor().load(strat.get('aggregationStrategy')));
        loadList.push(this.$getInterpolationEditor().load(intpAlgorithm));
        return Promise.all(loadList).then(function () {
          return _this3.$toggleMDHEditors(strat.getEnabled());
        });
      }

      /**
       * @returns {Promise.<baja.Complex>} a promise that resolves to an
       * `analytics:MissingDataStrategy` with the current user entered values
       */

    }, {
      key: 'doRead',
      value: function doRead() {
        return Promise.all([this.$getEnablerEditor().read(), this.$getAggregationEditor().read(), this.$getInterpolationEditor().read(), this.$getKNNConfigEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
              enabledVal = _ref2[0],
              aggregationStrategy = _ref2[1],
              interpolationAlgorithm = _ref2[2],
              knnValue = _ref2[3];

          if (enabledVal) {
            if (isFinite(knnValue)) {
              if (knnValue < 1 || knnValue > 30) {
                return Promise.reject(new Error(lex.get("analytics.mdc.min.max.error")));
              }
            } else {
              knnValue = 1;
            }
          }
          return baja.$('analytics:MissingDataStrategy', {
            enabled: enabledVal,
            aggregationStrategy: aggregationStrategy,
            interpolationAlgorithm: interpolationAlgorithm,
            kValue: knnValue
          });
        });
      }

      /**
       * @param {baja.Complex} readStrat the `MissingDataStrategy` with the user
       * entered values
       * @returns {Promise<baja.Complex>} promise to be resolved when the user
       * entered changes have been saved to the loaded `MissingDataStrategy`
       */

    }, {
      key: 'doSave',
      value: function doSave(readStrat) {
        var strat = this.value();
        strat.setEnabled(readStrat.getEnabled());
        strat.setAggregationStrategy(readStrat.getAggregationStrategy());
        strat.setInterpolationAlgorithm(readStrat.getInterpolationAlgorithm());
        strat.setKValue(readStrat.getKValue());
        return strat;
      }

      /**
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: 'doReadonly',
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: 'doEnabled',
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * @returns {Promise}
       */

    }, {
      key: 'doDestroy',
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Build the config for the selected interpolation.
       * @private
       * @param {string} interpolation
       * @returns {Promise}
       */

    }, {
      key: '$buildConfigForInterpolation',
      value: function $buildConfigForInterpolation(interpolation) {
        switch (interpolation) {
          case 'kNearestNeighbour':
            return this.$getKNNConfigEditor().load(this.value().getKValue());
          default:
            return Promise.resolve();
        }
      }

      /**
       * Build editor for KNN algorithm config.
       * @private
       * @returns {Promise<module:bajaux/Widget>}
       */

    }, {
      key: '$buildKNNConfig',
      value: function $buildKNNConfig(knnValue) {
        var configElement = this.$getConfigElement();
        var kValueLabel = lex.getSafe("missingdata.knn.val");
        configElement.html('<span class="mdh-label kValLbl">' + kValueLabel + '</span><span class="kValueEditor"></span>');
        //@TODO read min and max from facets
        return fe.buildFor({
          value: baja.Integer.make(knnValue),
          dom: configElement.children('.kValueEditor'),
          properties: { min: 1, max: 30, nativeHtml: true },
          formFactor: 'mini'
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: '$getAggregationElement',
      value: function $getAggregationElement() {
        return this.jq().find('.aggregationStrategy');
      }

      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: '$getConfigElement',
      value: function $getConfigElement() {
        return this.jq().children('.config');
      }

      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: '$getInterpolationElement',
      value: function $getInterpolationElement() {
        return this.jq().find('.interpolationAlgorithm');
      }

      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: '$getEnablerElement',
      value: function $getEnablerElement() {
        return this.jq().find('.mdhEnabler');
      }

      /**
       * @private
       * @returns {Widget}
       */

    }, {
      key: '$getAggregationEditor',
      value: function $getAggregationEditor() {
        if (Widget.in) {
          return Widget.in(this.$getAggregationElement());
        } else {
          return this.$getAggregationElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */

    }, {
      key: '$getInterpolationEditor',
      value: function $getInterpolationEditor() {
        if (Widget.in) {
          return Widget.in(this.$getInterpolationElement());
        } else {
          return this.$getInterpolationElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */

    }, {
      key: '$getEnablerEditor',
      value: function $getEnablerEditor() {
        if (Widget.in) {
          return Widget.in(this.$getEnablerElement());
        } else {
          return this.$getEnablerElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */

    }, {
      key: '$getKNNConfigEditor',
      value: function $getKNNConfigEditor() {
        if (Widget.in) {
          return Widget.in(this.$getConfigElement().find('.kValueEditor'));
        } else {
          return this.$getConfigElement().find('.kValueEditor').data('widget');
        }
      }
    }, {
      key: '$toggleMDHEditors',
      value: function $toggleMDHEditors(mdhStatus) {
        var aggStratEditor = this.$getAggregationEditor();
        var intpEditor = this.$getInterpolationEditor();
        var knnConfigEditor = this.$getKNNConfigEditor();
        return Promise.all([aggStratEditor.setEnabled(mdhStatus), intpEditor.setEnabled(mdhStatus), knnConfigEditor.setEnabled(mdhStatus)]);
      }
    }]);

    return MissingDataStrategyEditor;
  }(BaseEditor);

  return MissingDataStrategyEditor;
});
