/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/GroupNameFE
 */
define(['baja!', 'bajaux/Widget', 'jquery', 'underscore', 'nmodule/webEditors/rc/fe/baja/StringEditor'], function (baja, Widget, $, _, StringEditor, tplStringEditor) {

    'use strict';

    function test(ed, val) {
        if (val.length === 0) {
            throw new Error('Enter a valid group name ' + ed.existing.value[0]);
        } else {
            for (var i = 0; i < ed.length; i++) {
                if (val === ed.existing.value[i]) {
                    throw new Error('Group name already exists ' + ed.existing.value[0]);
                }
            }
        }
        return true;
    }

    /**
     * A field editor for working with strings.
     *
     * It accepts the following Properties:
     *
     * - `datalist`: (string|object) a semicolon-separated list of strings to use
     *   to generate an HTML `datalist` element. Alternatively, it can be an
     *   object literal from values to display strings; the display strings will
     *   be used to create the `datalist`, but `doRead()` will resolve the actual
     *   value if it corresponds to the entered display string. Useful for enum
     *   values with display tags, etc.
     * - `inputType`: (string) when not in multiline mode, set the `input` tag's
     *   `type` attribute. Defaults to `text`.
     * - `max`: (number) max length for the input.
     * - `min`: (number) min length for the input.
     * - `multiLine`: (boolean) if true, editor will be a `textarea`.
     * - `mustBeSlotName`: (boolean) input value must be a valid slot name.
     * - `placeholder`: (string) if given, the `placeholder` attribute of the
     *   text input will be set.
     *
     * @class
     * @extends module:nmodule/webEditors/rc/fe/baja/StringEditor
     * @alias module:nmodule/analytics/rc/report/fe/GroupNameFE
     *
     * @param {baja.Facets} [params.facets] if a semicolon-separated string
     * `datalist` facet is provided, a `<datalist>` element will be appended for
     * autocomplete purposes.
     */
    var GroupNameFE = function GroupNameFE(params) {
        var that = this;

        StringEditor.call(that, $.extend(true, {
            keyName: 'GroupNameFE'
        }, params));

        /**
         * A StringEditor will fail to validate under the following conditions:
         *
         * - `max` facet is set and the current string value is too long
         * - `min` facet is set and the current string value is too short
         * - `mustBeSlotName` facet is set and the current string value is not a
         *   valid slot name
         * @method module:nmodule/webEditors/rc/fe/baja/StringEditor#validate
         */
        that.existing = that.properties().get("names");
        that.validators().add(function (val) {
            test(this, val);
        });
    };
    GroupNameFE.prototype = Object.create(StringEditor.prototype);
    GroupNameFE.prototype.constructor = GroupNameFE;

    return GroupNameFE;
});
