/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E845876 on 5/17/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/analytics/rc/report/fe/AnalyticDegreeDayEditor', 'nmodule/analytics/rc/report/fe/DefaultNormalizationEditor', 'hbs!nmodule/analytics/rc/report/templates/UxNormalizationEditor', 'nmodule/analytics/rc/report/util/reportConstants', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, events, ComplexCompositeEditor, BooleanEditor, AnalyticDegreeDayEditor, DefaultNormalizationEditor, UxNormalizationEditor, reportConstants) {
  'use strict';

  /**
   * A field editor for selecting data tags
   * @param params
   * @constructor
   */

  var AnalyticNormalizationEditor = function AnalyticNormalizationEditor(params) {
    ComplexCompositeEditor.call(this, $.extend({
      keyName: 'AnalyticNormalizationEditor'
    }, params));
  };

  AnalyticNormalizationEditor.prototype = Object.create(ComplexCompositeEditor.prototype);

  AnalyticNormalizationEditor.prototype.constructor = AnalyticNormalizationEditor;

  AnalyticNormalizationEditor.prototype.getSlotFilter = function () {
    var that = this;
    return [{
      slot: 'areaNormalization', type: DefaultNormalizationEditor,
      properties: {
        groups: that.properties().getValue("groups")
      }
    }, {
      slot: 'degreeDayNormalization',
      type: AnalyticDegreeDayEditor,
      properties: {
        groups: that.properties().getValue("groups")
      }
    }];
  };
  /**
   * Creates the template for the data tag editor
   * Makes an RPC call to station to get the available tags
   * @param {jQuery} dom
   */
  AnalyticNormalizationEditor.prototype.doInitialize = function (dom) {
    dom.html(UxNormalizationEditor());
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Make a custom builder for ColorRangeEditor which plugs-in
   * the root DOM for individual sub editors.
   * @returns {*}
   */
  AnalyticNormalizationEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = ComplexCompositeEditor.prototype.makeBuilder.apply(that, arguments);

    builder.getDomFor = function (key) {
      var jq = that.jq(),
          elem = $(".normalize-container", jq);
      switch (key) {
        case 'areaNormalization':
          return $('.area-section', elem);
        case 'degreeDayNormalization':
          return $('.degree-day-section', elem);
      }
    };
    return builder;
  };
  /**
   * Update the properties
   */
  AnalyticNormalizationEditor.prototype.doUpdate = function (groupList) {
    var areaNormEditor = this.getChildEditors()[0];
    var degDayEditor = this.getChildEditors()[1];
    if (areaNormEditor) {
      areaNormEditor.doUpdate(groupList);
    }
    if (degDayEditor) {
      degDayEditor.doUpdate(groupList);
    }
    return Promise.resolve(true);
  };

  AnalyticNormalizationEditor.prototype.doRead = function () {
    return ComplexCompositeEditor.prototype.doRead.apply(this, arguments).then(function (readValue) {
      return Promise.resolve(readValue);
    });
  };

  return AnalyticNormalizationEditor;
});
