/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E491819 on 5/9/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/report/fe/AnalyticBaselineDetails', 'nmodule/analytics/rc/report/util/reportUtils', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, feDialogs, events, BaseEditor, AnalyticBaselineDetails, reportUtils) {
    'use strict';

    var lex = lexs[0];

    /**
     * @param params
     * @constructor
     */
    var AnalyticBaselineEditor = function AnalyticBaselineEditor(params) {
        BaseEditor.apply(this, arguments);
    };

    AnalyticBaselineEditor.prototype = Object.create(BaseEditor.prototype);

    AnalyticBaselineEditor.prototype.constructor = AnalyticBaselineEditor;

    /**
     * Creates the template for Analytic Data Tag Selector.
     * @param {jQuery} dom
     */
    AnalyticBaselineEditor.prototype.doInitialize = function (dom) {
        dom.append('<input type="checkbox" class="baseline-enabler">');
        // dom.append('<button type="button" class="ux-btn">' + lex.get('baseLine.details') + '</button>');
        dom.append('<label class="baseline-dtls">' + lex.getSafe("baseLine.details.none") + '</label>');
        dom.append('<span class="baseline-select-icon icon-icons-x16-find"></span>');
        this.$registered = false;
        return BaseEditor.prototype.doInitialize.apply(this, arguments);
    };

    /**
     *  Load the value of the tag in to the text box.
     *  Register an event on the selection button
     * @param dom
     */
    AnalyticBaselineEditor.prototype.doLoad = function (val) {
        var that = this,
            jq = that.jq(),
            baselineTogglerElem = $(".baseline-enabler", jq);
        if (val.getEnabled()) {
            baselineTogglerElem.prop('checked', true);
            that.$populateBaselineDtls(val);
        }
        if (!this.$registered) {
            this.registerEvents(val);
            this.$registered = true;
        }
        return Promise.resolve(val);
    };

    /**
     * Returns the selected data tag
     * @returns {String} the selected data tag
     */
    AnalyticBaselineEditor.prototype.doRead = function () {
        var that = this,
            jq = that.jq();
        var v = that.value();
        v.setEnabled($(".baseline-enabler", jq).prop("checked"));
        return Promise.resolve(v);
    };

    /**
     * Register events for the tag chooser editor
     */
    AnalyticBaselineEditor.prototype.registerEvents = function (val) {
        var that = this;
        var jq = that.jq();
        var props = this.properties();
        var contentDiv = props.getValue("contentDiv");
        var hasContentRoot = false;
        var feBase = {
            value: val,
            type: AnalyticBaselineDetails,
            title: lex.get("baseLine.details.title"),
            formFactor: "mini"
        };
        if (contentDiv) {
            hasContentRoot = true;
        }
        this.$offClickHandler();
        var blEnabler = $(".baseline-enabler");
        blEnabler.change(function (e) {
            var baslineDtlsElem = $(".baseline-dtls", jq);
            if ($(this).prop('checked')) {
                that.$isEnabled = true;
                that.$populateBaselineDtls(val);
            } else {
                that.$isEnabled = true;
                baslineDtlsElem.html(lex.getSafe("baseLine.details.none"));
            }
            that.setModified(true);
        });
        jq.on('click', 'span.baseline-select-icon', function () {
            if (blEnabler.prop("checked")) {
                var prop = that.properties();
                if (hasContentRoot) {
                    // Open the field editor in the content div
                    fe.buildFor($.extend(feBase, {
                        dom: contentDiv,
                        value: that.value(),
                        properties: {
                            groups: prop.getValue("groups"),
                            timeRange: prop.getValue("timeRange")
                        }
                    }));
                } else {
                    // Open the tag editor in a popup
                    feDialogs.showFor($.extend(feBase, {
                        value: that.value(),
                        properties: {
                            groups: that.properties().getValue("groups"),
                            timeRange: prop.getValue("timeRange")
                        },
                        progressCallback: function progressCallback(msg, arg) {}
                    })).then(function (baseline) {
                        if (baseline !== null) {
                            that.$populateBaselineDtls(baseline);
                            that.setModified(true);
                        }
                    }).finally(function () {});
                }
            }
        });
    };

    /**
     *
     * @param val
     */
    AnalyticBaselineEditor.prototype.$populateBaselineDtls = function (val) {
        var that = this,
            jq = that.jq();
        var baslineDtlsElem = $(".baseline-dtls", jq);
        var props = this.properties(),
            groups = props.getValue("groups");
        var node = reportUtils.getBaselineGroupName(groups, val.getGroupName()),
            color = val.getBaselineColor(),
            timeRange = val.getTimeRange();
        baslineDtlsElem.css('color', color);
        baslineDtlsElem.html(lex.getSafe({
            key: "report.area.normalized.format",
            args: [node, timeRange.getDisplayTag()]
        }));
    };

    AnalyticBaselineEditor.prototype.$offClickHandler = function () {
        var jq = this.jq();
        $("span.baseline-select-icon", jq).off();
        this.$registered = false;
    };

    /**
     * Update the properties
     */
    AnalyticBaselineEditor.prototype.doUpdate = function (groupList, timeRange) {
        var that = this;
        that.properties().setValue("groups", groupList);
        that.properties().setValue("timeRange", timeRange);
        return Promise.resolve(true);
    };

    return AnalyticBaselineEditor;
});
