/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/relcontrib/RelativeContributionChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, RelativeContributionChart, AnalyticsBaseTable, lexicon) {

  "use strict";

  var lex = lexicon[0];

  var RelativeContributionReport = function RelativeContributionReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };

  RelativeContributionReport.prototype = Object.create(AnalyticsBaseReport.prototype);

  RelativeContributionReport.prototype.constructor = RelativeContributionReport;

  RelativeContributionReport.prototype.getChartType = function () {
    return RelativeContributionChart;
  };

  RelativeContributionReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for RelativeContributionReport
   * @returns {*}
   */
  /**
   * Get the list of settings applicable for RelativeContributionReport
   * @returns {*}
   */
  RelativeContributionReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      dataTag: { req: true, value: "hs:energy" },
      // rollup: {req: true, value: "last"},
      normalization: { req: true, value: [{
          type: 'area',
          selected: false,
          value: null
        }] },
      extras: { showColorSelector: true }
    });
  };

  /**
   * Overridden Report name
   */
  RelativeContributionReport.prototype.getReportName = function () {
    return lex.get("report.relcontrib");
  };

  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  RelativeContributionReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Some child reports might support multi part rollup and data tags.
   * @returns {boolean}
   */
  RelativeContributionReport.prototype.isMultiPartSupported = function () {
    return false;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  RelativeContributionReport.prototype.getName = function () {
    return "RelativeContributionReport";
  };

  /**
   * Returns the ord scheme specific to RelativeContributionReport.s
   * @returns {string}
   */
  RelativeContributionReport.prototype.getOrdScheme = function () {
    return "analyticMultiRollup:";
  };

  return RelativeContributionReport;
});
