var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'Promise', 'jquery', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Promise, $, _, fe) {

  "use strict";

  var AnalyticsReportBuilder = {};

  /**
   * Build the report UI based on the report type and persistent data.
   * @param model
   * @param report
   */
  AnalyticsReportBuilder.buildReport = function (source, report) {
    var applicableSettings = report.getApplicableSettings();

    _.each(_.keys(applicableSettings), function (key) {
      var srcObj = source[key];
      if (srcObj) {
        if (srcObj.value) {
          applicableSettings[key].value = srcObj.value;
        }
        if (srcObj.selected) {
          applicableSettings[key].selected = srcObj.selected;
        } else {
          applicableSettings[key].selected = false;
        }
      }
    });

    return Promise.all([fe.buildFor({
      dom: report.getSettingsContainer(),
      type: report.getSettingsWidgetType(),
      value: applicableSettings,
      properties: applicableSettings.extras
    }).then(function (settings) {
      return settings;
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
          settings = _ref2[0],
          chart = _ref2[1],
          table = _ref2[2];

      var c = 'ux-fullscreen';
      settings.jq().removeClass(c);
      return settings.getMetaData().then(function (metaData) {
        return Promise.resolve({
          settings: settings,
          metaData: metaData
        });
      });
    });
  };

  /**
   * Get the configuration from the settings
   * @param settings
   */
  AnalyticsReportBuilder.getConfigFromSettings = function (settings) {};

  return AnalyticsReportBuilder;
});
