/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/command/AnalyticNodeRenameCommand
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand', 'nmodule/analytics/rc/report/util/reportWidgetEvents'], function (baja, lexs, $, Promise, feDialogs, ComponentEditorCommand, reportWidgetEvents) {

  'use strict';

  var lex = lexs[0];

  /**
   * A command for renaming slots on an editor's `Component` value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/RenameCommand
   * @param {module:bajaux/Widget} ed the `Widget` to bind this `Command` to
   * @param {baja.Component} the component on which to rename slots
   * @throws {Error} if no `Widget` provided
   */
  var AnalyticViewReportsCommand = function AnalyticViewReportsCommand(ed, component) {
    var that = this;
    that.$ed = ed;
    ComponentEditorCommand.call(that, {
      displayName: lex.get('report.list.view')
    }, component);
  };

  AnalyticViewReportsCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  AnalyticViewReportsCommand.prototype.constructor = AnalyticViewReportsCommand;

  /**
   * Make sure we have admin write permissions and we're not renaming a
   * frozen slot.
   *
   * @param {baja.Component} comp
   * @param {baja.Slot} slot
   * @returns {Boolean} true if I can rename this slot
   */
  AnalyticViewReportsCommand.prototype.canPerformCommand = function (comp, slot) {
    return true; // Return true for now
  };

  /**
   * Shows a dialog for the component's currently configured slot name,
   * and renames the slot after the user clicks OK.
   *
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots the slots to rename (*Note*: only the
   * first given slot will be renamed)
   * @returns {Promise}
   */
  AnalyticViewReportsCommand.prototype.performCommand = function (node, slots, params) {
    return Promise.resolve(node);
  };

  return AnalyticViewReportsCommand;
});
