var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/base/JSONAnalyticReportConfigEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'dialogs', 'underscore', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaScript/baja/obj/UnitDatabase', 'nmodule/analytics/rc/report/base/AnalyticReportConfigEditor', 'baja!analytics:AnalyticCompositeConfiguration,analytics:AnalyticReportConfiguration,analytics:AnalyticConfigurationItem,' + 'analytics:ColorRange,analytics:Interval,analytics:NormalizationConfig,analytics:Normalization,analytics:DegreeDayNormalization,' + 'analytics:AnalyticReportTimeRange,analytics:AnalyticDaysOfWeekBits,analytics:AnalyticMultiBindingReportConfiguration,' + 'analytics:AnalyticRollupDataTagItem,analytics:DegreeDayUnits,analytics:DegreeDayType,' + 'analytics:AnalyticBaselineDetails,analytics:BaselineTimeRangeEnum,analytics:MissingDataStrategy,analytics:C3LegendType', 'nmodule/analytics/rc/report/util/reportConstants', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, $, Promise, Widget, subscriberMixIn, dialogs, _, events, BaseEditor, fe, UnitDatabase, AnalyticReportConfigEditor, types, reportConstants) {

    'use strict';

    /**
     * @class
     * @alias module:nmodule/analytics/rc/report/base/JSONAnalyticReportConfigEditor
     * @extends module:nmodule/analytics/rc/report/base/AnalyticReportConfigEditor
     */

    var JSONAnalyticReportConfigEditor = function JSONAnalyticReportConfigEditor() {
        AnalyticReportConfigEditor.apply(this, arguments);
    };
    /**
     * Attach the parent's prototye and change the constructor and overidden methods
     * @type {BaseEditor}
     */
    JSONAnalyticReportConfigEditor.prototype = Object.create(AnalyticReportConfigEditor.prototype);

    // Setting the constructor
    JSONAnalyticReportConfigEditor.prototype.constructor = JSONAnalyticReportConfigEditor;

    /**
     * Get the combination configuration.
     * @param combination
     * @returns {*}
     */
    function getCombinationConfig(combination, req, selected) {
        var combinationItem = baja.$("analytics:AnalyticConfigurationItem");
        combinationItem.setPropertyRequired(req);
        if (combination === "") {
            combinationItem.setPropertyValue(baja.$("analytics:Combination"));
        } else {
            combinationItem.setPropertyValue(baja.$("analytics:Combination").make(combination));
        }
        combinationItem.setSelected(selected);
        return combinationItem;
    }

    /**
     * Initalize the Node selection FE with blank node group place holder
     * @param dom
     */
    JSONAnalyticReportConfigEditor.prototype.doInitialize = function (dom) {
        return AnalyticReportConfigEditor.prototype.doInitialize.apply(this, arguments);
    };

    /**
     *
     * @param {baja.Folder} folder a `baja:Folder` value, which contains a list
     * of 'analytics:AnalyticNodeGroup'
     */
    JSONAnalyticReportConfigEditor.prototype.doLoad = function (json) {
        var that = this;
        return that.getConfigFromJSON(json || "{}").then(function (comp) {
            arguments[0] = that.$comp = comp;
            return AnalyticReportConfigEditor.prototype.doLoad.apply(that, arguments);
        });
    };

    /**
     * Read the value from parent and serialize to JSON
     * @param root
     * @returns {Promise|*}
     */
    JSONAnalyticReportConfigEditor.prototype.doRead = function () {
        var that = this;
        return AnalyticReportConfigEditor.prototype.doRead.apply(this, arguments).then(function (comp) {
            var ret = {};
            ret = that.getJSONFromConfig(comp);
            return Promise.resolve(ret);
        });
    };

    /**
     * Set all child editors readonly/writable.
     *
     * @param {Boolean} readonly
     * @returns {Promise}
     */
    JSONAnalyticReportConfigEditor.prototype.doReadonly = function (readonly) {
        return this.getChildEditors().setAllReadonly(readonly);
    };

    /**
     * Set all child editors enabled/disabled.
     *
     * @param {Boolean} enabled
     * @returns {Promise}
     */
    JSONAnalyticReportConfigEditor.prototype.doEnabled = function (enabled) {
        return this.getChildEditors().setAllEnabled(enabled);
    };

    /**
     * Destroy all child editors.
     *
     * @returns {Promise}
     */
    JSONAnalyticReportConfigEditor.prototype.doDestroy = function () {
        return this.getChildEditors().destroyAll();
    };

    /**
     * Return the JSON config string from the report component
     * @param configJSONStr
     * @returns {JSONAnalyticReportConfigEditor}
     */
    JSONAnalyticReportConfigEditor.prototype.getJSONFromConfig = function (config) {
        return AnalyticReportConfigEditor.prototype.getJSONFromConfig.apply(this, arguments);
    };

    /**
     * This function converts the JSON string to baja Folder heirarchy
     */
    JSONAnalyticReportConfigEditor.prototype.getConfigFromJSON = function (configJSON) {
        var that = this;
        var jsonObj = {};
        if (typeof configJSON === "string") {
            jsonObj = JSON.parse(configJSON || {});
        } else if ((typeof configJSON === 'undefined' ? 'undefined' : _typeof(configJSON)) === "object") {
            jsonObj = configJSON;
        }
        var configuration = baja.$(jsonObj.configType);
        return this.$getUnitsConfig(jsonObj).then(function (bunit) {
            configuration.setUnits(bunit);
            // Node config
            configuration.setNode(that.$getNodeConfig(jsonObj));
            // Data Tag
            configuration.setDataTag(that.$getDataTagConfig(jsonObj));
            // Time Range
            configuration.setTimeRange(that.$getTimeRangeConfig(jsonObj));
            // Interval
            configuration.setInterval(that.$getIntervalConfig(jsonObj));
            // Baseline
            configuration.setBaseline(that.$getBaselineConfig(jsonObj));
            // Rollup
            configuration.setRollup(that.$getRollupConfig(jsonObj));
            // Aggregation
            configuration.setAggregation(that.$getAggregationConfig(jsonObj));
            // Data Filter
            configuration.setDataFilter(that.$getDataFilterConfig(jsonObj));
            // Color Range
            configuration.setColorRange(that.$getColorRangeConfig(jsonObj));
            // Normalization
            configuration.setNormalizationConfig(that.$getNormalizationConfig(jsonObj));
            // His totalization
            configuration.setHisTotEnabled(that.$getHisTotEnabled(jsonObj));
            //Interpolation Status
            configuration.setInterpolationStatus(that.$getInterpolationStatus(jsonObj));
            // Legend Position
            configuration.setLegendPosition(that.$getLegendPosition(jsonObj));
            // Do the rollup data tag map set, only if configuration supports.
            if (configuration.setRollupDataTagMap) {
                configuration.setRollupDataTagMap(that.$getRollupDataTagMap(jsonObj));
                if (configuration.setChartValue) {
                    configuration.setChartValue(that.$getChartValue(jsonObj));
                }
            }
            // Missing data strategy
            configuration.setMissingDataStrategy(that.$getMissingDataConfig(jsonObj));
            return Promise.resolve(configuration);
        });
    };

    /**
     * Destroy all child editors.
     *
     * @returns {Promise}
     */
    JSONAnalyticReportConfigEditor.prototype.doDestroy = function () {
        var that = this;
        that.jq().remove();
        return AnalyticReportConfigEditor.prototype.doDestroy.apply(this, arguments);
    };

    /**
     * Get the node config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getNodeConfig = function (jsonObj) {
        var nodeConfig = jsonObj.node,
            node = nodeConfig && nodeConfig.value ? nodeConfig.value : reportConstants.DEFAULT_NODE;
        var nodeConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        nodeConfigItem.setPropertyValue(node);
        nodeConfigItem.setPropertyRequired(true);
        return nodeConfigItem;
    };

    /**
     * Get the data tag config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getDataTagConfig = function (jsonObj) {
        var dataTagConfig = jsonObj.dataTag,
            dataTag = dataTagConfig && dataTagConfig.value ? dataTagConfig.value : reportConstants.DEFAULT_DATATAG,
            dataTagReq = dataTag && dataTagConfig.req !== undefined ? dataTagConfig.req : true;
        var dataTagConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        dataTagConfigItem.setPropertyValue(dataTag);
        dataTagConfigItem.setPropertyRequired(dataTagReq);
        return dataTagConfigItem;
    };

    /**
     * Get the time range config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getTimeRangeConfig = function (jsonObj) {
        var timeRangeConfig = jsonObj.timeRange,
            timeRange = timeRangeConfig && timeRangeConfig.value ? timeRangeConfig.value : reportConstants.DEFAULT_TIMERANGE;
        var timeRangeConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        timeRangeConfigItem.setPropertyRequired(true);
        var tr = baja.$("analytics:AnalyticReportTimeRange");
        if (_.isString(timeRange)) {
            tr.setTimeRange(timeRange);
            tr.setDow(baja.$("analytics:AnalyticDaysOfWeekBits").make(reportConstants.ALL_DAYS_SELECTED_BITS));
        } else {
            tr.setTimeRange(timeRange.tr || "today");
            tr.setDow(baja.$("analytics:AnalyticDaysOfWeekBits").make(timeRange.dow || reportConstants.ALL_DAYS_SELECTED_BITS));
        }
        timeRangeConfigItem.setPropertyValue(tr);
        return timeRangeConfigItem;
    };

    /**
     * Get the interval config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getIntervalConfig = function (jsonObj) {
        var intervalConfig = jsonObj.interval,
            interval = intervalConfig && intervalConfig.value ? intervalConfig.value : reportConstants.DEFAULT_INTERVAL,
            intervalReq = intervalConfig && intervalConfig.req ? intervalConfig.req : false;
        var intervalConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        intervalConfigItem.setPropertyRequired(intervalReq);
        var selected = intervalConfig.selected ? interval !== "" : false;
        if (interval === "") {
            intervalConfigItem.setPropertyValue(baja.$("analytics:Interval"));
        } else {
            intervalConfigItem.setPropertyValue(baja.$("analytics:Interval").make(interval));
        }
        intervalConfigItem.setSelected(selected);
        return intervalConfigItem;
    };

    /**
     * Get the baseline config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getBaselineConfig = function (jsonObj) {
        var baselineConfig = jsonObj.baseline,
            baseline = baselineConfig && baselineConfig.value ? baselineConfig.value : null,
            baselineReq = baselineConfig && baselineConfig.req ? baselineConfig.req : false;
        var baselineConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        var baselineDetails = baja.$("analytics:AnalyticBaselineDetails");
        if (baseline !== null && _.isObject(baseline)) {
            var blEnabled = baseline.enabled || false;
            baselineDetails.setEnabled(blEnabled);
            if (blEnabled) {
                baselineDetails.setGroupName(baseline.group);
                baselineDetails.setBaselineColor(baja.$("gx:Color").make(baseline.color));
                baselineDetails.setTimeRange(baja.$("analytics:BaselineTimeRangeEnum").make(baseline.timeRange));
                if (baseline.startTime) {
                    baselineDetails.setStartTime(baja.$("baja:AbsTime").decodeFromString(baseline.startTime));
                }
                if (baseline.endTime) {
                    baselineDetails.setEndTime(baja.$("baja:AbsTime").decodeFromString(baseline.endTime));
                }
                baselineDetails.setEndTimeEnabled(baseline.endTimeEnabled || false);
                baselineDetails.setAlignDOW(baseline.alignDOW || false);
            }
        }
        baselineConfigItem.setPropertyValue(baselineDetails);
        baselineConfigItem.setPropertyRequired(baselineReq);
        return baselineConfigItem;
    };

    /**
     * Get the Color range config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getColorRangeConfig = function (jsonObj) {
        var colorRangeConfig = jsonObj.colorRange,
            colorRange = colorRangeConfig && colorRangeConfig.value ? colorRangeConfig.value : null,
            colorRangeReq = colorRangeConfig && colorRangeConfig.req ? colorRangeConfig.req : false;
        var colorRangeConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        var colorRangeObj = baja.$("analytics:ColorRange");
        if (colorRange !== null) {
            colorRangeObj.setMinValueColor(baja.$("gx:Color").make(colorRange.minColor));
            colorRangeObj.setMaxValueColor(baja.$("gx:Color").make(colorRange.maxColor));
            colorRangeObj.setAvgValueColor(baja.$("gx:Color").make(colorRange.avgColor));
        }
        colorRangeConfigItem.setPropertyValue(colorRangeObj);
        colorRangeConfigItem.setPropertyRequired(colorRangeReq);
        return colorRangeConfigItem;
    };

    /**
     * Get the Normalization config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getNormalizationConfig = function (jsonObj) {
        var normalizationConfig = jsonObj.normalization,
            normalizations = normalizationConfig && normalizationConfig.value ? normalizationConfig.value : null;
        var normalizationReq = normalizationConfig && normalizationConfig.req ? normalizationConfig.req : false;
        var normalizationConfigItem = baja.$("analytics:AnalyticConfigurationItem");

        var cfg = baja.$("analytics:NormalizationConfig");

        function getNodeMapping(n) {
            var map = baja.$("baja:Component");
            var mappings = n.mapping || [];
            for (var j = 0; j < mappings.length; j++) {
                var mapping = mappings[j];
                var tagItem = baja.$("analytics:AnalyticDegreeDayNodeItem");
                tagItem.setGroupName(baja.SlotPath.unescape(mapping.gn));
                tagItem.setDegDayRoot(baja.Ord.make(mapping.ord));
                tagItem.setGuid(mapping.guid);
                map.add(tagItem);
            }
            return map;
        }

        if (normalizations !== null) {
            for (var i = 0; i < normalizations.length; i++) {
                var n = normalizations[i];
                if (n.type === "area") {
                    var areaCfg = baja.$("analytics:Normalization");
                    areaCfg.setSelected(n.selected);
                    areaCfg.setGroupMapping(getNodeMapping(n));
                    cfg.setAreaNormalization(areaCfg);
                } else if (n.type === "degreeday") {
                    var degreeDayCfg = baja.$("analytics:DegreeDayNormalization");
                    degreeDayCfg.setSelected(n.selected);
                    degreeDayCfg.setValue(n.value);
                    degreeDayCfg.setValueUnits(baja.$("analytics:DegreeDayUnits").make(n.unit));
                    degreeDayCfg.setDdtype(baja.$("analytics:DegreeDayType").make(n.ddtype || 0));
                    degreeDayCfg.setGroupMapping(getNodeMapping(n));
                    cfg.setDegreeDayNormalization(degreeDayCfg);
                }
            }
        }
        normalizationConfigItem.setPropertyValue(cfg);
        normalizationConfigItem.setPropertyRequired(normalizationReq);
        return normalizationConfigItem;
    };

    /**
     * Get the rollup config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getRollupConfig = function (jsonObj) {
        var rollupConfig = jsonObj.rollup,
            rollup = rollupConfig && rollupConfig.value ? rollupConfig.value : reportConstants.DEFAULT_ROLLUP; // Read from constants
        var selected = rollupConfig.selected ? rollup !== "" : false;
        return getCombinationConfig(rollup, rollupConfig && rollupConfig.req !== undefined ? rollupConfig.req : true, selected);
    };

    /**
     * Get the aggregation config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getAggregationConfig = function (jsonObj) {
        var aggregationConfig = jsonObj.aggregation,
            aggregation = aggregationConfig && aggregationConfig.value ? aggregationConfig.value : reportConstants.DEFAULT_AGGREGATION;
        var selected = aggregationConfig.selected ? aggregation !== "" : false;
        return getCombinationConfig(aggregation, aggregationConfig && aggregationConfig.req !== undefined ? aggregationConfig.req : true, selected);
    };

    /**
     * Get the data tag config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getUnitsConfig = function (jsonObj) {
        var unitsConfig = jsonObj.units,
            units = unitsConfig && unitsConfig.value ? unitsConfig.value : reportConstants.DEFAULT_UNITS;
        var unitConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        unitConfigItem.setPropertyRequired(unitsConfig.req);
        if (units !== reportConstants.DEFAULT_UNITS) {
            unitConfigItem.setPropertyValue(baja.$("baja:Unit").decodeFromString(units));
            return Promise.resolve(unitConfigItem);
        } else {
            unitConfigItem.setPropertyValue(baja.Unit.NULL);
            return Promise.resolve(unitConfigItem);
        }
    };

    /**
     * Get the data tag config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getDataFilterConfig = function (jsonObj) {
        var dataFilterConfig = jsonObj.dataFilter,
            dataFilter = dataFilterConfig && dataFilterConfig.value ? dataFilterConfig.value : "";
        var dataFilterConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        dataFilterConfigItem.setPropertyValue(dataFilter);
        dataFilterConfigItem.setPropertyRequired(dataFilterConfig && dataFilterConfig.req || false);
        return dataFilterConfigItem;
    };

    /**
     * Get the chart value config item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getChartValue = function (jsonObj) {
        var chartValueCfg = jsonObj.chartValue,
            chartValue = chartValueCfg && chartValueCfg.value ? chartValueCfg.value : reportConstants.DEFAULT_CHART_PLOT_VALUE;
        var chartValueItem = baja.$("analytics:AnalyticConfigurationItem");
        chartValueItem.setPropertyValue(chartValue);
        chartValueItem.setPropertyRequired(chartValueCfg.req);
        return chartValueItem;
    };

    /**
     * Get the combination data map item
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getRollupDataTagMap = function (jsonObj) {
        var combinationDataConfig = jsonObj.combinationMap,
            combinationData = combinationDataConfig && combinationDataConfig.value ? combinationDataConfig.value : {};
        var combinationDataConfigItem = baja.$("analytics:AnalyticConfigurationItem");
        var map = baja.$("analytics:AnalyticRollupDataTagMap");

        for (var key in combinationData) {
            if (combinationData.hasOwnProperty(key)) {
                var tagUnitList = combinationData[key];
                addItemToMap(tagUnitList, map, key);
            }
        }
        combinationDataConfigItem.setPropertyValue(map);
        combinationDataConfigItem.setPropertyRequired(combinationDataConfig.req);
        return combinationDataConfigItem;
    };

    /**
     *
      * @param jsonObj
     * @return {*}
     */
    JSONAnalyticReportConfigEditor.prototype.$getLegendPosition = function (jsonObj) {
        var legendPositionConfig = jsonObj.legendPosition,
            legend = legendPositionConfig && legendPositionConfig.value ? legendPositionConfig.value : reportConstants.DEFAULT_LEGEND_POSITION,
            legendReq = legendPositionConfig && legendPositionConfig.req ? legendPositionConfig.req : false;
        var legendItem = baja.$("analytics:AnalyticConfigurationItem");
        legendItem.setPropertyValue(baja.$("analytics:C3LegendType").make(legend));
        legendItem.setPropertyRequired(legendReq);
        return legendItem;
    };

    /**
     *
     * @param jsonObj
     * @return {*}
     */
    JSONAnalyticReportConfigEditor.prototype.$getHisTotEnabled = function (jsonObj) {
        var hisTotConfig = jsonObj.hisTotEnabled,
            hisTotEnabled = hisTotConfig && hisTotConfig.value ? hisTotConfig.value : true,
            hisTotReq = hisTotConfig && hisTotConfig.req ? hisTotConfig.req : false;
        var hisTotItem = baja.$("analytics:AnalyticConfigurationItem");
        hisTotItem.setPropertyValue(baja.$("baja:Boolean").decodeFromString(hisTotEnabled));
        hisTotItem.setPropertyRequired(hisTotReq);
        return hisTotItem;
    };

    /**
     *
     * @param jsonObj
     * @return {*}
     */
    JSONAnalyticReportConfigEditor.prototype.$getInterpolationStatus = function (jsonObj) {
        var interpolationStatusConfig = jsonObj.interpolationStatus,
            interpolationStatus = interpolationStatusConfig && interpolationStatusConfig.value ? interpolationStatusConfig.value : true,
            interpolationReq = interpolationStatusConfig && interpolationStatusConfig.req ? interpolationStatusConfig.req : false;
        var interpolationStatusItem = baja.$("analytics:AnalyticConfigurationItem");
        interpolationStatusItem.setPropertyValue(baja.$("baja:Boolean").decodeFromString(interpolationStatus));
        interpolationStatusItem.setPropertyRequired(interpolationReq);
        return interpolationStatusItem;
    };

    /**
     * Get the missing data configuration from the JSON object.
     * @param jsonObj
     */
    JSONAnalyticReportConfigEditor.prototype.$getMissingDataConfig = function (jsonObj) {
        var missingDataCfg = jsonObj.mdConfig,
            missingDataStrategy = missingDataCfg && missingDataCfg.value ? missingDataCfg.value : reportConstants.DEFAULT_MISSING_DATA_CFG;
        var missingDataItem = baja.$("analytics:AnalyticConfigurationItem");
        var aggSt = baja.$("analytics:AggregationStrategy").make(missingDataStrategy.aggStrategy);
        var intpAlgorithm = baja.$("analytics:InterpolationAlgorithm").make(missingDataStrategy.intpAlgorithm);
        var enabled = missingDataStrategy.enabled || false;
        var mdStrategy = baja.$("analytics:MissingDataStrategy", {
            enabled: enabled,
            aggregationStrategy: aggSt,
            interpolationAlgorithm: intpAlgorithm,
            kValue: missingDataStrategy.knnValue
        });
        missingDataItem.setPropertyValue(mdStrategy);
        missingDataItem.setPropertyRequired(true);
        return missingDataItem;
    };

    function addItemToMap(tagUnitList, map, key) {
        _.each(tagUnitList, function (tag, i) {
            var tagItem = baja.$("analytics:AnalyticRollupDataTagItem");
            tagItem.setRollup(baja.$("analytics:Combination").make(key));
            if (_.isObject(tag)) {
                tagItem.setDataTag(tag.tag);
                tagItem.setUnits(baja.$("baja:Unit").decodeFromString(tag.unit));
            } else {
                // We can safeuly assume it is string
                tagItem.setDataTag(tag);
                tagItem.setUnits(baja.Unit.DEFAULT);
            }
            map.add(tagItem);
        });
    }

    return JSONAnalyticReportConfigEditor;
});
