/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['jquery', 'bajaux/dragdrop/dragDropUtils', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/analyticEvents', 'lex!analytics'], function ($, dragDropUtils, analyticsUtil, analyticEvents, lexicon) {
  "use strict";

  var AnalyticsChartDragDropUtils = {},
      DRAG_ENABLER_CLASS = 'analytics-dashboard-widget-drag-over',
      lex = lexicon[0];
  /**
   * Register a drag  drop handler for the chart
   */
  AnalyticsChartDragDropUtils.registerDragDrop = function (element, drophandler) {
    element.on('dragover', function (e) {
      element.addClass(DRAG_ENABLER_CLASS);
      e.preventDefault();
    }).on('dragleave', function (e) {
      element.removeClass(DRAG_ENABLER_CLASS);
      e.preventDefault();
    }).on('drop', function (e) {
      element.removeClass(DRAG_ENABLER_CLASS);
      if (drophandler && $.isFunction(drophandler)) {
        drophandler(e);
      }
      e.preventDefault();
      e.stopPropagation();
    });
  };
  /**
   * Handle the drop of any nav node on to the chart area.
   * The nav node will be serialized to a JSON and passed to the view for chart rendering.
   */
  AnalyticsChartDragDropUtils.handleChartDrop = function (chartView, dataTransfer) {
    return dragDropUtils.fromClipboard(dataTransfer).then(function (envelope) {
      switch (envelope.getMimeType()) {
        case 'niagara/navnodes':
          envelope.toJson().then(function (json) {
            var obj = json && json[0];
            if (obj && obj.ord) {
              if (analyticsUtil.isNodeExists(obj.ord, chartView)) {
                analyticsUtil.showError(lex.get("node.alreadyExists"));
                return;
              } else {
                chartView.$isDragDropInvoked = true;
                chartView.$isDataLimitReached = false;
                chartView.jq().find('.trCmdBar').trigger(analyticEvents.DROP_ACTION_PERFORMED);
                return chartView.load(obj);
              }
            }
          });
      }
    });
  };

  return AnalyticsChartDragDropUtils;
});
