/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the analytic tables
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE', 'nmodule/analytics/rc/chart/fe/AnalyticOptionalValueFE', 'nmodule/analytics/rc/report/fe/AnalyticDayOfWeekEditor', 'nmodule/analytics/rc/report/fe/MissingDataStrategyEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'hbs!nmodule/analytics/rc/chart/templates/fe/tableWebChartSettings', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor', 'nmodule/webChart/rc/fe/color/ColorEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, AnalyticUxWebChartSettingsFE, AnalyticOptionalValueFE, AnalyticDayOfWeekEditor, MissingDataStrategyEditor, BooleanEditor, tableWebChartSettings, lexicon, types, ColorEditor) {
  'use strict';

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var TableUxWebChartSettingsFE = function TableUxWebChartSettingsFE() {
    AnalyticUxWebChartSettingsFE.apply(this, arguments);
  };

  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  TableUxWebChartSettingsFE.prototype = Object.create(AnalyticUxWebChartSettingsFE.prototype);
  //Setting the constructor
  TableUxWebChartSettingsFE.prototype.constructor = TableUxWebChartSettingsFE;

  /**
   * Creates the necessary setting fields for configuring analytic web chart
   * @param {jQuery} dom
   */
  TableUxWebChartSettingsFE.prototype.doInitialize = function (dom) {
    // Load all properties in to the template
    dom.html(tableWebChartSettings({
      interval: lex.get("interval"),
      rollup: lex.get("rollup"),
      aggregation: lex.get("aggregation"),
      unit: lex.get("unit"),
      data: lex.get("data"),
      dataFilter: lex.get("dataFilter"),
      daysToExclude: lex.get("daysToExclude"),
      seriesName: lex.get("seriesName"),
      hisTotEnabled: lex.get("hisTotEnabled"),
      mdhStrategy: lex.get("missingDataStrategy")
    }));
  };

  /**
   * Prepare the field editors that only table needs.
   * @param settingsObj
   * @returns {Array}
   */
  TableUxWebChartSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var fes = [],
        msg = lex.get("testTotalizeNeql.message");
    fes.push({
      dom: $(".intervalFE", that.jq()),
      value: { value: settingsObj.getInterval().getValue(), isSelected: settingsObj.getInterval().getSelected() },
      formFactor: 'mini',
      type: AnalyticOptionalValueFE,
      keyName: "interval"
    }, {
      dom: $(".rollupFE", that.jq()),
      value: { value: settingsObj.getRollup().getValue(), isSelected: settingsObj.getRollup().getSelected() },
      type: AnalyticOptionalValueFE,
      formFactor: 'mini',
      keyName: "rollup"
    }, {
      dom: $(".aggregationFE", that.jq()),
      value: { value: settingsObj.getAggregation().getValue(), isSelected: settingsObj.getAggregation().getSelected() },
      type: AnalyticOptionalValueFE,
      formFactor: 'mini',
      keyName: "aggregation"
    }, {
      dom: $(".dataFE", that.jq()),
      type: AnalyticDataEditor,
      value: settingsObj.getData(),
      formFactor: 'mini',
      keyName: "data"
    }, {
      dom: $(".dataFilterFE", that.jq()),
      value: settingsObj.getDataFilter(),
      formFactor: 'mini',
      keyName: "dataFilter"
    }, {
      dom: $(".daysToExcludeFE", that.jq()),
      type: AnalyticDayOfWeekEditor,
      value: settingsObj.getDaysToExclude(),
      keyName: "daysToExclude"
    }, {
      dom: $(".seriesName", that.jq()),
      value: settingsObj.getSeriesNameBFormat(),
      formFactor: 'mini',
      keyName: "seriesNameBFormat"
    }, {
      dom: $(".hisTotEnabledFE", that.jq()),
      type: BooleanEditor,
      value: settingsObj.getHisTotEnabled(),
      properties: {
        trueText: msg, falseText: msg
      },
      keyName: "hisTotEnabled"
    }, {
      dom: $(".mdhStrategy", that.jq()),
      type: MissingDataStrategyEditor,
      value: settingsObj.getMissingDataStrategy(),
      keyName: "missingDataStrategy"
    });
    return fes;
  };

  return TableUxWebChartSettingsFE;
});
