/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxConfigurationSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticEqOpChartConfiguration', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor', 'nmodule/webChart/rc/fe/color/ColorEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, AnalyticUxConfigurationSettingsFE, analyticEqOpChartConfiguration, lexicon, types, ColorEditor) {
  'use strict';

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var EqOpConfigurationSettingsFE = function EqOpConfigurationSettingsFE() {
    AnalyticUxConfigurationSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  EqOpConfigurationSettingsFE.prototype = Object.create(AnalyticUxConfigurationSettingsFE.prototype);
  //Setting the constructor
  EqOpConfigurationSettingsFE.prototype.constructor = EqOpConfigurationSettingsFE;

  /**
   *
   * @param dom
   * include: "<tr class='ux-table-row'> <td> <label>Show On/Off</label>  </td> <td> <div class='onOffFE'></div> </td> </tr>"}
   */
  EqOpConfigurationSettingsFE.prototype.getFields = function (obj) {
    obj.include = analyticEqOpChartConfiguration({ offStatus: lex.get("offStatus") });
    return obj;
  };

  /**
   * Build Field Editors
   * @param settingsObj
   * @returns {Array Promise}
   */
  EqOpConfigurationSettingsFE.prototype.initFieldEditors = function (settingsObj, fieldEditorList) {
    var that = this;
    var arr = AnalyticUxConfigurationSettingsFE.prototype.initFieldEditors.apply(that, [settingsObj]);
    arr.push({
      dom: $(".offStatusFE", that.jq()),
      value: settingsObj.getOffStatus(),
      keyName: "offStatus",
      formFactor: "mini"
    });
    return arr;
  };

  return EqOpConfigurationSettingsFE;
});
