/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'underscore', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/chart/fe/AnalyticUxConfigurationSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticC3Configuration', 'lex!baja,analytics'], function (baja, Widget, subscriberMixIn, Promise, $, moment, _, dialogs, events, fe, feDialogs, AnalyticUxConfigurationSettingsFE, analyticC3Configuration, lexicon) {

  "use strict";

  var lex = lexicon[1];

  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var C3ConfigurationSettingsFE = function C3ConfigurationSettingsFE() {
    AnalyticUxConfigurationSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  C3ConfigurationSettingsFE.prototype = Object.create(AnalyticUxConfigurationSettingsFE.prototype);
  //Setting the constructor
  C3ConfigurationSettingsFE.prototype.constructor = C3ConfigurationSettingsFE;

  /**
   *
   * @param dom
   * include: "<tr class='ux-table-row'> <td> <label>Show On/Off</label>  </td> <td> <div class='onOffFE'></div> </td> </tr>"}
   */
  C3ConfigurationSettingsFE.prototype.getFields = function (obj) {
    obj.include = analyticC3Configuration({ legendPosition: lex.get("legendPosition") });
    return obj;
  };

  /**
   * Build Field Editors
   * @param settingsObj
   * @returns {Array Promise}
   */
  C3ConfigurationSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var arr = AnalyticUxConfigurationSettingsFE.prototype.initFieldEditors.apply(that, [settingsObj]);
    arr.push({
      dom: $(".legendPositionFE", that.jq()),
      value: settingsObj.getLegendPosition(),
      formFactor: 'mini',
      keyName: "legendPosition"
    });
    return arr;
  };

  return C3ConfigurationSettingsFE;
});
