/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'underscore', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticBaseChartConfiguration', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor', 'nmodule/webChart/rc/fe/color/ColorEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, _, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, analyticBaseChartConfiguration, lexicon, types, ColorEditor) {
  'use strict';

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var AnalyticUxConfigurationSettingsFE = function AnalyticUxConfigurationSettingsFE() {
    BaseEditor.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  AnalyticUxConfigurationSettingsFE.prototype = Object.create(BaseEditor.prototype);
  //Setting the constructor
  AnalyticUxConfigurationSettingsFE.prototype.constructor = AnalyticUxConfigurationSettingsFE;

  /**
   * Creates the necessary setting fields for configuring analytic web chart
   * @param {jQuery} dom
   */
  AnalyticUxConfigurationSettingsFE.prototype.doInitialize = function (dom) {
    var that = this;
    that.fieldEditorList = [];
    // Load all properties in to the template
    dom.html(that.getTemplate()(that.$getFields()));
  };

  /**
   * Returns the template for the base configuration.
   * Children should override with their template.
   * @param dom
   * @returns {*}
   */
  AnalyticUxConfigurationSettingsFE.prototype.getTemplate = function () {
    return analyticBaseChartConfiguration;
  };

  /**
   * Child tab configuration classes use the below and pass their html to include it in the parent FE hbs.
   * Parent hbs is capable enough to insert the child hbs.
   * return something similar to the below from getFields Method at the child level.
   * {include: "<tr class='ux-table-row'> <td> <label>Show On/Off</label>  </td> <td> <div class='onOffFE'></div> </td> </tr>"}
   * @param dom
   */
  AnalyticUxConfigurationSettingsFE.prototype.$getFields = function () {
    return this.getFields({
      fontSize: lex.get("fontSize")
    });
  };

  /**
   *
   * @param dom
   */
  AnalyticUxConfigurationSettingsFE.prototype.getFields = function (obj) {
    // Abstract method left out for the children to implement.
    return obj;
  };

  /**
   * Loads a `{analytics.AnalyticUxWebChartParams` into web UI.
       * format.
       *
   * @param {baja.Component} settingsObj an `analytics:AnalyticUxWebChartParams`
   * @returns {Promise} promise to be resolved if the value is loaded,
   * or rejected if the `analytics.AnalyticUxWebChartParams` could not be encoded to its type
   */
  AnalyticUxConfigurationSettingsFE.prototype.doLoad = function (settingsObj) {
    var that = this;
    that.settingsObj = settingsObj;
    that.jq().data("widget", that);
    return that.buildFieldEditors(settingsObj);
  };

  /**
   * Reads the  value from the settings user interface and constructs a
   * `analytics.AnalyticUxWebChartParams` from it.
   *
   * @returns {{analytics.AnalyticUxWebChartParams} the read `{analytics.AnalyticUxWebChartParams` value
   * @throws {Error} if the input contains an invalid date value.
   */
  AnalyticUxConfigurationSettingsFE.prototype.doRead = function () {
    var that = this;
    var promArray = [];
    _.each(that.getChildEditors(), function (ce) {
      promArray.push(ce.read().then(function (val) {
        if (ce.$keyName === "exclusionList") {
          that.settingsObj["set" + ce.$keyName.capitalizeFirstLetter()](val.toString());
        } else {
          that.settingsObj["set" + ce.$keyName.capitalizeFirstLetter()](val);
        }
        return Promise.resolve(true);
      }));
    });
    return Promise.all(promArray).then(function (vals) {
      return that.settingsObj;
    });
  };
  /**
   * save callback handler
   * @param value
   * @param params
   */
  AnalyticUxConfigurationSettingsFE.prototype.doSave = function (value, params) {};
  /**
   * Enables or disables the settings UI.
   *
   * @param {Boolean} enabled
   */
  AnalyticUxConfigurationSettingsFE.prototype.doEnabled = function (enabled) {
    this.$getDataElement().prop('disabled', !enabled || this.isReadonly());
  };

  /**
   * Enables or disables the settings UI.
   * @param {Boolean} readonly
   */
  AnalyticUxConfigurationSettingsFE.prototype.doReadonly = function (readonly) {
    this.$getDataElement().prop('disabled', readonly || !this.isEnabled());
  };

  AnalyticUxConfigurationSettingsFE.prototype.$getDataElement = function () {
    return this.jq();
  };

  /**
   * Build Field Editors
   * @param settingsObj
   * @returns {Array Promise}
   */
  AnalyticUxConfigurationSettingsFE.prototype.buildFieldEditors = function (settingsObj) {
    var that = this;
    var feArr = that.initFieldEditors(settingsObj);
    var promArray = [];
    _.each(feArr, function (feObj) {
      promArray.push(fe.buildFor(feObj));
    });
    return Promise.all(promArray);
  };

  /**
   *
   * @param settingsObj
   */
  AnalyticUxConfigurationSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    return [{
      dom: $(".fontSizeFE", that.jq()),
      value: settingsObj.getFontSize(),
      formFactor: 'mini',
      keyName: "fontSize"
    }];
  };

  return AnalyticUxConfigurationSettingsFE;
});
