/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file Model for Tab Configuration Data for analytics views
 * @author : Komaravolu, sai
 *
 */
define(['baja!', 'jquery', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel', 'd3'], function (baja, $, analyticsUtil, AnalyticsTabConfigBaseModel, d3) {

  "use strict";
  /**
   * Represents a model for tab configurations.
   * @constructor
   */

  var AnalyticsTabConfigEqOpModel = function AnalyticsTabConfigEqOpModel(input) {
    AnalyticsTabConfigBaseModel.apply(this, [$.extend({}, {}, input)]);
    var that = this;
    that.$offStatus = input.offStatus || false;
  };

  AnalyticsTabConfigEqOpModel.prototype = Object.create(AnalyticsTabConfigBaseModel.prototype);

  AnalyticsTabConfigEqOpModel.prototype.constructor = AnalyticsTabConfigEqOpModel;

  AnalyticsTabConfigEqOpModel.prototype.getOffStatus = function () {
    return this.$offStatus;
  };
  AnalyticsTabConfigEqOpModel.prototype.setOffStatus = function (offStatus) {
    this.$offStatus = offStatus;
  };

  /**
   * Children should implement the method to rebuild the tab configuration model.
   * @param inModel
   */
  AnalyticsTabConfigEqOpModel.prototype.rebuild = function (inModel) {
    this.setOffStatus(inModel.$offStatus);
    return inModel;
  };

  /**
   * Open for implementation by children.
   * By default it returns false.
   * @param inModel
   * @returns {boolean}
   */
  AnalyticsTabConfigEqOpModel.prototype.equals = function (inModel) {
    return inModel.getOffStatus() === this.getOffStatus();
  };

  AnalyticsTabConfigEqOpModel.prototype.toString = function () {
    var that = this;
    var temp = AnalyticsTabConfigBaseModel.prototype.toString.apply(that);
    temp.offStatus = that.$offStatus;
    return temp;
  };

  return AnalyticsTabConfigEqOpModel;
});
