/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 *@file Model for Chart Data for analytics views
 * @author : Upender Paravastu & Komaravolu, sai
 *
 */
define(['baja!', 'jquery', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel', 'lex!analytics'], function (baja, $, analyticsUtil, AnalyticsBaseDataModel, lexicon) {

  "use strict";

  var AnalyticsC3DataModel = function AnalyticsC3DataModel(chartSettings) {
    var that = this;
    AnalyticsBaseDataModel.apply(that, arguments);
    if (chartSettings) {
      that.$chartType = chartSettings.chartType || "bar";
      that.$showOnY2 = chartSettings.showOnY2 || false;
    }
  };

  AnalyticsC3DataModel.prototype = Object.create(AnalyticsBaseDataModel.prototype);
  AnalyticsC3DataModel.prototype.constructor = AnalyticsC3DataModel;

  AnalyticsC3DataModel.prototype.getChartType = function () {
    return this.$chartType;
  };
  AnalyticsC3DataModel.prototype.setChartType = function (chartType) {
    this.$chartType = chartType;
  };

  AnalyticsC3DataModel.prototype.getShowOnY2 = function () {
    return this.$showOnY2;
  };
  AnalyticsC3DataModel.prototype.setShowOnY2 = function (showOnY2) {
    this.$showOnY2 = showOnY2;
  };

  AnalyticsC3DataModel.prototype.toString = function () {
    var temp = AnalyticsBaseDataModel.prototype.toString.apply(this, arguments);
    temp.chartType = this.$chartType;
    temp.showOnY2 = this.$showOnY2;
    return temp;
  };
  return AnalyticsC3DataModel;
});
