function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
* @module nmodule/analytics/rc/chart/base/AnalyticsBaseWidget
*/
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'nmodule/js/rc/csrf/csrfUtil', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'hbs!nmodule/analytics/rc/chart/templates/base/analyticsBaseChartTmpl', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticBaseChartMasterTabTemplate', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/utils/AnalyticsChartDragDropUtils', 'nmodule/analytics/rc/chart/utils/AnalyticsDataUtils', 'nmodule/analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxConfigurationSettingsFE', 'nmodule/analytics/rc/chart/base/AnalyticsCommandBar', 'nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel', 'bajaux/events', 'nmodule/analytics/rc/chart/base/analyticEvents', 'nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel', 'bajaux/commands/Command', 'nmodule/webChart/rc/grid/GridEditor', 'nmodule/analytics/rc/util/ModelFactory', "baja!analytics:AnalyticUxWebChartParams," + "analytics:Interval," + "analytics:Combination," + "analytics:AnalyticsTabConfigBaseModel", 'css!nmodule/analytics/rc/chart/styles/ChartStyles', 'css!nmodule/analytics/rc/chart/styles/TabStyles', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, csrfUtil, d3, fe, feDialogs, baseTemplate, analyticBaseChartMasterTabTemplate, analyticsUtil, AnalyticsChartDragDropUtils, AnalyticsDataUtils, AnalyticUxWebChartSettingsFE, AnalyticUxConfigurationSettingsFE, AnalyticsCommandBar, AnalyticsBaseDataModel, events, analyticEvents, AnalyticsTabConfigBaseModel, Command, GridEditor, ModelFactory, types) {

  "use strict";

  var dashboard = "dashboard",
      dashboardChartData = "dashboardChartData",
      dashboardConfiguration = "dashboardConfiguration";
  var CSRF_TOKEN_HEADER_KEY = csrfUtil.CSRF_TOKEN_HEADER_KEY,
      getCsrfToken = csrfUtil.getCsrfToken;


  function widgetDefaults() {
    return {
      properties: {
        hideCommandBar: { value: true, hidden: true, transient: true, readonly: true },
        dashboard: { value: false, hidden: true, transient: true, readonly: true },
        dashboardChartData: { value: '', readonly: true, hidden: true, dashboard: true },
        dashboardConfiguration: { value: '', readonly: true, hidden: true, dashboard: true }
      }
    };
  }

  /**
   * Base view for all web analytics charts
   * 
   * @class
   * @alias module:nmodule/analytics/rc/chart/base/AnalyticsBaseWidget
   * @extends module:bajaux/Widget
   */
  var AnalyticsBaseWidget = function AnalyticsBaseWidget(params) {
    var that = this;
    Widget.call(that, { params: params, defaults: widgetDefaults() });
    that.uniqueKeyList = [];
    // Had to depend on d3 scale even if table doesn't need d3, to keep things consistent across analytics UI.
    that.textScale = d3.scale.linear().domain([100, 1300]).range([8, 25]);
    that.legendIconScale = d3.scale.linear().domain([100, 1300]).range([8, 30]);
    that.generalIconScale = d3.scale.linear().domain([100, 1300]).range([8, 30]);
    that.analyticService = undefined;
    that.isDebugEnabled = false;
    that.$widgetCommandBarRendered = false;
    that.$widgetBar = new GridEditor();
    that.$isDataLimitReached = false;
    subscriberMixIn(that);
  };

  // Inheriting Analytics Base Chart from Widget
  AnalyticsBaseWidget.prototype = Object.create(Widget.prototype);
  // Setting the constructor
  AnalyticsBaseWidget.prototype.constructor = AnalyticsBaseWidget;

  /**
   * Saves the data away to the dashboard.
   *
   * @inner
   * @private
   *
   * @param widget The chart widget instance to save the data from.
   */
  function saveDashboardData(widget) {
    var settings = _.map(widget.chartModelList, function (s) {
      return s.toString();
    });
    widget.properties().setValue(dashboardChartData, JSON.stringify(settings));
    var configData = widget.getTabConfigDataModel().toString();
    widget.properties().setValue(dashboardConfiguration, JSON.stringify(configData));
  }

  /**
   * Return true if the web chart is being loaded from a dashboard.
   *
   * @inner
   * @private
   *
   * @param widget The widget instance.
   * @returns {Boolean} Returns true if the chart widget is on a Dashboard.
   */
  function isOnDashboard(widget) {
    return widget.properties().getValue(dashboard, false);
  }

  /**
   * Return true if the widget is on a dashboard and some data is available to load.
   *
   * @param widget The chart widget instance.
   * @returns {Boolean} Returns true if the chart widget is on a dashboard and there's some
   * data to load.
   */
  function hasDashboardData(widget) {
    return isOnDashboard(widget) && !!widget.properties().getValue(dashboardChartData, "");
  }

  /**
   * Initialize the Widget from any Dashboard data that's available.
   *
   * @inner
   * @private
   *
   * @param widget The widget instance to check for dashboard data.
   * @returns {Promise} A promise that's resolved once the dashboard data has been
   * resolved.
   */
  function initializeFromDashboard(widget) {
    if (hasDashboardData(widget)) {
      var chartJson = parseRecursiveLy(widget.properties().getValue(dashboardChartData));
      var configJson = parseRecursiveLy(widget.properties().getValue(dashboardConfiguration));

      widget.chartModelList = _.map(chartJson, function (m) {
        return ModelFactory.newBaseDataModel(widget, m);
      });
      widget.$tabConfigDataModel = new (widget.getTabModelType())(configJson);
      widget.$isLoaded = true;
      return widget.$doLoad();
    } else {
      return Promise.resolve();
    }
  }

  /**
   * Recursively parses the saved dashboard json.
   * @param inputString
   * @return {any}
   */
  function parseRecursiveLy(inputString) {
    var firstJson = inputString ? JSON.parse(inputString) : {};
    _.each(firstJson, function (json) {
      _.each(_.keys(json), function (key) {
        try {
          var value = JSON.parse(json[key]);
          json[key] = value;
        } catch (err) {}
      });
    });
    return firstJson;
  }

  /**
   * Attempt to resolve the dashboard clear command. If the widget
   * isn't on a dashboard, the returned promise will resolve with no
   * value.
   *
   * @inner
   * @private
   *
   * @param widget The widget instance.
   * @returns {Promise} A promise that will resolve to a clear command.
   */
  function resolveClearCmd(widget) {
    return new Promise(function (resolve, reject) {
      // If being used on a Dashboard then resolve the dashboard
      // resources before initializing the widget bar.
      if (isOnDashboard(widget)) {
        require(["nmodule/dashboard/rc/dashboard"], function (db) {
          var clearCmd = db.makeClearCmd(widget);

          // Add to the widget and the widget bar.
          widget.getCommandGroup().add(clearCmd);

          resolve(clearCmd);
        }, reject);
      } else {
        resolve();
      }
    });
  }

  /**
   * Register a time range changed event.
   * @param that
   */
  function registerTimeRangeChanged(that) {
    that.jq().off(analyticEvents.TIME_RANGE_CHANGED);
    that.jq().on(analyticEvents.TIME_RANGE_CHANGED, function (event, timeRangeTag, timeRangeValue) {
      for (var i = 0; i < that.getModel().length; i++) {
        that.getModel()[i].setTimeRange(timeRangeValue);
      }
      that.jq().trigger(analyticEvents.BINDING_CHANGED);
    });
  }

  /**
   * Register a settings changed event.
   * @param that
   */
  function registerSettingsChangedEvent(that) {
    that.jq().off(analyticEvents.SETTINGS_CHANGED);
    that.jq().on(analyticEvents.SETTINGS_CHANGED, function (event, obj) {
      var groupPromises1 = groupPromises(that, obj);
      //Update chart settings collection.
      that.updateSettings(obj, groupPromises1).then(function () {
        // Extract the configuration from the tab and set it to the model.
        // that.applyBaseConfiguration(obj, groupPromises);
        // Trigger a binding changed event.
        that.jq().trigger(analyticEvents.BINDING_CHANGED);
        // Trigger Model Changed Event.
        that.jq().find(".trCmdBar").trigger(analyticEvents.MODEL_CHANGED, [that.getModel(), that.getTabConfigDataModel(), that.getTabConfigDataModel().getFontSize()]);
        // [that.getModel(), that.getTabConfigDataModel(), that.getTextSize()]);
      });
    });
  }

  AnalyticsBaseWidget.prototype.initCommands = function (element, clearCmd) {
    var that = this,
        widgetBar = that.$widgetBar,
        saveCmd;

    saveCmd = new Command({
      module: "analytics",
      lex: "analytics.SaveCommand",
      func: function func() {
        return that.save();
      }
    });

    // A hack but as the chart widget implements its own widget bar, this is what we need to do.
    if (clearCmd) {
      widgetBar.addCommand(clearCmd);
    }

    saveCmd.setEnabled(false);
    widgetBar.addCommand(saveCmd);

    function jqSave() {
      return $(".js-tab-" + saveCmd.getId(), that.jq());
    }

    that.jq().on([events.ENABLE_EVENT, events.DISABLE_EVENT, events.READONLY_EVENT, events.WRITABLE_EVENT, events.INITIALIZE_EVENT, events.LOAD_EVENT, events.DESTROY_EVENT].join(' '), '*', false);

    that.jq().on([events.MODIFY_EVENT].join(' '), function () {
      jqSave().addClass("save-modified");

      //allow save to be clicked
      jqSave().data("widget").setEnabled(true);
    }).on(events.UNMODIFY_EVENT, function () {
      jqSave().removeClass("save-modified");
      //allow save to be clicked
      //jqSave().children("button").attr("disabled", "disabled");
      jqSave().data("widget").setEnabled(false);
    }).on([events.LOAD_EVENT].join(' '), function (e) {
      jqSave().parent().toggle(!that.$isReadonly && (that.$isFile || isOnDashboard(that)));
    });
  };

  AnalyticsBaseWidget.prototype.doInitialize = function (element) {
    var that = this;
    // Well had to do this, coz the doInitialize wasnt having the jquery obj sometimes.
    that.source = that.properties().getValue("source");
    that.isInitCommandBar = that.source === "report" ? that.properties().getValue("isCmdBarRequired") : true;
    that.colKeys = that.properties().getValue("colKeys");
    var model = that.properties().getValue("model");
    var configModel = that.properties().getValue("configModel");
    that.showInterpolationStatus = (that.showInterpolationStatus = that.properties().getValue("showInterpolationStatus")) === null ? true : that.showInterpolationStatus;
    that.chartModelList = _.isNull(model) || _.isEmpty(model) ? [] : model;
    // Enable legend for specific reports or for reports which are not configured
    // Enable legend for all other widgets other than reports.
    that.showLegend = that.properties().getValue("showLegend") || that.properties().getValue("showLegend") === undefined || that.source !== "report";

    // Make the registration private but provide a callback hook on to
    // how the drop should be handled.
    that.$registerDragDropHandler(element, function (e) {
      // that.$handleDrop(that, e.originalEvent.dataTransfer);
      AnalyticsChartDragDropUtils.handleChartDrop(that, e.originalEvent.dataTransfer);
    });
    if (that.source !== "report") {
      element.addClass("ux-fullscreen");
    }
    that.handleBindingChangedEvent();
    registerTimeRangeChanged(that);
    registerSettingsChangedEvent(that);

    // Instantiate the analytics service and set the debug enabled status, by default it's false.
    return analyticsUtil.getService('station:|service:analytics:AnalyticService').then(function (service) {
      that.analyticService = service;
      that.isDebugEnabled = that.analyticService.getDebugMode();
      that.areaTag = that.analyticService.getAreaTag();
      // Instantiate the defined tab config data model.
      if (that.source === "report") {
        that.$tabConfigDataModel = _.isNull(configModel) || _.isEmpty(configModel) ? new (that.getTabModelType())({ fontSize: that.getTextScale()(that.availableHeight()).toFixed(0) }) : configModel;
      } else {
        that.$tabConfigDataModel = new (that.getTabModelType())({ fontSize: that.getTextScale()(that.availableHeight()).toFixed(0) });
      }
      return Promise.resolve(function () {
        return initializeFromDashboard(that);
      });
    });
  };

  AnalyticsBaseWidget.prototype.doLoad = function (dataSource) {
    // Commented the below code for NCCB-31499 & NCCB-31443.
    // If the first time we are loading dashboard, hasdashboard data will have empty params, thereby it returns true.
    // So, overruled it, and calling the AnalyticBaseChart's doLoad, thereby loading fresh data.
    // Also, if the dragdrop is invoked, control should flow and the rest children doloads has to be called.
    if (hasDashboardData(this) && !this.$isDragDropInvoked) {
      return Promise.resolve();
    }
    return Promise.resolve(dataSource);
  };

  /**
   * Will finish the tasks before doLoad finishes.
   */
  AnalyticsBaseWidget.prototype.finishTasks = function () {
    var that = this;
    that.jq().find(".trCmdBar").attr("style", "display:block");
    that.jq().find(".trCmdBar").trigger(analyticEvents.MODEL_CHANGED, [that.getModel(), that.getTabConfigDataModel(), that.getTabConfigDataModel().getFontSize()]);

    //Set the text size for time range element text.
    that.jq().find(".timeRangeElem, .tableContainer, .trCmdBar").attr("style", "font-size:" + that.getTabConfigDataModel().getFontSize() + "px");
    that.jq().find(".ux-chart-legend-text").attr("style", "font-size:" + that.getTabConfigDataModel().getFontSize() + "px");
    // If the available height is greater than zero then set the icon sizes.
    if (this.availableHeight() > 0) {
      this.legendIconSize = this.legendIconSize === 0 ? this.getLegendIconScale()(this.availableHeight()).toFixed(0) : this.legendIconSize;
      this.generalIconSize = this.generalIconSize === 0 ? this.getGeneralIconScale()(this.availableHeight()).toFixed(0) : this.generalIconSize;
    }
  };

  /**
   * De bounce the chart rendering ( 1 sec needs discussion) to chance upon getting all bindings in place
   */
  AnalyticsBaseWidget.prototype.$doLoad = function () {
    var that = this;
    var coll = that.chartModelList;
    var promiseList = [];
    for (var i = 0; i < coll.length; i++) {
      promiseList.push(AnalyticsDataUtils.getChartData(coll[i]));
    }
    var retPromise = Promise.all(promiseList).then(function (values) {
      if (_.every(that.chartModelList, function (m) {
        return _.isEmpty(m.getAnalyticTrendArray());
      })) {
        var message = that.renderEmpty();
        that.renderCommandBar();
        return Promise.reject(message);
      }
      return that.render(that.chartModelList);
    }).then(function () {
      that.renderCommandBar();
      return Promise.resolve();
    }).catch(function (msg) {
      // Commented the below code for NCCB-31499 & NCCB-31443.
      // Earlier, we've rejected the promise, there by, the hx code was failing & showing content error on the page.
      // It's ok to return a resolve with a message in it, hx shows it on the screen.
      return Promise.resolve(msg);
    });
    // if(that.source !== "report") {
    //   dialogs.showLoading(200, retPromise);
    // }
    return retPromise;
  };

  /**
   * Render the command bar
   * @param source
   */
  AnalyticsBaseWidget.prototype.renderCommandBar = function (source) {
    var that = this;
    that.jq().find(".trCmdBar").attr("style", "display:block");
    if (that.showCommandBar()) {
      that.jq().find(".trCmdBar").attr("style", "display:block");
      if (!that.$widgetCommandBarRendered && that.isInitCommandBar) {
        return that.initCommandBar().then(function () {
          that.$widgetCommandBarRendered = true;
        });
      }
    } else {
      that.jq().find(".trCmdBar").attr("style", "display:none");
    }
  };

  AnalyticsBaseWidget.prototype.doRefresh = function (source) {
    var that = this;
    var modelPromise = AnalyticsDataUtils.getModel(that, source, this.getDefaultSettings());
    return modelPromise.then(function (inModel) {
      if (!analyticsUtil.isUniqueOrd(that, inModel)) {
        return Promise.resolve();
      }
      that.finishTasks();
      that.refresh(source);
    });
  };

  /**
   * Load the data form the collection
   * @param chartSettingsCollection Array
   */
  AnalyticsBaseWidget.prototype.render = function (chartSettingsCollection) {};

  AnalyticsBaseWidget.prototype.refresh = function (source) {};

  /**
   * Update the chart info
   * @param chartSource
   */
  AnalyticsBaseWidget.prototype.updateLegend = function (chartSettingsCollection) {};

  /**
   *  This method needs to be overridden by sub classes to provide the necessary
   *  painting mechanism.
   * @param chartSettingsCollection
   */
  AnalyticsBaseWidget.prototype.draw = function (chartSource) {
    throw new Error("Unsupported Operation");
  };

  /**
   *  This method needs to be overridden by sub classes to provide the necessary
   *  painting mechanism.
   * @param chartSettingsCollection
   */
  AnalyticsBaseWidget.prototype.reDraw = function (chartSource) {
    throw new Error("Unsupported Operation");
  };

  /**
   * Register a drag  drop handler for the chart
   */
  AnalyticsBaseWidget.prototype.$registerDragDropHandler = function (element, dropHandler) {
    AnalyticsChartDragDropUtils.registerDragDrop(element, dropHandler);
  };

  /**
   * This method will instantiate the command bar.
   */
  AnalyticsBaseWidget.prototype.initCommandBar = function () {
    var that = this;
    // Set a default time range to input the command bar.
    var timeRange = baja.$("analytics:UxAnalyticTimeRangeType").DEFAULT;
    var modelList = that.getModel();
    if (modelList && modelList.length > 0) {
      var modelRef = modelList[0];
      timeRange = modelRef.getTimeRange();
    }

    return resolveClearCmd(that).then(function (clearCmd) {
      return Promise.resolve(fe.buildFor({
        dom: $(".trCmdBar", that.jq()),
        type: AnalyticsCommandBar,
        properties: {
          timeRange: timeRange,
          supportedExportTypes: that.getSupportedExportTypes(),
          model: {
            dataModel: that.getModel(),
            configModel: that.getTabConfigDataModel()
          },
          fileName: that.getFileName(),
          isFile: that.isFile(),
          tabParamType: that.getTabParamType,
          settingsEditorType: that.getSettingsEditorType(),
          configurationTabParamType: that.getConfigTabParamType,
          configurationTabType: that.getConfigurationTabType(),
          fontSize: that.getTabConfigDataModel().getFontSize(),
          isOnDashboard: isOnDashboard(that),
          clearCmd: clearCmd,
          parent: that
          // fontSize: that.getTextSize()
        },
        value: {
          dataModel: that.getModel(),
          configModel: that.getTabConfigDataModel()
        }
      })).then(function (commandBar) {
        function jqSave() {
          return $(".js-tab-" + commandBar.getSaveCommand().getId(), that.jq());
        }

        that.jq().on([events.ENABLE_EVENT, events.DISABLE_EVENT, events.READONLY_EVENT, events.WRITABLE_EVENT, events.INITIALIZE_EVENT, events.LOAD_EVENT, events.DESTROY_EVENT].join(' '), '*', false);

        that.jq().on(events.MODIFY_EVENT, function () {
          jqSave().addClass("save-modified");

          //allow save to be clicked
          jqSave().data("widget").setEnabled(true);
        }).on(events.UNMODIFY_EVENT, function () {
          jqSave().removeClass("save-modified");
          //allow save to be clicked
          //jqSave().children("button").attr("disabled", "disabled");
          jqSave().data("widget").setEnabled(false);
        }).on(events.LOAD_EVENT, function (e) {
          jqSave().parent().toggle(!that.$isReadonly && (that.$isFile || isOnDashboard(that)));
        });
      });
    });
  };

  /**
   * Register an event on the 'gear icon' to open the settings dialog.
   * This will have the filter parameters for the data.
   */
  AnalyticsBaseWidget.prototype.registerSettingsIconEvent = function () {
    var that = this;
    var chartSettingsNode = this.jq().find(".chartSettings");
    chartSettingsNode.on("click", function () {
      that.launchSettingsEditor();
    });
  };

  /**
   * Registers double click event.
   */
  AnalyticsBaseWidget.prototype.registerDoubleClickEvent = function () {
    var that = this;
    that.jq().dblclick(function () {
      that.jq().find('.trCmdBar').toggle();
    });
  };

  AnalyticsBaseWidget.prototype.registerAlienInvocation = function () {};

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  AnalyticsBaseWidget.prototype.getSupportedExportTypes = function () {
    return ["none"];
  };
  /**
   * This method can to be overriden by subclasses to get specific
   * settings
   * @returns {string[]}
   */
  AnalyticsBaseWidget.prototype.getDefaultSettings = function () {
    return {
      data: "n:history",
      dataFilter: "",
      timeRange: "today",
      interval: undefined,
      unit: "null",
      rollup: baja.$("analytics:AnalyticUxWebChartParams").getRollup().getValue().getTag(),
      aggregation: baja.$("analytics:AnalyticUxWebChartParams").getAggregation().getValue().getTag(),
      dow: "7f",
      seriesNameBFormat: "%node.navDisplayName%-%data.name%",
      hisTotEnabled: true,
      missingDataCfg: {
        aggStrategy: "ignoreSeries",
        intpAlgorithm: "none",
        knnValue: 1,
        enabled: false
      }
    };
  };

  /**
   * Listen for changes on time range.
   * Enable "save" button conditionally (If source of chart is file)
   * Re-render the chart
   */
  AnalyticsBaseWidget.prototype.handleBindingChangedEvent = function () {
    var that = this;
    // Listen for changes on time range
    this.jq().off(analyticEvents.BINDING_CHANGED);
    this.jq().on(analyticEvents.BINDING_CHANGED, function () {
      // $rebuild the ord in the model
      _.each(that.getModel(), function (model) {
        model.rebuildOrd();
      });
      saveDashboardData(that);
      // Re-render the chart
      return that.$doLoad(that.getModel());
    });
  };

  function groupPromises(widget, chartSettingsFEObj) {
    var dom = chartSettingsFEObj.jq();
    var blocks = dom.find('.container');
    var promiseArray = [];
    for (var i = 0; i < blocks.length; i++) {
      promiseArray.push(dom.find('.container:eq(' + i + ')').data("widget").read());
    }
    return Promise.all(promiseArray);
  }

  /**
   * Update the chart settings using the DOM model of the chart settings
   * field editor
   */
  AnalyticsBaseWidget.prototype.updateSettings = function (obj, groupPromises2) {
    var that = this;
    var timeRange = "today";
    if (_.isArray(this.chartModelList) && this.chartModelList.length > 0) {
      timeRange = this.chartModelList[0].getTimeRange();
    }
    //clean the collection
    that.chartModelList = [];
    return groupPromises2.then(function (valArray) {
      _.each(valArray, function (data) {
        if (data && data.getType().toString() !== that.getConfigTabParamType().toString()) {
          var model = that.buildModel(data, timeRange);
          that.chartModelList.push(model);
        } else if (data && data.getType().toString() === that.getConfigTabParamType().toString()) {
          // If ond only if the tab is "Configuration" type, then make an update on configuration model.
          var fontSize = data.getFontSize();
          // If there's any change in tab config model, then set the modified flag to true/false.
          that.getTabConfigDataModel().setModified(!that.getTabConfigDataModel().$equals(data));
          // Set the font size to the tab model.
          that.getTabConfigDataModel().setFontSize(fontSize);
          // Left for the children to implement, to propogate the calls to child.
          that.updateChartConfiguration(data);
        }
      });
      return Promise.resolve(true);
    });
  };

  /**
   * Abstract method allows the child class to implement the logic to update their tab model based on the web object.
   * @param chartObj
   */
  AnalyticsBaseWidget.prototype.updateChartConfiguration = function (chartObj) {
    // Abstract method left for children to implement.
  };

  /**
   * Make chart settings from the loaded settings configuration.
   */
  AnalyticsBaseWidget.prototype.$getBajaCastedSettings = function () {
    var that = this;
    var chartSettingsColl = this.getModel();
    var settingList = baja.$("baja:Component");
    for (var i = 0; i < chartSettingsColl.length; i++) {
      var settingModel = that.getTabParamType();
      var settings = that.buildSettings(chartSettingsColl[i], settingModel);
      settingList.add(settings);
    }
    //Add chart configurations.
    var configModel = that.getConfigTabParamType();
    var configuration = that.$buildConfiguration(configModel);
    settingList.add(configuration);
    return settingList;
  };
  /**
   * Empty the data area
   */
  AnalyticsBaseWidget.prototype.renderEmpty = function () {};
  /**
   * This needs to be implemented by subclasses if multiple bindings need to be throttled
   * in to a single chart.
   * Defaulted it to true. In this case multiple charts will be rendered (One per binding)
   * @returns {boolean}
   */
  AnalyticsBaseWidget.prototype.needsCleanSlate = function () {
    return true;
  };
  /**
   * Returns the chart settings collection.
   * This method will be used by all the child element views to get the current chart settings for rendering UI state.
   */
  AnalyticsBaseWidget.prototype.getModel = function () {
    return this.chartModelList;
  };
  /**
   * Get the chart margins
   * @type {{top: number, right: number, bottom: number, left: number}}
   */
  AnalyticsBaseWidget.prototype.chartMargins = function () {
    return {
      top: 10,
      right: 10,
      bottom: 10,
      left: 10
    };
  };
  /**
   * Get the width of chart pane
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getChartPaneWidth = function () {
    return this.jq().width();
  };
  /**
   * Get the height of chart pane
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getChartPaneHeight = function () {
    return this.jq().height() * 0.85; // The rest is for filter options and legend area
  };
  /**
   * serialize the model to JSON
   * @returns {{timeRange, interval: baja.RelTime, ord: (String|baja.Ord), data: (string|*), units: (Array.<baja.Unit>|*)}}
   */
  AnalyticsBaseWidget.prototype.toJSON = function () {
    return {
      timeRange: this.getTimeRange(),
      interval: this.getInterval(),
      ord: this.getOrd(),
      data: this.getData(),
      units: typeof this.getUnits() === "string" ? this.getUnits() : this.getUnits().getUnitName()
    };
  };

  /**
   * Returns true if the loaded chart type is a file.
   * @returns {boolean}
   */
  AnalyticsBaseWidget.prototype.isFile = function () {
    return this.$isFile;
  };

  /**
   * Get file name.
   * @returns {boolean}
   */
  AnalyticsBaseWidget.prototype.getFileName = function () {
    return this.$fileName;
  };

  /**
   * Build Chart Model
   * @param data
   * @param timeRange
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.buildModel = function (data, timeRange) {
    var model = ModelFactory.newBaseDataModel(this, {});
    model.setTimeRange(timeRange);

    model.setIsIntervalSelected(data.getInterval().getSelected());
    if (model.isIntervalSelected()) {
      model.setInterval(data.getInterval().getValue().getTag());
    } else {
      model.setInterval(undefined);
    }
    model.setDaysToExclude(data.getDaysToExclude().valueOf());

    model.setIsRollupSelected(data.getRollup().getSelected());
    if (model.isRollupSelected()) {
      model.setRollup(data.getRollup().getValue().getTag());
    } else {
      model.setRollup(undefined);
    }

    model.setIsAggregationSelected(data.getAggregation().getSelected());
    if (model.isAggregationSelected()) {
      model.setAggregation(data.getAggregation().getValue().getTag());
    } else {
      model.setAggregation(undefined);
    }

    model.setData(data.getData());
    model.setDataFilter(data.getDataFilter());
    model.setUnit(data.getUnit());
    model.setDataSource(data.getDataSource());
    model.setDataSourceName(data.getDataSourceName());
    model.setOrd(data.getOrd());
    model.setSeriesName(data.getSeriesName());
    model.setSeriesNameBFormat(data.getSeriesNameBFormat());
    model.setBrush(data.getBrush());
    model.setBrush2(data.getBrush2 && data.getBrush2());
    model.setMidBrush(data.getMidBrush && data.getMidBrush());
    model.setUniqueKey(data.getUniqueKey());
    model.setHisTotEnabled(data.getHisTotEnabled());
    model.setMissingDataConfig({
      enabled: data.getMissingDataStrategy().getEnabled(),
      aggStrategy: data.getMissingDataStrategy().getAggregationStrategy().getTag(),
      intpAlgorithm: data.getMissingDataStrategy().getInterpolationAlgorithm().getTag(),
      knnValue: data.getMissingDataStrategy().getKValue()
    });
    return model;
  };

  /**
   * Get Chart Params
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getTabParamType = function () {
    return baja.$("analytics:AnalyticUxWebChartParams");
  };

  /**
   * Base model java class for configuration.
   * Child classes should override this method and mention their configuration class.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getConfigTabParamType = function () {
    return baja.$("analytics:AnalyticsTabConfigBaseModel");
  };

  /**
   *  Build Chart Settings
   * @param chartSettings
   * @param settings
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.buildSettings = function (chartSettingsColl, settings) {
    var optionalParam;
    if (chartSettingsColl.getInterval()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Interval").make(chartSettingsColl.getInterval()));
      optionalParam.setSelected(chartSettingsColl.isIntervalSelected());
      settings.setInterval(optionalParam);
    }

    if (chartSettingsColl.getRollup()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(chartSettingsColl.getRollup()));
      optionalParam.setSelected(chartSettingsColl.isRollupSelected());
      settings.setRollup(optionalParam);
    }

    if (chartSettingsColl.getAggregation()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(chartSettingsColl.getAggregation()));
      optionalParam.setSelected(chartSettingsColl.isAggregationSelected());
      settings.setAggregation(optionalParam);
    }

    if (chartSettingsColl.getDaysToExclude()) {
      settings.setDaysToExclude(baja.$("analytics:AnalyticDaysOfWeekBits").make(chartSettingsColl.getDaysToExclude()));
    }

    settings.setData(chartSettingsColl.getData() || "n:history");
    settings.setDataFilter(chartSettingsColl.getDataFilter() || "");

    if (chartSettingsColl.getUnit()) {
      settings.setUnit(chartSettingsColl.getUnit());
    }

    if (chartSettingsColl.getOrd()) {
      settings.setOrd(chartSettingsColl.getOrd());
    }

    if (chartSettingsColl.getDataSource()) {
      settings.setDataSource(chartSettingsColl.getDataSource());
    }

    if (chartSettingsColl.getDataSourceName()) {
      settings.setDataSourceName(chartSettingsColl.getDataSourceName());
    }

    if (chartSettingsColl.getSeriesName()) {
      settings.setSeriesName(chartSettingsColl.getSeriesName());
    }

    if (chartSettingsColl.getBrush()) {
      settings.setBrush(chartSettingsColl.getBrush());
    }

    if (chartSettingsColl.getSeriesNameBFormat()) {
      settings.setSeriesNameBFormat(chartSettingsColl.getSeriesNameBFormat());
    }

    if (chartSettingsColl.getUniqueKey()) {
      settings.setUniqueKey(chartSettingsColl.getUniqueKey());
    }

    settings.setHisTotEnabled(chartSettingsColl.getHisTotEnabled());
    return settings;
  };

  /**
   * This method will return the chart configuration tab.
   */
  AnalyticsBaseWidget.prototype.$buildConfiguration = function (configModel) {
    var that = this;
    // configModel.setFontSize(this.getTextSize());
    return that.buildConfiguration(configModel);
  };

  /**
   * This method will return the chart configuration tab.
   */
  AnalyticsBaseWidget.prototype.buildConfiguration = function (configModel) {
    return configModel;
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getSettingsEditorType = function () {
    return AnalyticUxWebChartSettingsFE;
  };

  /**
   * Get Configuration Editor Type.
   * Child charts should implement their own configuration type.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getConfigurationTabType = function () {
    return AnalyticUxConfigurationSettingsFE;
  };

  /**
   * Returns the base data model
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getDataModel = function () {
    return AnalyticsBaseDataModel;
  };

  /**
   *
   */
  AnalyticsBaseWidget.prototype.getToolTipDiv = function () {
    throw new Error("Not Implemented");
  };

  /**
   * Returns available width to draw.
   * @returns {number}
   */
  AnalyticsBaseWidget.prototype.availableWidth = function () {
    return parseInt(this.getChartPaneWidth()) - this.chartMargins().left - this.chartMargins().right;
  };

  /**
   * Returns the available height.
   * @returns {number}
   */
  AnalyticsBaseWidget.prototype.availableHeight = function () {
    return parseInt(this.getChartPaneHeight()) - this.chartMargins().top - this.chartMargins().bottom;
  };

  /**
   * Returns the renderable interval, based on the input configuration/series.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getRenderInterval = function () {
    var that = this;
    var interval;
    _.each(that.chartModelList, function (model, index) {
      if (index !== 0) {
        return;
      }
      if (model.getInterval()) {
        interval = analyticsUtil.decodeIntervalForStep(model.getInterval()) * 60 * 1000;
      } else {
        interval = analyticsUtil.getDefaultInterval(model);
      }
    });
    return interval;
  };

  /**
   * Returns the start and end time, used for time range.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getStartAndEndTime = function () {
    var that = this;
    var interval;
    _.each(that.chartModelList, function (model, index) {
      if (index !== 0) {
        return;
      }
      interval = analyticsUtil.getIntervalForTR(model.getTimeRange());
    });
    return interval;
  };

  /**
   * Base chart returns the configured tabconfigdatamodel.
   * Child classes when they override, this method returns their data model.
   * @returns {*|undefined}
   */
  AnalyticsBaseWidget.prototype.getTabConfigDataModel = function () {
    return this.$tabConfigDataModel;
  };

  /**
   * Base model for configuration.
   * Children should override this method and define their tab model. Then only their configuration will be seen.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getTabModelType = function () {
    return AnalyticsTabConfigBaseModel;
  };

  /**
   * Returns the set text scale for the base chart.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getTextScale = function () {
    return this.textScale;
  };

  /**
   * Returns the legend icon scale for the base chart.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getLegendIconScale = function () {
    return this.legendIconScale;
  };

  /**
   * Returns the general icon scale applied on the base chart.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getGeneralIconScale = function () {
    return this.generalIconScale;
  };

  /**
   * Default export ta
   * @returns {[string]}
   */
  AnalyticsBaseWidget.prototype.getSupportedExportTypes = function () {
    return ["none"];
  };

  AnalyticsBaseWidget.prototype.isMultiBindingSupported = function () {
    return true;
  };

  AnalyticsBaseWidget.prototype.showCommandBar = function () {
    return true;
  };

  AnalyticsBaseWidget.prototype.getDefaultOrdScheme = function () {
    return "analytictrend:";
  };

  /**
   * Overloaded doSave method.
   * @param obj
   * @returns {Promise|*}
   */
  AnalyticsBaseWidget.prototype.doSave = function (obj) {
    var that = this;
    if (isOnDashboard(that)) {
      saveDashboardData(that);
    } else if (that.isFile()) {
      var o = {
        dataModel: that.getModel(),
        configModel: that.getTabConfigDataModel()
      };
      return Promise.resolve($.ajax("/analytics/file/save/charts/" + that.getFileName(), {
        type: "POST",
        headers: _defineProperty({}, CSRF_TOKEN_HEADER_KEY, getCsrfToken()),
        contentType: "application/json",
        data: JSON.stringify(AnalyticsDataUtils.makeJson(o))
      }));
    }
  };

  AnalyticsBaseWidget.prototype.getName = function () {
    return "AnalyticsBaseWidget";
  };

  /**
   * Returns the renderable universal limit.
   * @return {number}
   */
  AnalyticsBaseWidget.prototype.getRenderLimit = function () {
    return -1;
  };

  return AnalyticsBaseWidget;
});
