/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/*jshint browser: true*/

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/analytics/AnalyticsChartFactory
 */
define(['Promise', 'nmodule/webChart/rc/model/BaseChartFactory', 'nmodule/analytics/rc/AnalyticsBoxTableSeries', 'baja!box:BoxTable'], function (Promise, BaseChartFactory, AnalyticsBoxTableSeries) {

  "use strict";

  var boxTableTypeSpec = "box:BoxTable";
  /**
   * The factory for an Analytics BoxSeries which simply generates AnalyticsBoxSeries
   *
   * @class
   * @extends module:nmodule/webChart/rc/model/BaseChartFactory
   * @alias module:nmodule/analytics/rc/AnalyticsChartFactory
   */
  var AnalyticsChartFactory = function AnalyticsChartFactory() {
    BaseChartFactory.apply(this, arguments);
  };

  AnalyticsChartFactory.prototype = new BaseChartFactory();
  AnalyticsChartFactory.prototype.constructor = AnalyticsChartFactory;

  /**
   * Return one AnalyticsBoxTableSeries per capable BoxSeries
   * @param {module:nmodule/webChart/rc/model/BaseModel} model
   * @param {baja.Subscriber} subscriber
   * @param {Object} seriesParams
   * @param {baja.Value} seriesParams.value
   * @param {baja.Ord} seriesParams.ord
   * @returns {Promise.<AnalyticsBoxTableSeries>}
   */
  AnalyticsChartFactory.prototype.factory = function (model, subscriber, seriesParams) {
    var value = seriesParams.value;
    if (value && typeof value.getType === "function" && value.getType().is(boxTableTypeSpec) && AnalyticsBoxTableSeries.hasRequiredColumns(value)) {
      return Promise.resolve([new AnalyticsBoxTableSeries(model, seriesParams)]);
    }

    return Promise.resolve();
  };

  return AnalyticsChartFactory;
});
