/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 */

/**
 * API Status: **Private**
 * @module nmodule/search/rc/command/SettingsCommand
 */
define([
  'jquery',
  'baja!',
  'lex!search',
  'dialogs',
  'bajaux/commands/Command',
  'nmodule/webEditors/rc/fe/fe',
  'hbs!nmodule/search/rc/template/SearchWidget-settings'
], function (
  $,
  baja,
  lexs,
  dialogs,
  Command,
  fe,
  tplSearchWidgetSettings
) {
  "use strict";

  var lex = lexs[0],
      idCount = 0,
      SCOPE_CLS = '.n4-search-widget-scope',
      SUBSCRIBE_CLS = '.n4-search-widget-subscribe',
      PAGE_SIZE_CLS = '.n4-search-widget-page-size';

  /**
   * Generate a unique DOM ID. The ID will include the name of this editor's
   * constructor just for tracing/debugging purposes.
   *
   * @private
   * @inner
   * @returns {String}
   */
  function generateId(view) {
    var prefix = view.constructor.name || 'SearchWidget';
    return prefix + '__id__' + idCount++;
  }

  /**
   * SettingsCommand is a Command that provides access to the Search Settings
   *
   * @class
   * @alias module:nmodule/search/rc/command/SettingsCommand
   * @extends module:bajaux/commands/Command
   */
  var SettingsCommand = function SettingsCommand(view) {
    Command.call(this, {
      module : "search",
      lex : "SearchWidget.settingsCommand",
      func : function () {
        var dom,
            scopeEd,
            dialog = dialogs.showOkCancel({
            title : lex.get("SearchWidget.settings"),
            content : '<div class="n4-search-widget-settings"/>'
          })
            .ok(function () {
              scopeEd.read().then(function (scopes) {
                // If the scope changes, it needs to resubmit the search.
                // But if only the page size or subscription changes, then
                // it can just rebuild the page without resubmitting the search
                var pageSizeChanged = false,
                    scopeChanged = false,
                    subscribe = dom.find(SUBSCRIBE_CLS).first().is(':checked'),
                    pageSize = dom.find(PAGE_SIZE_CLS).first().val();

                // TODO: Should these private vars be accessed through getters?
                if (!(scopes.equals(view.$searchScopes))) {
                  scopeChanged = true;
                }

                if (pageSize !== view.$resultsPageSize) {
                  pageSizeChanged = true;
                }

                if (subscribe !== view.$subscribeResults) {
                  view.setSubscribeToResults(subscribe, /*updateResults*/(!scopeChanged && !pageSizeChanged));
                }

                if (pageSizeChanged) {
                  view.setPageSize(pageSize, /*updateResults*/!scopeChanged);
                }

                if (scopeChanged) {
                  view.setScopeFilter(scopes, /*updateResults*/true);
                }
              })
                .finally(function() {
                  scopeEd.destroy();
                });
            })
            .cancel(function() {
              scopeEd.destroy();
            });

        dom = $('.n4-search-widget-settings', dialog.jq());

        dom.html(tplSearchWidgetSettings({
          scopeFilter: lex.get('SearchWidget.scopeFilter'),
          resultsPerPage: lex.get('SearchWidget.resultsPerPage'),
          subscribeId: generateId(view),
          subscribeLabel: lex.get('SearchWidget.subscribeResults')
        }));

        dom.find(SUBSCRIBE_CLS).first().prop('checked', view.$subscribeResults);
        dom.find(PAGE_SIZE_CLS).first().val(view.$resultsPageSize);

        return fe.buildFor({
          value: view.$searchScopes,
          dom: dom.find(SCOPE_CLS).first(),
          formFactor: 'compact'
        }).then(function (ed) {
          scopeEd = ed;
        });
      }
    });
  };  
  
  SettingsCommand.prototype = Object.create(Command.prototype);
  SettingsCommand.prototype.constructor = SettingsCommand;

  return SettingsCommand;
});
