/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 */

/*jshint browser:true */
/*global niagara */

/**
 * API Status: **Private**
 * @module nmodule/search/rc/QuickSearchWidget
 */
define(['bajaux/Widget',
        'bajaux/mixin/subscriberMixIn',
        'jquery',
        'hbs!nmodule/search/rc/template/QuickSearchWidget-structure',
        'baja!',
        'lex!search'], function (
        Widget,
        subscriberMixin,
        $,
        tplQuickSearchWidgetStructure,
        baja,
        lexs) {

  'use strict';

  var lex = lexs[0],
      QUERY_CLASS = '.n4-quick-search-query',
      SEARCH_CLASS = '.n4-quick-search-submit';

  /**
   * The generic bajaux Quick Search Widget.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/search/rc/QuickSearchWidget
   */
  var QuickSearchWidget = function QuickSearchWidget() {
    /** remember to call super constructor. Javascript won't do this for you */
    Widget.apply(this, arguments);
    // TODO: Do I need this subscriber mixin?
    subscriberMixin(this);
  };

  //extend and set up prototype chain
  QuickSearchWidget.prototype = Object.create(Widget.prototype);
  QuickSearchWidget.prototype.constructor = QuickSearchWidget;

  /**
   * Do initial setup of the DOM for the widget. This will set up the DOM's
   * structure and create a space where the commands and table will go.
   *
   * @param {jQuery} element the DOM element into which to load this Widget
   */
  QuickSearchWidget.prototype.doInitialize = function (dom) {
    var that = this;

    dom.html(tplQuickSearchWidgetStructure({
      submitText: lex.get('SearchWidget.commands.search.label')
    }));

    // Query text field handler (submit search on enter key press)
    dom.on('keypress', QUERY_CLASS, function( event ) {
      if ( event.which === 13 ) {
        var query = baja.SlotPath.escape(dom.find(QUERY_CLASS).first().val()),
            ordInSession = that.value().getOrdInSession().toString(),
            ord = ordInSession + '|service:search:SearchService|view:search:SearchWidget?query=' + query;

        if (typeof niagara !== 'undefined' && niagara.env) {
          niagara.env.hyperlink(ord);
        }
      }
    });

    // Search button handler
    dom.on('click', SEARCH_CLASS, function () {
      var query = baja.SlotPath.escape(dom.find(QUERY_CLASS).first().val()),
          ordInSession = that.value().getOrdInSession().toString(),
          ord = ordInSession + '|service:search:SearchService|view:search:SearchWidget?query=' + query;

      if (typeof niagara !== 'undefined' && niagara.env) {
        niagara.env.hyperlink(ord);
      }
    });

  };

  return QuickSearchWidget;
});
