/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/driver/rc/wb/mgr/PointMgr
 */
define(['baja!', 'lex!driver,webEditors', 'Promise', 'jquery', 'underscore', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'baja!driver:ProxyExt'], function (baja, lexs, Promise, $, _, DriverMgr) {
  'use strict';

  var CONTROL_POINT_TYPE = baja.lt('control:ControlPoint');

  /**
   * Return the BStatus if the row's subject is a control point. This is used when setting the
   * status color css on the row.
   *
   * @param {*} subject - the subject for a row in the table. Normally either a BControlPoint subclasss or BFolder.
   * @returns {baja.Status} - the status for the point, or null if the row is not a control point.
   */
  function getControlPointStatus(subject) {
    return baja.hasType(subject, baja.lt(CONTROL_POINT_TYPE)) ? subject.getOut().getStatus() : null;
  }

  /**
   * API Status: **Development**
   * 
   * Instance for managing points inside a container.
   *
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/PointMgr
   * @extends module:nmodule/driver/rc/wb/mgr/DriverMgr
   *
   * @param {Object} [params] an object containing the constructor parameters.
   * @param {String} [params.keyName] the key name used for lexicon entries for this view.
   * @param {String} [params.moduleName] the module name used for lexicon entries for this view.
   * @param {Number} [params.subscriptionDepth] the depth to subscribe the component tree. If not
   * specified, the default depth will be 3, which will subscribe to the first level of properties
   * on a point's proxy extension.
   */
  var PointMgr = function PointMgr(params) {
    var that = this;

    // Set the subscription depth, if one is specified in the parameters. If it's not specified,
    // we'll default to 3, so we get the first level of properties on the point's proxy
    // extension.

    DriverMgr.call(that, _.defaults(params, {
      subscriptionDepth: 3,
      editableTypes: [CONTROL_POINT_TYPE],
      getComponentStatus: getControlPointStatus
    }));
  };
  PointMgr.prototype = Object.create(DriverMgr.prototype);
  PointMgr.prototype.constructor = PointMgr;

  /**
   * Function to return an array of types to be offered upon the execution
   * of the command to add new instances.
   *
   * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
   */
  PointMgr.prototype.getNewTypes = function () {
    var model = this.getMainTable().value();
    return model.getNewTypes();
  };
  return PointMgr;
});
//# sourceMappingURL=PointMgr.js.map
