/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/driver/rc/wb/mgr/DeviceMgr
 */
define(['baja!', 'underscore', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'baja!driver:Device'], function (baja, _, DriverMgr) {
  'use strict';

  var DEVICE_TYPE = baja.lt('driver:Device');

  /**
   * Return the BStatus if the row's subject is a device. This is used when setting the
   * status color css on the row.
   *
   * @param {*} subject - the subject for a row in the table. Normally either a BDevice or BFolder.
   * @returns {baja.Status} - the status for the device, or null if the row is not a device.
   */
  function getDeviceStatus(subject) {
    return baja.hasType(subject, DEVICE_TYPE) ? subject.getStatus() : null;
  }

  /**
   * API Status: **Development**
   * 
   * Instance for managing devices inside a container.
   *
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/DeviceMgr
   * @extends module:nmodule/driver/rc/wb/mgr/DriverMgr
   *
   * @param {Object} [params] an object containing the constructor parameters.
   * @param {String} [params.keyName] the key name used for lexicon entries for this view.
   * @param {String} [params.moduleName] the module name used for lexicon entries for this view.
   * @param {Number} [params.subscriptionDepth] the depth to subscribe the component tree. Will
   * default to 1, if not specified.
   */
  var DeviceMgr = function DeviceMgr(params) {
    DriverMgr.call(this, _.defaults(params, {
      subscriptionDepth: 1,
      editableTypes: [DEVICE_TYPE],
      getComponentStatus: getDeviceStatus
    }));
  };
  DeviceMgr.prototype = Object.create(DriverMgr.prototype);
  DeviceMgr.prototype.constructor = DeviceMgr;
  return DeviceMgr;
});
//# sourceMappingURL=DeviceMgr.js.map
