/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/XYPointEditor
 */
define(['nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'jquery', 'Promise', 'nmodule/driver/rc/baja/XYPoint'], function (BaseWidget, fe, $, Promise, XYPoint) {
  'use strict';

  /**
   * A basic editor for a point with X and Y double values
   * @class
   * @alias module:nmodule/driver/rc/fe/XYPointEditor
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  var XYPointEditor = function XYPointEditor() {
    BaseWidget.apply(this, arguments);
  };
  XYPointEditor.prototype = Object.create(BaseWidget.prototype);
  XYPointEditor.prototype.constructor = XYPointEditor;
  XYPointEditor.prototype.doInitialize = function (dom) {
    return Promise.join(fe.buildFor({
      value: 0.0,
      dom: $("<div class='js-x'/>").appendTo(dom),
      formFactor: 'mini'
    }), fe.buildFor({
      value: 0.0,
      dom: $("<div class='js-y'/>").appendTo(dom),
      formFactor: 'mini'
    }));
  };
  XYPointEditor.prototype.$getXEditor = function () {
    return this.jq().children(".js-x").data("widget");
  };
  XYPointEditor.prototype.$getYEditor = function () {
    return this.jq().children(".js-y").data("widget");
  };
  XYPointEditor.prototype.doLoad = function (value) {
    return Promise.join(this.$getXEditor().load(value.xValue()), this.$getYEditor().load(value.yValue()));
  };
  XYPointEditor.prototype.doRead = function () {
    return Promise.join(this.$getXEditor().read(), this.$getYEditor().read()).spread(function (xVal, yVal) {
      return new XYPoint({
        x: xVal,
        y: yVal
      });
    });
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  XYPointEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  return XYPointEditor;
});
//# sourceMappingURL=XYPointEditor.js.map
