/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/LinearConversionEditor
 */
define(['nmodule/webEditors/rc/fe/baja/BaseEditor', 'jquery', 'Promise', 'nmodule/webEditors/rc/servlets/registry', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'baja!', 'baja!driver:LinearConversion', 'nmodule/webEditors/rc/fe/fe', 'lex!driver', 'bajaux/events', 'hbs!nmodule/driver/rc/fe/templates/LinearConversionEditor', 'css!nmodule/driver/rc/driver'], function (BaseEditor, $, Promise, registry, _, typeUtils, baja, LinearConversion, fe, Lexs, events, templateEditor) {
  'use strict';

  var driverLex = Lexs[0];
  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;

  /**
   * LinearConversionEditor is a bajaux field editor a BProxyConversion
   * property. This property is a proxy conversion type that
   * additionally takes scale and offset parameters. It is
   * part of a composite Proxy Extension component of any protocol point.
   *
   * @private
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/driver/rc/fe/LinearConversionEditor
   */
  var LinearConversionEditor = function LinearConversionEditor() {
    BaseEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  LinearConversionEditor.prototype = Object.create(BaseEditor.prototype);
  LinearConversionEditor.prototype.constructor = LinearConversionEditor;

  /**
   * Initial is a one-time setup activity. The select html control is
   * initialized with all possible proxy extension types available to be set.
   *
   * @param {jQuery} dom the DOM element into which to load this widget
   * @return {Promise}
   */
  LinearConversionEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.html(templateEditor({
      labels: {
        scale: driverLex.get("LinearConversion.scale"),
        offset: driverLex.get("LinearConversion.offset")
      }
    }));
    return Promise.join(fe.buildFor({
      value: 0.0,
      dom: $(".js-scale", dom.children(".js-scaleEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.scale"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    }), fe.buildFor({
      value: 0.0,
      dom: $(".js-offset", dom.children(".js-offsetEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.offset"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    }));
  };
  /**
   * Get the scale editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the scale editor
   */
  LinearConversionEditor.prototype.$getScaleEditor = function () {
    return this.jq().find(".js-scale").data("widget");
  };

  /**
   * Get the offset editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the offset editor
   */
  LinearConversionEditor.prototype.$getOffsetEditor = function () {
    return this.jq().find(".js-offset").data("widget");
  };

  /**
   * The field editor is of type driver:LinearConversion and loaded into
   * by any confirming types. The loaded in value is then set as default
   * values of the scale and offset widgets.
   *
   * @param {baja.Simple} value `driver:LinearConversion` instance to load
   * @return {Promise}
   */
  LinearConversionEditor.prototype.doLoad = function (value) {
    var vals = value.encodeToString() === "" ? [1, 0] : value.encodeToString().split(";");
    return Promise.join(this.$getScaleEditor().load(parseFloat(vals[0])), this.$getOffsetEditor().load(parseFloat(vals[1])));
  };

  /**
   * driver:LinearConversion is the type that is set so it matches
   * the loaded in value type.
   *
   * @returns {Promise} promise to be resolved with the current value
   */
  LinearConversionEditor.prototype.doRead = function () {
    return Promise.join(this.$getScaleEditor().read(), this.$getOffsetEditor().read()).spread(function (scale, offset) {
      return baja.$("driver:LinearConversion", scale, offset);
    });
  };

  /**
   * Enables or disables the scale and offset text boxes.
   *
   * @param {Boolean} enabled
   */
  LinearConversionEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Disables or enables the scale and offset text boxes.
   *
   * @param {Boolean} readonly
   */
  LinearConversionEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  LinearConversionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return LinearConversionEditor;
});
//# sourceMappingURL=LinearConversionEditor.js.map
