/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/baja/LinearWithUnitConversion
 */
define(['baja!', 'bajaScript/baja/obj/objUtil', 'lex!driver'], function (baja, objUtil, lexs) {
  'use strict';

  var Simple = baja.Simple,
    cacheDecode = objUtil.cacheDecode,
    cacheEncode = objUtil.cacheEncode,
    lexDriver = lexs[0];

  /**
   * Bajascript object representing a Linear Conversion with Unit Conversion (of driver:LinearWithUnitConversion type)
   * @class
   * @extends baja.Simple
   * @alias module:nmodule/driver/rc/baja/LinearWithUnitConversion
   */
  var LinearWithUnitConversion = function LinearWithUnitConversion() {
    Simple.apply(this, arguments);
  };
  LinearWithUnitConversion.prototype = Object.create(Simple.prototype);
  LinearWithUnitConversion.prototype.constructor = LinearWithUnitConversion;
  LinearWithUnitConversion.make = function (scale, offset, applyUnitsToDevice) {
    if (isNaN(parseFloat(scale, 10))) {
      throw new Error(lexDriver.get("LinearConversion.error.invalidParam", lexDriver.get("LinearConversion.scale")));
    }
    if (isNaN(parseFloat(offset, 10))) {
      throw new Error(lexDriver.get("LinearConversion.error.invalidParam", lexDriver.get("LinearConversion.offset")));
    }
    var lc = new LinearWithUnitConversion();
    lc.$scale = scale;
    lc.$offset = offset;
    lc.$applyUnitsToDevice = applyUnitsToDevice;
    return lc;
  };
  LinearWithUnitConversion.prototype.make = function () {
    return LinearWithUnitConversion.make.apply(LinearWithUnitConversion, arguments);
  };
  LinearWithUnitConversion.prototype.getScale = function () {
    return this.$scale;
  };
  LinearWithUnitConversion.prototype.getOffset = function () {
    return this.$offset;
  };
  LinearWithUnitConversion.prototype.getApplyUnitsToDevice = function () {
    return this.$applyUnitsToDevice;
  };

  /**
   * Decode a `LinearWithUnitConversion` from a string representation.
   *
   * @function
   * @param {String} str
   * @returns {module:nmodule/driver/rc/baja/LinearWithUnitConversion}
   */
  LinearWithUnitConversion.prototype.decodeFromString = cacheDecode(function (str) {
    if (!str || str.split(";").length < 3) {
      return LinearWithUnitConversion.DEFAULT;
    }
    var a = str.split(";");
    return LinearWithUnitConversion.make(parseFloat(a[0], 10), parseFloat(a[1], 10), a[2] === 'true');
  });

  /**
   * Encode this `LinearWithUnitConversion` to a string of the form '<scale>;<offset>'.
   *
   * @function
   * @returns {String}
   */
  LinearWithUnitConversion.prototype.encodeToString = cacheEncode(function () {
    return this.$scale + ";" + this.$offset + ";" + this.$applyUnitsToDevice.toString();
  });
  LinearWithUnitConversion.DEFAULT = LinearWithUnitConversion.make(1.0, 0.0, false);

  /**
   * Register this baja type as 'driver:LinearWithUnitConversion'
   */
  baja.registerType('driver:LinearWithUnitConversion', function () {
    return LinearWithUnitConversion;
  });
  return LinearWithUnitConversion;
});
//# sourceMappingURL=LinearWithUnitConversion.js.map
