/**
 * @file A page view for a JQM list that takes up an entire page.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['mobile/util/mobile/views/PageView', 'mobile/util/mobile/views/ListView'], function (PageView, ListView) {

  "use strict";

  /**
   * A full-JQM-page view for displaying a ListView.
   * 
   * @class
   * @memberOf niagara.util.mobile
   * @extends niagara.util.mobile.PageView
   */

  var ListPageView = PageView.subclass();

  ListPageView.prototype.highlight = function highlight(prop) {
    this.contentView.highlight(prop);
  };

  ListPageView.prototype.instantiateContentView = function instantiateContentView() {
    return new ListView();
  };

  return ListPageView;
});
