/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file AOP utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Slot-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the BaseFieldEditor object that all
 * field editors in Niagara mobile apps extend from. Also, functions relating
 * to registering field editors on Types.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Base field editor from which all others inherit.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Composite field editors.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Dialogs relating to field editors, including action invocation.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions to enable one-finger scrolling of an inline div (div must be
 * contained inside an overflow=auto div). Started off with touchscroll.js from
 * http://www.seabreezecomputers.com/tips/scroll-div.htm and massively reworked.
 *
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The Data Table model takes an ORD as the data source for the model and
 * resolves the ORD using either a default limit and offset or a declared
 * limit and offset. The values are retrieved from the data source ORD using
 * the baja.Ord.get method, which accepts a limit and offset as parameters.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Jason Spangler
 */

/**
 * @file The Data Table view extends the View framework, making use of the doLoad
 * method to instantiate a Data Table. The data table is created using one
 * or more ORDs to gather tabular data.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Jason Spangler
 */

/**
 * @file Niagara Mobile History
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Jason Spangler
 */

/**
 * @file Start the history nav app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,o){"use strict";function i(e){return String(e).replace(/[&<>"'\/]/g,function(e){return P[e]})}function r(){n.loading("show")}function a(){n.loading("hide")}function l(e){var n=e.find(':jqmData(role="header")'),o=e.find(':jqmData(role="footer")'),i=window.innerHeight||t(window).height();return n.length&&(i-=n.outerHeight()),o.length&&(i-=o.outerHeight()),i}function u(e,t){var n=t||e.children(':jqmData(role="content")'),o=l(e),i=n.outerHeight()-n.height();n.height(o-i),n.parent().height(Math.max(n.parent().height(),o)),setTimeout(function(){n.trigger("updatelayout")},100)}function c(e,n,o){e.on(n,o);var i=t._data(e[0]),r=i.events,a=r[n];a.length>1&&a.splice(0,0,a.pop())}function s(t,n,o){var i=this;i.$ticket=setTimeout(function(){i.$ticket&&r()},t),n&&(i.$timeoutTicket=setTimeout(function(){if(i.$ticket){var t="timeout "+n+"ms reached";"function"==typeof o?o(t):e.error(t)}i.hide()},n))}function d(e,t,n){return new s(e||1e3,t,n)}function f(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),o=n.first(),i=n.last();o.toggleClass("ui-corner-top",t),i.toggleClass("ui-corner-bottom",t),o.children("a").last().toggleClass("ui-corner-tr",t),i.children("a").last().toggleClass("ui-corner-br",t)}function p(e){f(e,!0)}function g(e){f(e,!1)}function m(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function h(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(D,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function v(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function y(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function b(t,n){n=y(n);var o;o=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(o.toUri())}function w(n,o){o=y(o);var i;i=o.viewQuery?e.Ord.make({base:n,child:o.viewQuery}):e.Ord.make(n),t.mobile.changePage(i.toUri(),o)}function C(n,i){var r=d(1e3);return o.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return r.hide(),e.typeSpec===niagara.view.typeSpec?w(n,i):b(n,i)},function(e){return r.hide(),b(n,i)})}function k(e,t){S().pagecontainer("change",e,t)}function S(){return t(":mobile-pagecontainer")}function T(){return S().pagecontainer("getActivePage")}function j(e){S().length?e():t(window).one("pagecontainercreate",e)}var D=/[^\w-_]/g,P={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return s.prototype.hide=function(){a();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:p,changePage:k,decodePageId:v,encodePageId:h,escapeHtml:i,getActivePage:T,getPageContainer:S,getVisibleHeight:l,hidePageLoadingMsg:a,linkToOrd:C,linkToOrdExternal:b,linkToOrdInternal:w,onPageContainerCreate:j,prependEventHandler:c,preventNavbarHighlight:m,removeListviewInset:g,setContentHeight:u,showPageLoadingMsg:r,spinnerTicket:d}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,o){"use strict";function i(e,t){1===arguments.length&&(t=e,e=N);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),x.push({isMatch:n,handler:t}),t}function r(e){if(!e)return null;var t;for(t=0;t<x.length;++t)if(x[t].isMatch(e))return x[t].handler;return null}function a(e){var t=e.page.attr("id")||N,n=r(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function l(t){t=e.objectify(t,"eventName");var n;for(n=0;n<x.length;++n)"function"==typeof x[n].handler[t.eventName]&&x[n].handler[t.eventName](t)}function u(){return P.attr("id")||""}function c(){return r(u())}function s(){return P}function d(){return E.attr("id")||""}function f(){return E}function p(){return r(d())}function g(){return D}function m(e,n){var o,i=n.toPage;n&&n.prevPage&&(o=t(n.prevPage)),P||(o=i),a({page:i,prevPage:o,event:e,eventName:"pageshow"}),"dialog"!==i.jqmData("role")&&(P=E,E=i)}function h(e,n){var o,i=t(e.target);i&&(n&&n.prevPage&&(o=t(n.prevPage)),P||(o=i),a({page:i,prevPage:o,event:e,eventName:e.type}))}function v(e,n){var o;n&&n.nextPage&&(o=t(n.nextPage)),a({page:E,nextPage:o,event:e,eventName:"pagehide"})}function y(e,n){D=!1;var o;n&&n.nextPage&&(o=t(n.nextPage)),a({page:E,nextPage:o,event:e,eventName:e.type})}function b(e,n){a({page:t(e.target),event:e,eventName:e.type})}function w(e){return e=decodeURI(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function C(e){return F(w(e))}function k(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function S(n,o){if(!O){var i,a=r(n),l=A();O=!0,o.pageData&&a&&"function"==typeof a.encodeUrl&&(n=a.encodeUrl(o.pageData)),i=C(n),l.children("#"+i).length||k(a,i,t.extend(o,{ok:function(e){e.attr("id",i),l.append(e),e.jqmData("pageData",o.pageData),e.page(),O=!1,t.mobile.changePage(e,o)},fail:function(t){O=!1,e.fail(t)}}))}}function T(n,o){if("string"==typeof o.toPage){var i,l,u,c=t.mobile.path.parseUrl(o.toPage),s=w(c.pathname+c.search),d=w(c.hash||""),f=w(c.pathname||""),p=d,g=A();if(!(d.indexOf("&ui-state=dialog")>-1)&&(i=r(p),i||(p=f,i=r(p)),i||(p=s,i=r(p)),i)){if(l=g.children("#"+C(p)),!l.length&&d&&(l=g.children("#"+C(d))),l.length||(l=g.children("#"+C(s))),d&&l.length||(o.options.dataUrl="/"+s),!l.length){if("function"!=typeof i.createPage)return;u=i.decodeUrl&&i.decodeUrl(c),o.options.pageData=u,o.options.url=c,e.started(function(){S(p,o.options)})}o.options.role&&"dialog"===o.options.role||l.is(".ui-dialog")||(l.length&&t.mobile.changePage(l,o.options),n.preventDefault())}}else if(o.toPage instanceof t){if(o.consumed)return;o.consumed=!0,"dialog"!==o.toPage.jqmData("role")&&(o.options.fromPage&&"dialog"!==o.options.fromPage.jqmData("role")&&a({page:o.options.fromPage,nextPage:o.toPage,event:n,eventName:"pagebeforechange",options:o.options}),n.isDefaultPrevented()||setTimeout(function(){o.toPage.trigger("pagelayout")},0))}}function j(){var e=A();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",b).on("pagecontainershow",m).on("pagebeforeshow","div",h).on("pagecontainerhide",v).on("pagebeforehide","div",y),e.on("pagecontainerbeforechange",T)}var D=!0,P=null,E=null,x=[],O=!1,F=o.encodePageId,A=o.getPageContainer,q=o.onPageContainerCreate,N="____DEFAULT_PAGE_$_$";return q(j),{register:i,getPrevName:u,getPrev:s,getPrevHandler:c,getCurrentName:d,getCurrent:f,getCurrentHandler:p,getHandler:r,fire:a,fireAll:l,isFirst:g}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],o=!0,i=!1,r=void 0;try{for(var a,l=e[Symbol.iterator]();!(o=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);o=!0);}catch(e){i=!0,r=e}finally{try{!o&&l.return&&l.return()}finally{if(i)throw r}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,o,i,r,a){"use strict";function l(t,o){return t instanceof n?(o.html(t),i.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),o.text(String(t)),i.resolve()):"function"==typeof t?i.try(function(){return t(o.empty())}):void 0}function u(e){var t=r.getCurrent();return"string"==typeof e&&(e=f(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function c(t,o){var i=n(w.patternReplace({theme:"a"})),r=i.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(o,function(e,t){var o=n(C.patternReplace({value:e}));o.text(v.get({key:e,def:e})),o.appendTo(r)}),i.attr("id",t),0===t.indexOf("error")&&i.addClass("error"),i.appendTo(g()),i}var s=e.callbackify,d=a.decodePageId,f=a.encodePageId,p=a.getActivePage,g=a.getPageContainer,m=a.hidePageLoadingMsg,h=_slicedToArray(t,1),v=h[0],y={},b=void 0,w=void 0,C=void 0,k=!1;w='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',C='<a data-value="{value}" data-role="button" data-theme="a"></a>';var S=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,k=!0};y.DialogInvocation=S,S.prototype.close=function(e){e=e||"cancel";var t=this,i=t.$options,r=t.$returnPage;"string"==typeof r&&0!==r.indexOf("ord?")&&"#"!==r.charAt(0)&&(r="#"+r),r instanceof n||"string"==typeof r?o.changePage(r,n.extend({transition:"none",changeHash:u(r)},i)):"function"==typeof r?r.call(this,e):o.changePage(location.href,{transition:"none",changeHash:!1}),b=void 0},S.prototype.invoke=function(t,n){function o(e){k=!1,u.fail(e),n.fail(e),k||a.close(t)}var i=e.ok,r=y.error;n=s(n,i,r);var a=this,l=a.$params,u=s(l.callbacks,i,r),c="function"==typeof t?t:l[t];"function"!=typeof c&&(c=function(e){e.ok()});try{k=!1,c.call(a,{ok:function(){k||a.close(t),u.ok(),n.ok()},fail:o})}catch(e){o(e)}},S.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},S.prototype.load=function(){var e=this,t=e.$page,o=e.$params,i=t.find(":jqmData(role=header)"),r=t.find(":jqmData(role=content)"),a=r.children(".dialogDisplay"),u=i.find("a:jqmData(icon=delete)"),c=r.find(".dialogButtons a");return i.find("h1.title").text(o.title||""),c.off("click").addClass("ui-disabled"),u.off().on("click",function(){return e.invoke("cancel"),!1}),l(o.content||"",a).then(function(){c.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),c.removeClass("ui-disabled"),y.repositionDialog(t)},function(e){y.error("Failed to load dynamic dialog content: "+e)})},y.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),o=e.find(":jqmData(role=header)"),i=t.outerHeight(),r=n(window).height(),a=(r-i)/2,l=Math.max(a,15);t.css("margin-top",l),o.css("margin-top",l)},y.closeCurrent=function(){b&&b.close()},y.registerDialog=function(e,t){function i(e){b?b.load():e.page.find(".dialogDisplay").empty()}function a(i){var r=n("#"+e);return r.length||(r=c(e,t)),i.returnPage=b&&b.$returnPage||i.returnPage,b=new S(i,r),o.changePage(r,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),b}var l;l={load:a,pagebeforeshow:i},r.register(e,l)},function(){var e=y.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var T=function(e,t){return r.getHandler(e).load(t)};return y.yesNoCancel=function(e){return T("yesNoCancelDialog",e)},y.ok=function(e){return T("okDialog",e)},y.okCancel=function(e){return T("okCancelDialog",e)},y.cancel=function(e){return T("cancelDialog",e)},y.yesNo=function(e){return T("yesNoDialog",e)},y.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),m(),T("errorDialog",{title:v.get("appError"),content:t,ok:n})},y.unrecoverableError=function(t){var o,i=function(){location.reload()};return"function"==typeof t?o=t:(o=function(e){var o=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),i=n("<div/>").text(v.get("message.clickOKToReload"));e.append(o),e.append(i)},e.error(t)),m(),T("errorDialog",{title:v.get("unrecoverableError"),content:o,ok:i})},y.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},o=t.yes||n,i=t.no||n,a=t.redirect;return t.title=v.get("abandonChanges"),t.content=v.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=d(r.getCurrent())),t.yes=function(e){a&&this.redirect(a),o.call(this,e)},t.no=function(e){a&&this.redirect(a),i.call(this,e)},y.yesNoCancel(t)},y.showDialog=function(e,t){var n=r.getHandler(e);return n?n.load(t):y.error(v.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=p();"dialog"===e.jqmData("role")&&y.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){o.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),y}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return g(T.patternReplace({title:C.get("menu")}))}function n(e,t,n){if(e=h.filter(e,function(e){return e.isEnabled()}),g("a.commandsButton").trigger("onShowCommands",e),n=k(n),t=t||C.get("commands.title"),0===e.length)y.ok({title:t,content:C.get("commands.noneAvailable")});else var o=y.cancel({title:t,content:function(t){var n=h.map(e,function(e){var t=g("<li/>"),n=g("<a/>").appendTo(t);return e.toDisplayName().then(function(i){return n.text(i),n.click(function(){o.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return m.all(n).then(function(e){var n=g('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function o(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){S.contains(e)||S.push(e)})}function i(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){S.contains(e)||(S.length?S.splice(0,0,e):S.push(e))})}function r(e){var t=Array.prototype.slice.call(arguments);t.length>1?p.iterate(t,function(e){r(e)}):p.iterate(S,function(t,n){if(t===e)return S.splice(n,1),!0})}function a(){return S.slice(0)}function l(e){S=e}function u(){var e=a(),t=b.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:b.getCurrent()})),n(e),!1}function c(){return d}function s(){return f}e("css!mobile/util/mobile/commands"),e("jquerymobile");var d,f,p=e("baja!"),g=e("jquery"),m=e("Promise"),h=e("underscore"),v=e("bajaux/commands/Command"),y=e("mobile/util/mobile/dialogs"),b=e("mobile/util/mobile/pages"),w=e("mobile/util/mobile/mobile"),C=e("lex!mobile")[0],k=p.callbackify,S=[],T="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return f=new v("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(g("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&i(f),d=new v("%lexicon(mobile:commands.home)%",function(e){w.linkToOrd(p.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&i(d),{getCommandsButton:t,getHomeCmd:c,getLogoutCmd:s,showCommandsDialog:n,addDefaultCommand:o,prependDefaultCommand:i,removeDefaultCommand:r,getDefaultCommands:a,setDefaultCommands:l,showCommandsHandler:u}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/aop",["baja!"],function(e){"use strict";function t(t,n){return e.iterate(t,function(e){return e[n]},function(e){return e.prototype})}function n(e,o,i,r){if("function"!=typeof r)throw"missing AOP function wrapper";var a,l;if("function"==typeof e&&"function"==typeof o)return i=e,a=o,l=r(i,a),l.prototype=a.prototype,l;if("object"!==(void 0===e?"undefined":_typeof(e))&&"function"!=typeof e||"string"!=typeof o||"function"!=typeof i)throw"AOP functions must be called with argument signature [Function, Function] or [Object, String, Function]";a=t(e,o),e[o]=n(i,a,null,r)}function o(e,t,o){return n(e,t,o,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),o=e.call(this,n);if(!1!==o)return t.apply(this,o||n)}})}function i(e,t,o){return n(e,t,o,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),o=t.apply(this,n),i=e.call(this,n,o);return void 0===i?o:i}})}function r(t,n){e.strictArg(t,Object),n=e.objectify(n);var r=n.before||{},a=n.after||{};return e.iterate(r,function(e,n){o(t,n,e)}),e.iterate(a,function(e,n){i(t,n,e)}),t}function a(t,n){return e.strictArg(t,Function),r(t.prototype,n),t}return{advise:r,advisePrototype:a,after:i,before:o}}),define("mobile/util/slot",["baja!","jquery","Promise","underscore","baja!baja:Link,baja:Password,control:IWritablePoint"],function(e,t,n,o){"use strict";function i(e,t,n){if(t===n||t<0||n<0||t>=e.length||n>=e.length)return!1;var o=e.splice(t,1);return e.splice(n,0,o[0]),!0}function r(e,i,r,a){var l=e.getSlots().dynamic().toArray();return a(l,o.indexOf(l,e.getSlot(i)))?e.reorder(t.extend(r,{dynamicProperties:l})):n.resolve()}function a(e,t,n){return r(e,t,n,function(e,t){return i(e,t,t-1)})}function l(e,t,n){return r(e,t,n,function(e,t){return i(e,t,t+1)})}function u(e,t,n){return r(e,t,n,function(e,t){return i(e,t,0)})}function c(e,t,n){return r(e,t,n,function(e,t){return i(e,t,e.length-1)})}function s(t){var n=t.getFlags();return!!(e.Flags.CONFIRM_REQUIRED&n)}function d(t){return!!t.getType().is("baja:Password")||e.Flags.READONLY&t.getFlags()}function f(t){var n=t.getFlags();return!!(e.Flags.HIDDEN&n)||(!(!t.isProperty()||!t.getType().is("baja:Link"))||("wsAnnotation"===t.getName()||"displayNames"===t.getName()))}function p(e){return!e.getType().is("baja:Password")&&(!d(e)&&!f(e))}function g(e){return e.isAction()&&!f(e)}function m(t){var n,o,i=e.Facets.DEFAULT;return t&&t.getType().isComplex()&&(o=t.getSlots().properties().frozen().is("baja:Facets").firstValue(),"function"==typeof t.getFacets&&(n=t.getFacets())&&(i=e.Facets.make(i,n)),o&&(i=e.Facets.make(i,o))),i}function h(e){var t=e&&e.getType();if(t)return t.isComponent()?e:t.isComplex()?h(e.getParent()):void 0}function v(t,n){var o,i,r,a,l=e.Facets.DEFAULT,u=t&&t.getType();if(n&&t.getType().isComplex()&&(n=t.getSlot(n),n.isProperty()&&n.getType().isComplex()&&(t=t.get(n))),u&&u.isComplex()&&(o=h(t))&&(r=o.getType(),(i=m(o))&&(l=e.Facets.make(l,i))),n instanceof e.Slot){if(a=String(n),r&&r.is("control:IWritablePoint")&&(n.isFrozen()&&0===a.indexOf("in")||"set"===a||"fallback"===a||"override"===a||"emergencyOverride"===a))return l;l=e.Facets.make(l,n.getFacets())}return l}return{getFacets:v,isConfirmRequired:s,isEditable:p,isFireable:g,isHidden:f,isReadonly:d,moveDown:l,moveUp:a,moveToTop:u,moveToBottom:c}}),define("mobile/fieldeditors/fieldeditors",["baja!mobile:MobileFieldEditor","baja!","jquery","Promise","underscore","mobile/util/aop","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,o,i,r,a,l){"use strict";function u(e,t){var o=n('<div class="labeledEditor"/>').appendTo(t),i=n('<label class="editorLabel" />'),r=n('<div class="editorContainer"/>');return void 0!==e&&i.text(e),o.append(i).append(r),r}function c(e){var t=e.newCopy(!0);return t.editedSlots={},t.getSlots().properties().isComplex().each(function(e){var n=t.get(e);t.set({slot:e,value:c(n)})}),r.after(t,"set",function(e,t){var n=e[0];return this.editedSlots[String(n.slot)]=n.value,t}),t}function s(e,n){n=t.objectify(n);var i,a=n.doInitialize,l=n.doLoad,u=n.doRead,c=n.doSave;return t.strictAllArgs([a,l],[Function,Function]),i=t.subclass(function(){t.callSuper(i,this,arguments)},e),i.prototype.doInitialize=function(t){var n=this;return o.resolve(e.prototype.doInitialize.call(n,t)).then(function(){return a.call(n,t)})},i.prototype.doLoad=function(t){var n=this;return o.resolve(e.prototype.doLoad.call(n,t)).then(function(){return l.call(n,t)})},"function"==typeof u&&(i.prototype.doRead=u),"function"==typeof c&&(i.prototype.doSave=c),n.validate&&r.after(i.prototype,"postCreate",function(e){this.validators().add(n.validate)}),n.postCreate&&r.after(i.prototype,"postCreate",function(e){n.postCreate.call(this)}),n.doEnabled&&r.after(i.prototype,"doEnabled",function(e){n.doEnabled.apply(this,e)}),i}function d(e){return e?t.importTypes({typeSpecs:[e]}).then(function(e){var n=e[0];return!!n.is(x)||(!!n.is(O)||(t.error("fieldEditor facet "+n+" does not reference a sub-Type of MobileFieldEditor."),!1))},function(n){return t.error("fieldEditor facet "+e+" does not reference a known Type."),!1}):o.resolve(!1)}function f(e){function n(e){for(var t=S();e;){if(D[String(e)])return!0;if(t[String(e)])return!0;e=e.getSuperType()}}return null!==e&&void 0!==e?function(){return"string"==typeof e?t.importTypes({typeSpecs:[e]}).then(function(e){return e[0]}):e.getType?o.resolve(e.getType()):o.resolve(e)}().then(function(t){if(n(t))return!0;var o=e.getFacets&&e.getFacets();return d(o&&o.get(F))}):o.resolve(!1)}function p(e){return d(e).then(function(t){return!!t&&f(e)})}function g(e,t,n){var o="/ord/"+e;return o+="|view:mobile:MobileFieldEditorView%3FfeTypeSpec="+t+";typeSpecs="+n.join(",")}function m(e){e=String(e);var t=T(),n=S(),r=t&&t[e],a=[];return r?(i.each(r.js,function(t){a.push(g(t,e,r.agentOn))}),i.each(r.css,function(e){e.indexOf(".css")===e.length-4&&(e=e.substring(0,e.length-4)),a.push("css!"+e)}),E(a).then(function(){delete t[e],delete n[e]})):o.resolve()}function h(e){e=String(e);var t=S(),n=t&&t[e];if(!n)return o.resolve();var r=i.map(n,function(e){return m(e)});return o.all(r).then(function(){delete t[e]})}function v(e){return e.is(x)?m(e):h(e)}function y(e){return e?v(e).then(function(){return y(e.getSuperType())}):o.resolve()}function b(e,n){var i;return e?("string"==typeof e&&(e=t.lt(e)),n=n||"default",y(e).then(function(){for(;!i&&e;){if((i=D[String(e)])&&i[n])return i[n];e=e.getSuperType()}return b("baja:String","default")})):o.reject("cannot get field editor for null type")}function w(e,t,n){if(!e)throw new Error("cannot register field editor for null type");if("function"!=typeof t)throw new Error("editor is required");e=String(e),n=n||"default";var o=D[e]||{};return o[n]=t,D[e]=o,t}function C(e,n,o,i){var r,l=P;return r=n&&o?a.getFacets(n,o):a.getFacets(e),r&&(l=t.Facets.make(l,r)),i&&(l=t.Facets.make(l,i)),l}function k(){return"undefined"!=typeof niagara&&niagara.view||{}}function S(){return k().customFieldEditors||{}}function T(){return k().fieldEditorResources||{}}function j(e,n){arguments.length<2&&(n=e,e=null);try{t.strictArg(n),!1!==n.autoInitialize&&t.strictArg(n.element)}catch(e){return o.reject("element is required to initialize - did you mean to set autoInitialize = false?")}if(void 0===n.value){try{t.strictArg(n.container,t.Complex)}catch(e){return o.reject("container is required when value is undefined")}n.value=n.container.get(n.slot)}var i,r,a,l=n.value,u=!1!==n.autoInitialize,c=n.element,s=n.type||l.getType(),d=n.key;return r=n.container||l.getParent&&l.getParent(),a=n.slot||l.getPropertyInParent&&l.getPropertyInParent(),n.facets=C(l,r,a,n.facets),i=n.facets.get(F),p(i).then(function(o){function f(e){var t=new e(l,r,a,n);return u?t.initialize(c).then(function(){return t.load(l)}).then(function(){return t}):t}return o&&(s=t.lt(i)),e?f(e):b(s,d).then(f)})}var D={},P=t.Facets.make({timeFormat:t.getTimeFormatPattern(),unitConversion:t.getUnitConversion()}),E=l.doRequire,x="mobile:MobileFieldEditor",O="workbench:WbFieldEditor",F="fieldEditor";return{composite:{},defineEditor:s,isRegistered:f,makeFor:j,register:w,toLabeledEditorContainer:u,toSaveDataComponent:c}}),define("mobile/fieldeditors/BaseFieldEditor",["baja!","bajaux/Widget","jquery","Promise","underscore","bajaux/events","bajaux/mixin/batchSaveMixin","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,o,i,r,a,l){"use strict";function u(e){return e.is('input[type="checkbox"]')||e.is('input[type="radio"]')}function c(t,n){e.iterate(n,function(e){t.addClass(String(e.getTypeSpec()).replace(":","-"))},function(e){return e.getSuperType()})}function s(t,n){var o=e.$(n).decodeFromString(t),i=g[n.toString()];return o.getDataTypeSymbol=function(){return i},o}function d(e,t){var n=e.getType&&e.getType();return!(!n||!n.isComponent())&&(!e.editedSlots&&e!==t)}var f=l.doRequire,p=a.COMMIT_READY,g={"baja.Boolean":"b","baja:Integer":"i","baja:Long":"l","baja:Float":"f","baja:Double":"d","baja:String":"s","baja:DynamicEnum":"e","baja:EnumRange":"E","baja:AbsTime":"a","baja:RelTime":"r","baja:TimeZone":"z","baja:Unit":"u"},m=i.once(function(){return f("mobile/fieldeditors/fieldeditors")}),h=function(n,o,i,r){if(t.call(this,"mobile","BaseFieldEditor"),void 0===n||null===n)return this;r=e.objectify(r),n.getType().isComplex()&&!n.getType().isComponent()&&(n=n.newCopy()),this.$value=n,this.container=o||n.getParent&&n.getParent(),this.slot=i||n.getName&&n.getName(),this.name=String(this.slot),this.params=r,this.facets=r.facets||e.Facets.DEFAULT,this.label=r.label||o&&o.getDisplayName&&i&&o.getDisplayName(i)||n.getName&&n.getName()||i&&String(i),this.parent=r.parent,this.$enabled=!r.readonly,this.$kids=[],this.postCreate(),a(this)};return h.prototype=Object.create(t.prototype),h.prototype.constructor=h,h.prototype.setModified=function(o,i){if(!this.isLoading()){t.prototype.setModified.apply(this,[o]),i=e.objectify(i);var r=this,a=r.parent,l=r.jq();o&&(a&&a.setModified(!0,n.extend({silent:!0},i)),l&&!i.silent&&l.trigger("modified.view",[r,i]))}},h.prototype.postCreate=function(){},h.prototype.doEnabled=function(e){var t=this.jq(),n=t&&t.find("select,input,textarea");n&&(e?n.removeAttr("disabled"):n.attr("disabled","disabled"))},h.$detectChangeEvent=function(){var e,t=n(this),o=t.closest("div.editor"),i=o.data("editor"),r=t.data("oldValue");e=u(t)?t.is(":checked"):t.val(),i.isLoading()||void 0===r||r===e||i.setModified(!0,{oldValue:r,newValue:e,element:t}),t.data("oldValue",e)},h.prototype.buildAndLoad=function(e){var t=this;return t.initialize(e).then(function(){return t.load(t.value())})},h.prototype.load=function(e){var o=this;return t.prototype.load.apply(o,arguments).then(function(e){var t=o.jq();return null!==e&&void 0!==e&&c(t,e.getType()),t.find("input,select,textarea").each(function(){var e=n(this);u(e)?e.data("oldValue",e.is(":checked")):e.data("oldValue",e.val())}),e})},h.prototype.initialize=function(e){return e=n('<div class="editor ui-field-contain"/>').data("editor",this).appendTo(e),e.on("change keyup","input,select,textarea",h.$detectChangeEvent),t.prototype.initialize.apply(this,[e])},h.prototype.read=function(){var n=this,o=n.value(),i=e.hasType(o)&&o.getType();return t.prototype.read.apply(n,arguments).then(function(e){return i&&i.is("baja:Simple")&&!i.is("baja:String")&&e.getType().is("baja:String")?s(e,i):e})},h.prototype.save=function(e){var t,n,o=this;return o.validate().then(function(i){if(t=i,n=i.getType&&i.getType(),d(t,o.value()))throw new Error("Component editors must support edit-by-ref semantics");return o.doSave(t,e)}).then(function(){var i=o.container,r=o.slot,a=e&&e.batch,l=e&&e.progressCallback;if(n&&!n.isComponent()&&i&&r){var u=i.set({slot:r,value:t,batch:a});return l&&l(p),u}return t}).then(function(){o.trigger(r.SAVE_EVENT),o.setModified(!1),o.$value=t})},h.prototype.doSave=function(t,n){var i=[],r=this.value();if(r.getType().isSimple())return t;if(t instanceof e.Component&&!t.editedSlots)throw new Error("provided raw instance of Component (type "+t.getType()+") to defaultDoSave - does your field editor use niagara.fieldEditors.toSaveDataComponent()?");var a=new e.comm.Batch;return e.iterate(t.editedSlots||t,function(e,t){i.push(r.set({slot:t,value:e.newCopy(!0),batch:a}))}),a.commit(),o.all(i).then(function(){return r})},h.prototype.makeChildFor=function(e){var t=this,n=t.$kids;return e.element=e.element||t.jq(),void 0===e.readonly&&(e.readonly=!t.isEnabled()),m().then(function(t){return t.makeFor(e)}).then(function(e){return n.push(e),e.parent=t,e})},h}),define("mobile/fieldeditors/fieldeditors.composite",["baja!","jquery","Promise","underscore","mobile/util/slot","mobile/fieldeditors/BaseFieldEditor","mobile/fieldeditors/fieldeditors"],function(e,t,n,o,i,r,a){"use strict";function l(e){var t={};return e.getSlots().properties().each(function(e){i.isEditable(e)&&(t[String(e)]="default")}),t}function u(o){return function(i,r){var u=this,c=u.value(),s=[],d=[];return e.iterate(o||l(c),function(e,n){var o=t('<div class="subEditor"/>').appendTo(i),l=c.getSlot(n),f=c.getDisplayName(l);s.push(u.makeChildFor({key:e.key,value:e.defaultValue||c.get(n),slot:l,container:c,facets:u.facets,autoInitialize:!1}).then(function(e){var t=a.toLabeledEditorContainer(f,o);return u.subEditorMap[l]=e,d.push(e.initialize(t,r)),e}))}),n.all(s).then(function(){return n.all(d)})}}function c(t){return function(o,i){var r=this,a=[],u=r.subEditorMap;return null===o||void 0===o?n.resolve(o):(e.iterate(t||l(o),function(e,t){var n=u[t],r=e.defaultValue||o.get(t);a.push(n.load(r,i))}),n.all(a))}}function s(t){return function(){var o=this.subEditorMap,i=[],r=this.value(),u=a.toSaveDataComponent(r);return e.iterate(t||l(r),function(e,t){var n=o[t];i.push(n.read().then(function(e){return u.set({slot:t,value:e})}))}),n.all(i).then(function(){return u})}}function d(t){return function(n){var o=this.subEditorMap,i=this.value();e.iterate(t||l(i),function(e,t){o[t].setEnabled(n)})}}function f(t){return function(){var o=[],i=this.subEditorMap,r=this.value();return e.iterate(t||l(r),function(e,t){var n=i[t];o.push(n.validate())}),n.all(o)}}var p={};return p.makeComposite=function(t,n,o){t=t||[],e.strictArg(t,Array);var i;return t.length&&(i={},e.iterate(t,function(e){"string"==typeof e?i[e]={key:"default"}:i[e.slot]={key:e.key||"default",defaultValue:e.defaultValue}})),a.defineEditor(n||r,{doInitialize:u(i),doLoad:c(i),doRead:s(i),doEnabled:d(i),validate:f(i),postCreate:function(){this.subEditorMap={},o&&o.validate&&this.validators().add(o.validate)}})},p.allSlots=function(){var e=p.makeComposite(),t=e.prototype.doInitialize;return e.prototype.doInitialize=function(e){e.addClass("allSlots"),t.call(this,e)},e},p}),define("mobile/fieldeditors/fieldeditors.dialogs",["baja!","lex!mobile","jquery","Promise","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/commands","mobile/util/slot"],function(e,t,n,o,i,r,a,l,u,c){"use strict";function s(t){function n(n){return new o(function(o,u){l.okCancel({title:t.title||String(a.getType()),content:function(e){return t.element=e,i.makeFor(n,t).then(function(e){r=e})},ok:function(t){var n=new e.comm.Batch;r.save({batch:n}).then(function(){return r.read()}).then(function(e){o(e),t.ok()},function(e){u(e),t.fail(e)}),n.commit()},cancel:function(e){o(null),e.ok()}})})}var r,a=t.value;return i.isRegistered(a.getType()).then(function(e){return n(e?null:p)})}function d(t){function i(){return e.clock.schedule(function(){e.station.sync()},500),h.invoke({slot:a,value:f})}function r(){return d?h.getActionParameterDefault({slot:a}).then(function(e){return f=e,t&&!t.facets&&(t.facets=c.getFacets(h)),s(n.extend(t,{title:h.getDisplayName(a),value:f})).then(function(e){return null!==e?(f=e,i()):null})}):i()}t=e.objectify(t);var a,u,d,f=null,p=t.slot,m=e.def(t.parameter,""),h=t.component;if(e.strictArg(h,e.Component),a=h.getSlot(p),
!a.isAction())throw new Error("slot '"+p+"' is not an action");if(u=a.getParamType(),m.equals("")||null===u||(m.getType().is(u)?f=m:"string"==typeof m&&u.isSimple()&&(f=u.getInstance().decodeFromString(m))),d=null===f&&null!==u,(h.getFlags(a)&e.Flags.CONFIRM_REQUIRED)===e.Flags.CONFIRM_REQUIRED)return new o(function(e,t){l.yesNo({content:g.get({key:"invoke.confirm",args:[h.getDisplayName(a)]}),yes:function(){r().then(e,t)},no:function(){e(null)}})});var v=r();return d||l.closeCurrent(),v}function f(e){var t=[];e.getSlots(function(e){return c.isFireable(e)}).each(function(n){t.push(new a(e.getDisplayName(n),function(){return d({component:e,slot:n,facets:e.get("facets")||{}})}))}),u.showCommandsDialog(t,g.get("actions"))}var p=r.allSlots(),g=t[0];return{action:d,fieldEditor:s,showAvailableActions:f}}),define("mobile/util/mobile/touchscroll",["baja!","jquery"],function(e,t){"use strict";function n(e){var t=e.originalEvent&&e.originalEvent.touches||[],n=e.originalEvent&&e.originalEvent.changedTouches||[];return t[0]||n[0]||e}function o(){try{return document.createEvent("TouchEvent"),!0}catch(e){return!1}}function i(){return e.iterate(u,function(e){if(navigator.userAgent.match(e))return!0})}function r(){return o()&&!i()}function a(e){var n={position:"absolute","background-color":"red",opacity:1},o={top:t("<div/>").css(n),bottom:t("<div/>").css(n),left:t("<div/>").css(n),right:t("<div/>").css(n)};return function(t){var n,i=o[t],r=e.height(),a=e.parent(),l=a.height();switch(t){case"top":n={left:0,top:0,right:0,height:5};break;case"left":n={left:0,top:0,width:5,height:r};break;case"bottom":n={right:0,bottom:l-r,left:0,height:5};break;case"right":n={top:0,right:0,height:r,width:5}}n.opacity=1,i.stop().css(n).remove().appendTo(e.parent()).animate({opacity:0},"fast",function(){i.remove()})}}function l(t,i){if(i=i||{horiz:!0,vert:!0,showBlockade:!0},i.force||r()){var l,u=0,p=0,g=i.horiz,m=i.vert,h=i.showBlockade?a(t):e.noop,v=o(),y=v?"touchstart":"mousedown",b=v?"touchmove":"mousemove",w=v?"touchend":"mouseup";t.on(y,function(e){var t=n(e);l={x:t.pageX,y:t.pageY},u=this.scrollLeft,p=this.scrollTop}),t.on(b,function(e){if(void 0!==l){var t=this,o=n(e),i=l.y-o.pageY,r=l.x-o.pageX,a=t.scrollTop,v=t.scrollLeft,y=t.scrollHeight-t.offsetHeight,b=a>0,w=a<y,C=t.scrollWidth-t.offsetWidth,k=v>0,S=v<C,T=i<-d,j=i>d,D=i<-f||i>f,P=T&&b&&m,E=j&&w&&m,x=P||E,O=r<-c,F=r>c,A=r<-s||r<s,q=O&&k&&g,N=F&&S&&g,R=q||N,H=R||x;D&&!m||A&&!g||(H?(t.scrollTop=p+i,t.scrollLeft=u+r,e.preventDefault()):T||j||O||F?(F&&g&&h("right"),O&&g&&h("left"),T&&m&&h("top"),j&&m&&h("bottom")):e.preventDefault())}}),t.on(w,function(){l=void 0})}}var u=[/android 3/i,/honeycomb/i,/macintosh/i,/playbook/i,/iphone os 5/i],c=0,s=15,d=0,f=15;return l}),define("mobile/history/table/DataTableModel",["baja!"],function(e){"use strict";function t(){var e,t;return{getColumn:function(){return t},getOrder:function(){return e},isOrderAsc:function(){return"ASC"===e},isOrderDesc:function(){return"DESC"===e},setColumn:function(e){t=e},setOrderAsc:function(){e="ASC"},setOrderDesc:function(){e="DESC"},clearState:function(){e=void 0,t=void 0}}}function n(e){return e.replace(l,"")}function o(t){var n=new e.OrdQueryList;return t.getCursor().each(function(e){"view"!==e.getSchemeName()&&n.add(e)}),n}function i(t,o,i){var r,a,l=" ORDER BY "+o+" "+i;return t.getCursor().each(function(e){"bql"===e.getSchemeName()&&(e.$body=n(e.$body)+l,r=!0)}),a=t.toString(),r||(a+="|bql:select *"+l),e.Ord.make(a)}function r(e,t){var n,r=t.getColumn(),a=t.getOrder();return void 0!==r&&(n=o(e.parse()),e=i(n,r,a)),e}function a(n){var o=e.objectify(n,"ord");this.dataOrd=e.strictArg(o.ord,e.lt("baja:Ord")),this.offset=o.offset||0,this.limit=o.limit||20,this.sortChangeCallback=void 0,this.colSortState=t(),this.registry={}}var l=/\s+order\s+by[\s\w]*$/i;return a.prototype.setSortOrder=function(e,t){this.colSortState.setColumn(e),"ASC"===t?this.colSortState.setOrderAsc():"DESC"===t?this.colSortState.setOrderDesc():this.colSortState.clearState()},a.prototype.getSortOrder=function(){return this.colSortState},a.prototype.next=function(){this.offset+=this.limit},a.prototype.previous=function(){this.offset-=this.limit,this.offset<0&&(this.offset=0)},a.prototype.get=function(e){var t=r(this.dataOrd,this.colSortState),n=this.offset,o=this.limit,i=e&&e.cursor||{},a=i.each;return t.get().then(function(e){return e.cursor({offset:n,limit:o,before:i.before,after:i.after,each:function(){return a&&a.apply(this,arguments)}}),e})},a.prototype.isSortable=function(){var e=this.dataOrd,t=e.parse();return!!t.get("history")||!!t.get("bql")},a.prototype.getOffset=function(){return this.offset},a.prototype.getLimit=function(){return this.limit},a.prototype.reset=function(){this.offset=0,this.colSortState.clearState()},a}),define("mobile/history/table/DataTableView",["baja!history:HistoryExt","baja!","bajaux/Widget","jquery","jquerymobile","Promise","mobile/util/mobile/mobile","mobile/history/table/DataTableModel","css!mobile/history/table/DataTable"],function(e,t,n,o,i,r,a,l){"use strict";function u(e){t.error(e),a.hidePageLoadingMsg(),o("<a href='#error' data-rel='dialog' data-transition='flip' />").click()}function c(e){var t,n=e.getFacets(),o=n?n.get("units"):void 0,i=e.getDisplayName();return o&&(o=o.encodeToString().split(";"),""!==(t=o[1])&&"null"!==t&&(i+=" "+t)),b(i)}function s(e){var t;for(t in y)!0!==y[t]&&o("."+t,e).hide()}function d(e,t,n){var o=t.getSortOrder(),i=o.getColumn();return void 0===i||i!==n?t.setSortOrder(n,"ASC"):i===n&&(o.isOrderAsc()?t.setSortOrder(n,"DESC"):t.setSortOrder(n,"NONE")),e.makeTable(t)}function f(e,t){return function(){var n=o(this),i=n.attr("data-sort");d(e,t,i).then(function(t){var o=n.parents("."+w),i=o.parent();o.fadeOut(100,function(){o.remove(),t.appendTo(i).hide().fadeIn(100,function(){e.onpageswap(t)})})}).catch(u)}}function p(e,t){var n,i,r,a,l="",u=e.columns,s=o("<tr />"),d=t.getSortOrder(),p=d.getColumn();for(t.isSortable()&&(a=f(e,t)),n=0;n<u.length;++n)i=b(u[n].getDisplayName().replace(/\s/g,"-")),void 0!==p&&p===u[n].getName()?d.isOrderAsc()?l="ui-btn-icon-right ui-icon-arrow-u":d.isOrderDesc()&&(l="ui-btn-icon-right ui-icon-arrow-d"):l="",r=o(C.patternReplace({id:i,name:u[n].getName(),icon:l,display:c(u[n])})),r.appendTo(s),a&&r.click(a),void 0===y[i]&&(y[i]=!0);return s}function g(e,t){if(t){t.find(".nextTable").toggleClass("ui-disabled",!e)}}function m(e,t){if(t){t.find(".prevTable").toggleClass("ui-disabled",!e)}}var h,v=!1,y={},b=a.escapeHtml,w="tableDisplay",C='<th class="ui-navbar ui-bar-b fade {id}" data-sort="{name}"><span class="ui-btn ui-btn-up-b {icon}" style="border:0;margin:0;" ><span class="ui-btn-inner" aria-hidden="true"><span class="ui-btn-text">{display}</span></span></span></th>',k=function(e){n.apply(this,arguments),e=t.objectify(e,"limit"),this.mainDiv=o('<div class="NavTableMain" />'),this.limit=e.limit||20,this.model=void 0};return k.prototype=Object.create(n.prototype),k.prototype.constructor=k,k.prototype.makeTable=function(e){var t,n=e.getOffset(),i=e.getLimit(),a=o('<table border="1" />'),l=0,u=this;return new r(function(r,c){e.get({cursor:{offset:n,limit:i,each:function(){var e,t,n,i=o('<tr class="dataRow"/>');for(e=0;e<h.length;++e)t=b(h[e].getDisplayName().replace(/\s/g,"-")),n=b(this.getDisplay(h[e]))||"&nbsp;",i.append(o('<td class="'+t+'" >'+n+"</td>"));l++,a.append(i)},after:function(){var e,t=o('<div class="'+w+'" />'),i=o('<div class="tableContainer"/>');e=o('<tr><th colspan="{colspan}" class="ui-navbar ui-bar-b fade" ><span class="recordIdxText">{offset} - {limit}</span></th></tr>'.patternReplace({colspan:String(h.length),offset:l?String(n+1):"0",limit:String(n+l)})),a.prepend(e),i.append(a),t.append(i),s(t),r(t)}}}).then(function(n){var o,i;t=n.getColumns(),i=n.getCol("value"),i&&(u.$recordType=i.getType()),u.columns=h=t,o=p(u,e),a.append(o)}).catch(c)})},k.prototype.doLoad=function(e){function n(e){return o.ord=t.strictArg(e,"baja:Ord"),o.model=new l({ord:o.ord,limit:o.limit}),o.jq().append(o.mainDiv),o.makeTable(o.model).then(function(e){var t=e.find("tr.dataRow").length;o.mainDiv.html(e),e.show(),o.mainDiv.height(e.height()),g(t>=o.model.getLimit(),o.$footer),m(o.model.getOffset()>0,o.$footer),o.onpageswap(e)})}var o=this;return t.Ord.make(e).get().then(function(o){if(o.getType().is("history:HistoryExt")){var i=o.getHistoryConfig();return i.lease().then(function(){var e=i.getId();return n(t.Ord.make("history:"+e))})}return n(e)})},k.prototype.bindFooter=function(e){var t=this;t.$footer=e,a.preventNavbarHighlight(e),e.on("click","a",function(){var e=o(this);if(e.hasClass("ui-disabled"))return!1;t.swapTables(e.hasClass("nextTable")).catch(u)})},k.prototype.swapTables=function(e){if(v)return r.resolve();v=!0;var t,n,o=this,i=o.$footer,a=o.mainDiv.find("."+w),l=a.position(),u=o.mainDiv.parents(":jqmData(role=content)").width();return e?(this.model.next(),n=u+15,t={left:-n}):(this.model.previous(),n=-a.width()-15,t={left:l.left+u}),o.mainDiv.css("overflow","hidden"),o.makeTable(this.model).then(function(e){var r=e.find(".tableContainer table tr.dataRow").length;r>1?(e.css("left",n).css("right",n+e.width()),o.mainDiv.append(e),a.animate(t,"fast",function(){a.remove()}),e.animate({left:l.left},"fast",function(){v=!1,o.mainDiv.css("overflow","visible"),o.onpageswap(e)}),r<o.model.getLimit()?g(!1,i):g(!0,i),0===o.model.getOffset()&&m(!1,i)):(g(!1,i),o.model.previous(),v=!1),o.model.getOffset()>0&&m(!0,i)})},k.prototype.toggleColumnDisplay=function(e){var t="#checkbox-"+e,n=o(t).is(":checked");o("."+e).toggle(n),y[e]=n},k.prototype.onpageswap=function(e){},k}),define("mobile/history/table/historyTable",["baja!mobile:MobileHistoryAppTableView,mobile:HistoryServerSideHandler,history:HistoryRecord,history:NumericTrendRecord,history:BooleanTrendRecord,history:EnumTrendRecord,history:StringTrendRecord,history:AuditRecord,history:LogRecord","css!mobile/history/HistoryApp","css!mobile/history/css/HistoryTable","baja!","lex!mobile","jquery","bajaux/commands/Command","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/fieldeditors/fieldeditors.dialogs","mobile/util/mobile/mobile","mobile/util/mobile/touchscroll","mobile/history/table/DataTableView"],function(e,t,n,o,i,r,a,l,u,c,s,d,f){"use strict";function p(e){u.unrecoverableError(e)}function g(e){var t,n,i,r=niagara.view.history.query;n=o.Ord.make(r).parse(),n.getCursor().each(function(n){n.getSchemeName()===P&&(i=n.toString(),i.indexOf("?")>0&&(i=i.substring(0,i.indexOf("?"))),e&&(i+=e),void 0!==t?t+="|"+i:t=i)}),t=o.Ord.make(t,{viewQuery:new o.ViewQuery(D)}),C.load(t)}function m(){var e=C&&C.$recordType&&C.$recordType.is("baja:Number");return c.fieldEditor({title:k.get(j),value:T,showDelta:e,key:"historyQueryParams"}).then(function(e){null!==e&&(T=e,g(e))})}function h(e){var t=r(A),n=t.find("fieldset");t.appendTo(r(e)).hide(),e.click(function(n){r(n.target).closest(".ui-checkbox").length||(e.hasClass("expanded")?t.slideUp("medium",function(){e.removeClass("expanded")}):(e.addClass("expanded"),t.slideDown("medium")),e.toggleClass("ui-icon-arrow-u ui-icon-check"))}),o.iterate(C.columns,function(e){var t=S(e.getDisplayName().replace(/\s/g,"-"));r(q.patternReplace({i:t,display:S(e.getDisplayName())})).attr("checked","checked").appendTo(n).click(function(){C.toggleColumnDisplay(t)})}),t.find("input").checkboxradio().addClass("ui-btn-icon-left")}function v(){var e=niagara.view.history.displayName;document.title=e,r(O).text(e)}function y(){var e=niagara.view.history.query,t=r(E),n=t.children(":jqmData(role=header)"),i=n.find("a.colMenuBtn"),a=t.children(":jqmData(role=footer)"),l=r(x);return C=new f({limit:F,ord:e}),C.onpageswap=function(e){var t=e.find(".tableContainer");d(t,{horiz:!0,showBlockade:!0})},C.initialize(l).then(function(){return C.bindFooter(a),C.load(o.Ord.make(e))}).then(function(){h(i)})}function b(){return C.load(o.Ord.make(niagara.view.history.query))}function w(){var e=r("#historyTable"),t=e.children(":jqmData(role=header)"),n=new a(k.get(j),m);l.prependDefaultCommand(n),r("#commandsButton").click(l.showCommandsHandler),v(),t.css({"-webkit-transform":"none",overflow:"visible"}),void 0===C?y().catch(p):b().catch(p)}var C,k=i[0],S=s.escapeHtml,T=niagara.view.history.query,j="history.timeRange.select",D="mobile:MobileHistoryAppTableView",P="history",E="#historyTable",x="#historyTableContent",O="#historyTableTitle",F=20,A='<div class="colMenu"><div data-role="fieldcontain"><fieldset data-role="controlgroup"></fieldset></div>',q='<input type="checkbox" name="checkbox-{i}" id="checkbox-{i}" data-theme="a" /><label for="checkbox-{i}" >{display}</label>';return w}),require(["jquery","bajaux/bajaux.built.min"],function(e){"use strict";e(document).on("mobileinit",function(){e.mobile.autoInitializePage=!1}),require(["jquerymobile","mobile/history/table/historyTable"],function(e,t){t(),e.initializePage()})}),define("mobile/history/table/historytable.run",function(){});