/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/StringEditor
 */
define(['baja!', 'jquery', 'Promise', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils'], function (baja, $, Promise, MobileFieldEditor, feUtils) {

  'use strict';

  var getFacets = feUtils.getFacets,
      minMaxCheck = feUtils.minMaxCheck;

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/StringEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var StringEditor = function StringEditor() {
    var _this = this;

    MobileFieldEditor.apply(this, arguments);
    this.validators().add(function (value) {
      var facets = getFacets(_this);
      if (facets) {
        return minMaxCheck(_this, facets.get("min"), facets.get("max"), value.length);
      }
    });
  };
  StringEditor.prototype = Object.create(MobileFieldEditor.prototype);
  StringEditor.prototype.constructor = StringEditor;

  StringEditor.prototype.doInitialize = function (dom) {
    var input,
        facets = getFacets(this),
        fieldWidth;

    if (facets && facets.get("multiLine")) {
      fieldWidth = facets.get("fieldWidth");
      input = $('<textarea cols="40" rows="10"></textarea>');
      if (fieldWidth) {
        input.attr('cols', fieldWidth);
      }
    } else {
      input = $('<input type="text"/>');
    }

    input.attr('name', this.name).appendTo(dom).textinput();
  };

  StringEditor.prototype.doLoad = function (value) {
    if (value === null || value === undefined) {
      return;
    }

    var stringValue;

    if (typeof value.encodeToString === 'function') {
      stringValue = value.encodeToString();
    } else {
      stringValue = JSON.stringify(baja.bson.encodeValue(value));
      this.setEnabled(false);
    }

    this.jq().find('input,textarea').val(stringValue);
  };

  StringEditor.prototype.doRead = function () {
    return this.jq().find('input,textarea').val();
  };

  return StringEditor;
});
