var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/NonEditableEditor
 */
define(['lex!mobile', 'jquery', 'mobile/fieldeditors/MobileFieldEditor'], function (lexs, $, MobileFieldEditor) {

  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/NonEditableEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */


  var NonEditableEditor = function NonEditableEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  NonEditableEditor.prototype = Object.create(MobileFieldEditor.prototype);
  NonEditableEditor.prototype.constructor = NonEditableEditor;

  /**
   * @param {JQuery} dom
   */
  NonEditableEditor.prototype.doInitialize = function (dom) {
    dom.append('<span class="nonEditable" />');
  };

  NonEditableEditor.prototype.doLoad = function (value) {
    var span = this.jq().find('span'),
        msg = mobileLex.get({
      key: 'propsheet.message.nonEditable',
      def: 'Not Editable In Mobile Property Sheet'
    });

    span.text(value.getType() + " " + msg);
  };

  return NonEditableEditor;
});
