/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/DateEditor
 */
define(['baja!', 'jquery', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils'], function (baja, $, MobileFieldEditor, feUtils) {

  'use strict';

  var dateboxArmHandlers = feUtils.dateboxArmHandlers,
      getDateboxDefaultOptions = feUtils.getDateboxDefaultOptions;

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/DateEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var DateEditor = function DateEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  DateEditor.prototype = Object.create(MobileFieldEditor.prototype);
  DateEditor.prototype.constructor = DateEditor;

  /**
   * @param {JQuery} dom
   */
  DateEditor.prototype.doInitialize = function (dom) {
    dom.append(makeDateInput(this.name));
    dateboxArmHandlers(dom);
  };

  DateEditor.prototype.doLoad = function (value) {
    var dateInput = this.jq().find('input:jqmData(role=datebox)');

    return value.toDateString({ textPattern: 'YYYY-MM-DD' }).then(function (str) {
      dateInput.trigger('datebox', { method: 'set', value: str });
    });
  };

  DateEditor.prototype.doRead = function () {
    return getBajaDateFromDatebox(this);
  };

  function getBajaDateFromDatebox(editor) {
    var dateInput = editor.jq().find('input[name$=date]'),
        date = dateInput.datebox('getTheDate');
    return baja.Date.make({
      year: date.getFullYear(),
      month: date.getMonth(),
      day: date.getDate()
    });
  }

  function makeDateInput(slotName) {
    var dateInput = $('<input type="date" data-role="datebox" name="' + slotName + '_date" />'),
        options = getDateboxDefaultOptions();

    options.mode = 'calbox';
    options.useDialogForceFalse = true;
    options.calHighToday = false;

    dateInput.attr('data-options', JSON.stringify(options));

    return dateInput;
  }

  return DateEditor;
});
