/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available views" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Slot-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file ORD-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A base class for views used in JQM apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view for constructing a JQM list.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view to take up an entire JQM page.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to navbar management in Niagara apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The base ViewManager class, used for management of and
 * navigation between views.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A manager for navigating back and forth between PageViews.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Basic Web App Container View.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Start the desktop app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,i){"use strict";function o(e){return String(e).replace(/[&<>"'\/]/g,function(e){return N[e]})}function r(){n.loading("show")}function a(){n.loading("hide")}function l(e){var n=e.find(':jqmData(role="header")'),i=e.find(':jqmData(role="footer")'),o=window.innerHeight||t(window).height();return n.length&&(o-=n.outerHeight()),i.length&&(o-=i.outerHeight()),o}function s(e,t){var n=t||e.children(':jqmData(role="content")'),i=l(e),o=n.outerHeight()-n.height();n.height(i-o),n.parent().height(Math.max(n.parent().height(),i)),setTimeout(function(){n.trigger("updatelayout")},100)}function u(e,n,i){e.on(n,i);var o=t._data(e[0]),r=o.events,a=r[n];a.length>1&&a.splice(0,0,a.pop())}function c(t,n,i){var o=this;o.$ticket=setTimeout(function(){o.$ticket&&r()},t),n&&(o.$timeoutTicket=setTimeout(function(){if(o.$ticket){var t="timeout "+n+"ms reached";"function"==typeof i?i(t):e.error(t)}o.hide()},n))}function d(e,t,n){return new c(e||1e3,t,n)}function p(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),i=n.first(),o=n.last();i.toggleClass("ui-corner-top",t),o.toggleClass("ui-corner-bottom",t),i.children("a").last().toggleClass("ui-corner-tr",t),o.children("a").last().toggleClass("ui-corner-br",t)}function f(e){p(e,!0)}function g(e){p(e,!1)}function h(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function m(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(x,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function v(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function y(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function b(t,n){n=y(n);var i;i=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(i.toUri())}function w(n,i){i=y(i);var o;o=i.viewQuery?e.Ord.make({base:n,child:i.viewQuery}):e.Ord.make(n),t.mobile.changePage(o.toUri(),i)}function C(n,o){var r=d(1e3);return i.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return r.hide(),e.typeSpec===niagara.view.typeSpec?w(n,o):b(n,o)},function(e){return r.hide(),b(n,o)})}function P(e,t){k().pagecontainer("change",e,t)}function k(){return t(":mobile-pagecontainer")}function D(){return k().pagecontainer("getActivePage")}function j(e){k().length?e():t(window).one("pagecontainercreate",e)}var x=/[^\w-_]/g,N={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return c.prototype.hide=function(){a();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:f,changePage:P,decodePageId:v,encodePageId:m,escapeHtml:o,getActivePage:D,getPageContainer:k,getVisibleHeight:l,hidePageLoadingMsg:a,linkToOrd:C,linkToOrdExternal:b,linkToOrdInternal:w,onPageContainerCreate:j,prependEventHandler:u,preventNavbarHighlight:h,removeListviewInset:g,setContentHeight:s,showPageLoadingMsg:r,spinnerTicket:d}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";function o(e,t){1===arguments.length&&(t=e,e=q);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),$.push({isMatch:n,handler:t}),t}function r(e){if(!e)return null;var t;for(t=0;t<$.length;++t)if($[t].isMatch(e))return $[t].handler;return null}function a(e){var t=e.page.attr("id")||q,n=r(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function l(t){t=e.objectify(t,"eventName");var n;for(n=0;n<$.length;++n)"function"==typeof $[n].handler[t.eventName]&&$[n].handler[t.eventName](t)}function s(){return N.attr("id")||""}function u(){return r(s())}function c(){return N}function d(){return O.attr("id")||""}function p(){return O}function f(){return r(d())}function g(){return x}function h(e,n){var i,o=n.toPage;n&&n.prevPage&&(i=t(n.prevPage)),N||(i=o),a({page:o,prevPage:i,event:e,eventName:"pageshow"}),"dialog"!==o.jqmData("role")&&(N=O,O=o)}function m(e,n){var i,o=t(e.target);o&&(n&&n.prevPage&&(i=t(n.prevPage)),N||(i=o),a({page:o,prevPage:i,event:e,eventName:e.type}))}function v(e,n){var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:O,nextPage:i,event:e,eventName:"pagehide"})}function y(e,n){x=!1;var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:O,nextPage:i,event:e,eventName:e.type})}function b(e,n){a({page:t(e.target),event:e,eventName:e.type})}function w(e){return e=decodeURI(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function C(e){return I(w(e))}function P(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function k(n,i){if(!S){var o,a=r(n),l=V();S=!0,i.pageData&&a&&"function"==typeof a.encodeUrl&&(n=a.encodeUrl(i.pageData)),o=C(n),l.children("#"+o).length||P(a,o,t.extend(i,{ok:function(e){e.attr("id",o),l.append(e),e.jqmData("pageData",i.pageData),e.page(),S=!1,t.mobile.changePage(e,i)},fail:function(t){S=!1,e.fail(t)}}))}}function D(n,i){if("string"==typeof i.toPage){var o,l,s,u=t.mobile.path.parseUrl(i.toPage),c=w(u.pathname+u.search),d=w(u.hash||""),p=w(u.pathname||""),f=d,g=V();if(!(d.indexOf("&ui-state=dialog")>-1)&&(o=r(f),o||(f=p,o=r(f)),o||(f=c,o=r(f)),o)){if(l=g.children("#"+C(f)),!l.length&&d&&(l=g.children("#"+C(d))),l.length||(l=g.children("#"+C(c))),d&&l.length||(i.options.dataUrl="/"+c),!l.length){if("function"!=typeof o.createPage)return;s=o.decodeUrl&&o.decodeUrl(u),i.options.pageData=s,i.options.url=u,e.started(function(){k(f,i.options)})}i.options.role&&"dialog"===i.options.role||l.is(".ui-dialog")||(l.length&&t.mobile.changePage(l,i.options),n.preventDefault())}}else if(i.toPage instanceof t){if(i.consumed)return;i.consumed=!0,"dialog"!==i.toPage.jqmData("role")&&(i.options.fromPage&&"dialog"!==i.options.fromPage.jqmData("role")&&a({page:i.options.fromPage,nextPage:i.toPage,event:n,eventName:"pagebeforechange",options:i.options}),n.isDefaultPrevented()||setTimeout(function(){i.toPage.trigger("pagelayout")},0))}}function j(){var e=V();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",b).on("pagecontainershow",h).on("pagebeforeshow","div",m).on("pagecontainerhide",v).on("pagebeforehide","div",y),e.on("pagecontainerbeforechange",D)}var x=!0,N=null,O=null,$=[],S=!1,I=i.encodePageId,V=i.getPageContainer,T=i.onPageContainerCreate,q="____DEFAULT_PAGE_$_$";return T(j),{register:o,getPrevName:s,getPrev:c,getPrevHandler:u,getCurrentName:d,getCurrent:p,getCurrentHandler:f,getHandler:r,fire:a,fireAll:l,isFirst:g}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],i=!0,o=!1,r=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){o=!0,r=e}finally{try{!i&&l.return&&l.return()}finally{if(o)throw r}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,i,o,r,a){"use strict";function l(t,i){return t instanceof n?(i.html(t),o.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),i.text(String(t)),o.resolve()):"function"==typeof t?o.try(function(){return t(i.empty())}):void 0}function s(e){var t=r.getCurrent();return"string"==typeof e&&(e=p(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function u(t,i){var o=n(w.patternReplace({theme:"a"})),r=o.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(i,function(e,t){var i=n(C.patternReplace({value:e}));i.text(v.get({key:e,def:e})),i.appendTo(r)}),o.attr("id",t),0===t.indexOf("error")&&o.addClass("error"),o.appendTo(g()),o}var c=e.callbackify,d=a.decodePageId,p=a.encodePageId,f=a.getActivePage,g=a.getPageContainer,h=a.hidePageLoadingMsg,m=_slicedToArray(t,1),v=m[0],y={},b=void 0,w=void 0,C=void 0,P=!1;w='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',C='<a data-value="{value}" data-role="button" data-theme="a"></a>';var k=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,P=!0};y.DialogInvocation=k,k.prototype.close=function(e){e=e||"cancel";var t=this,o=t.$options,r=t.$returnPage;"string"==typeof r&&0!==r.indexOf("ord?")&&"#"!==r.charAt(0)&&(r="#"+r),r instanceof n||"string"==typeof r?i.changePage(r,n.extend({transition:"none",changeHash:s(r)},o)):"function"==typeof r?r.call(this,e):i.changePage(location.href,{transition:"none",changeHash:!1}),b=void 0},k.prototype.invoke=function(t,n){function i(e){P=!1,s.fail(e),n.fail(e),P||a.close(t)}var o=e.ok,r=y.error;n=c(n,o,r);var a=this,l=a.$params,s=c(l.callbacks,o,r),u="function"==typeof t?t:l[t];"function"!=typeof u&&(u=function(e){e.ok()});try{P=!1,u.call(a,{ok:function(){P||a.close(t),s.ok(),n.ok()},fail:i})}catch(e){i(e)}},k.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},k.prototype.load=function(){var e=this,t=e.$page,i=e.$params,o=t.find(":jqmData(role=header)"),r=t.find(":jqmData(role=content)"),a=r.children(".dialogDisplay"),s=o.find("a:jqmData(icon=delete)"),u=r.find(".dialogButtons a");return o.find("h1.title").text(i.title||""),u.off("click").addClass("ui-disabled"),s.off().on("click",function(){return e.invoke("cancel"),!1}),l(i.content||"",a).then(function(){u.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),u.removeClass("ui-disabled"),y.repositionDialog(t)},function(e){y.error("Failed to load dynamic dialog content: "+e)})},y.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),i=e.find(":jqmData(role=header)"),o=t.outerHeight(),r=n(window).height(),a=(r-o)/2,l=Math.max(a,15);t.css("margin-top",l),i.css("margin-top",l)},y.closeCurrent=function(){b&&b.close()},y.registerDialog=function(e,t){function o(e){b?b.load():e.page.find(".dialogDisplay").empty()}function a(o){var r=n("#"+e);return r.length||(r=u(e,t)),o.returnPage=b&&b.$returnPage||o.returnPage,b=new k(o,r),i.changePage(r,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),b}var l;l={load:a,pagebeforeshow:o},r.register(e,l)},function(){var e=y.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var D=function(e,t){return r.getHandler(e).load(t)};return y.yesNoCancel=function(e){return D("yesNoCancelDialog",e)},y.ok=function(e){return D("okDialog",e)},y.okCancel=function(e){return D("okCancelDialog",e)},y.cancel=function(e){return D("cancelDialog",e)},y.yesNo=function(e){return D("yesNoDialog",e)},y.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),h(),D("errorDialog",{title:v.get("appError"),content:t,ok:n})},y.unrecoverableError=function(t){var i,o=function(){location.reload()};return"function"==typeof t?i=t:(i=function(e){var i=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),o=n("<div/>").text(v.get("message.clickOKToReload"));e.append(i),e.append(o)},e.error(t)),h(),D("errorDialog",{title:v.get("unrecoverableError"),content:i,ok:o})},y.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},i=t.yes||n,o=t.no||n,a=t.redirect;return t.title=v.get("abandonChanges"),t.content=v.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=d(r.getCurrent())),t.yes=function(e){a&&this.redirect(a),i.call(this,e)},t.no=function(e){a&&this.redirect(a),o.call(this,e)},y.yesNoCancel(t)},y.showDialog=function(e,t){var n=r.getHandler(e);return n?n.load(t):y.error(v.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=f();"dialog"===e.jqmData("role")&&y.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){i.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),y}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return g(D.patternReplace({title:C.get("menu")}))}function n(e,t,n){if(e=m.filter(e,function(e){return e.isEnabled()}),g("a.commandsButton").trigger("onShowCommands",e),n=P(n),t=t||C.get("commands.title"),0===e.length)y.ok({title:t,content:C.get("commands.noneAvailable")});else var i=y.cancel({title:t,content:function(t){var n=m.map(e,function(e){var t=g("<li/>"),n=g("<a/>").appendTo(t);return e.toDisplayName().then(function(o){return n.text(o),n.click(function(){i.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return h.all(n).then(function(e){var n=g('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function i(){var e=Array.prototype.slice.call(arguments);f.iterate(e,function(e){k.contains(e)||k.push(e)})}function o(){var e=Array.prototype.slice.call(arguments);f.iterate(e,function(e){k.contains(e)||(k.length?k.splice(0,0,e):k.push(e))})}function r(e){var t=Array.prototype.slice.call(arguments);t.length>1?f.iterate(t,function(e){r(e)}):f.iterate(k,function(t,n){if(t===e)return k.splice(n,1),!0})}function a(){return k.slice(0)}function l(e){k=e}function s(){var e=a(),t=b.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:b.getCurrent()})),n(e),!1}function u(){return d}function c(){return p}e("css!mobile/util/mobile/commands"),e("jquerymobile");var d,p,f=e("baja!"),g=e("jquery"),h=e("Promise"),m=e("underscore"),v=e("bajaux/commands/Command"),y=e("mobile/util/mobile/dialogs"),b=e("mobile/util/mobile/pages"),w=e("mobile/util/mobile/mobile"),C=e("lex!mobile")[0],P=f.callbackify,k=[],D="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return p=new v("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(g("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&o(p),d=new v("%lexicon(mobile:commands.home)%",function(e){w.linkToOrd(f.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&o(d),{getCommandsButton:t,getHomeCmd:u,getLogoutCmd:c,showCommandsDialog:n,addDefaultCommand:i,prependDefaultCommand:o,removeDefaultCommand:r,getDefaultCommands:a,setDefaultCommands:l,showCommandsHandler:s}}),define("mobile/util/mobile/selectview",["baja!","lex!mobile","Promise","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/mobile","mobile/util/mobile/commands"],function(e,t,n,i,o,r,a){"use strict";function l(t){var n=t.getSlots(),i=[];return e.iterate(n,function(e){var n=t.get(e);i.push({displayName:n.get("displayName"),url:n.get("ord").toUri()})}),i}function s(t,n){var s=l(t),u=[];if(!s.length)return o.ok(d.get("views.noneAvailable"));e.iterate(s,function(e){u.push(new i(e.displayName,function(){r.linkToOrd(e.url)}))}),a.showCommandsDialog(u,void 0,n)}function u(t){return t=t||niagara.view.ord,r.showPageLoadingMsg(),e.rpc({typeSpec:"mobile:ComponentServerSideHandler",method:"getMobileAgentList",args:[String(t)]}).then(function(t){return e.bson.decodeValue(JSON.parse(t))}).then(function(e){s(e)}).catch(o.error).finally(function(){r.hidePageLoadingMsg()})}function c(){return f}var d=t[0],p="",f=new i("%lexicon(mobile:views.selectView)%",function(){return u(p)});return f.setOrd=function(e){p=e},niagara.view.profile.showViews&&a&&a.prependDefaultCommand(c()),{getViewsCommand:c}}),define("mobile/util/slot",["baja!","jquery","Promise","underscore","baja!baja:Link,baja:Password,control:IWritablePoint"],function(e,t,n,i){"use strict";function o(e,t,n){if(t===n||t<0||n<0||t>=e.length||n>=e.length)return!1;var i=e.splice(t,1);return e.splice(n,0,i[0]),!0}function r(e,o,r,a){var l=e.getSlots().dynamic().toArray();return a(l,i.indexOf(l,e.getSlot(o)))?e.reorder(t.extend(r,{dynamicProperties:l})):n.resolve()}function a(e,t,n){return r(e,t,n,function(e,t){return o(e,t,t-1)})}function l(e,t,n){return r(e,t,n,function(e,t){return o(e,t,t+1)})}function s(e,t,n){return r(e,t,n,function(e,t){return o(e,t,0)})}function u(e,t,n){return r(e,t,n,function(e,t){return o(e,t,e.length-1)})}function c(t){var n=t.getFlags();return!!(e.Flags.CONFIRM_REQUIRED&n)}function d(t){return!!t.getType().is("baja:Password")||e.Flags.READONLY&t.getFlags()}function p(t){var n=t.getFlags();return!!(e.Flags.HIDDEN&n)||(!(!t.isProperty()||!t.getType().is("baja:Link"))||("wsAnnotation"===t.getName()||"displayNames"===t.getName()))}function f(e){return!e.getType().is("baja:Password")&&(!d(e)&&!p(e))}function g(e){return e.isAction()&&!p(e)}function h(t){var n,i,o=e.Facets.DEFAULT;return t&&t.getType().isComplex()&&(i=t.getSlots().properties().frozen().is("baja:Facets").firstValue(),"function"==typeof t.getFacets&&(n=t.getFacets())&&(o=e.Facets.make(o,n)),i&&(o=e.Facets.make(o,i))),o}function m(e){var t=e&&e.getType();if(t)return t.isComponent()?e:t.isComplex()?m(e.getParent()):void 0}function v(t,n){var i,o,r,a,l=e.Facets.DEFAULT,s=t&&t.getType();if(n&&t.getType().isComplex()&&(n=t.getSlot(n),n.isProperty()&&n.getType().isComplex()&&(t=t.get(n))),s&&s.isComplex()&&(i=m(t))&&(r=i.getType(),(o=h(i))&&(l=e.Facets.make(l,o))),n instanceof e.Slot){if(a=String(n),r&&r.is("control:IWritablePoint")&&(n.isFrozen()&&0===a.indexOf("in")||"set"===a||"fallback"===a||"override"===a||"emergencyOverride"===a))return l;l=e.Facets.make(l,n.getFacets())}return l}return{getFacets:v,isConfirmRequired:c,isEditable:f,isFireable:g,isHidden:p,isReadonly:d,moveDown:l,moveUp:a,moveToTop:s,moveToBottom:u}}),define("mobile/util/ord",["baja!"],function(e){"use strict";function t(e){if(!e)return"";e=String(e);var t=e.length,n=e.substring(t-1,t),i=e.substring(t-2,t-1);return"/"===n&&":"!==i?e=e.substring(0,t-1):":"===n&&(e+="/"),e}function n(t,n){return t=e.Ord.make(t),void 0===n&&(n=!0),t.get({lease:n})}function i(e){e=unescape(String(e)),e.match(/\/$/)&&(e=e.substring(0,e.length-1));var n=e.split("/"),i=0,o=[];for(i=0;i<n.length;i++)o.push(t(n.slice(0,i+1).join("/")));return o}function o(t,n){return!(!t||!n)&&e.Ord.make(t).relativizeToSession().equals(e.Ord.make(n).relativizeToSession())}function r(t){if(t){if(t instanceof e.Ord||"string"==typeof t)return t.toString();if(t.getType().isComponent()&&t.isMounted())return t.getNavOrd().relativizeToSession().toString();if(t.getType().isComplex()){var n=r(t.getParent());if(n)return n+"/"+t.getPropertyInParent()}}}return{chopLastSlash:t,deriveOrd:r,equivalent:o,get:n,makeOrdHistory:i}}),define("mobile/util/mobile/views/MobileView",["baja!","jquery","Promise","bajaux/Widget"],function(e,t,n,i){"use strict";var o=function(){i.apply(this,arguments)};return o.prototype=Object.create(i.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(e){return n.resolve(i.prototype.doInitialize.call(this,e)).then(function(){e.enhanceWithin()})},o}),define("mobile/util/mobile/views/ListView",["baja!","jquery","jquerymobile","Promise","underscore","mobile/util/slot","mobile/util/ord","mobile/util/mobile/mobile","mobile/util/mobile/views/MobileView","bajaux/icon/iconUtils","bajaux/mixin/subscriberMixIn"],function(e,t,n,i,o,r,a,l,s,u,c){"use strict";function d(e){return e.getType().isComplex()}var p=l.encodePageId,f=l.decodePageId,g=l.getActivePage,h=u.toHtml,m=function(){s.apply(this,arguments),c(this)};return m.prototype=Object.create(s.prototype),m.prototype.constructor=m,m.prototype.shouldIncludeSlot=function(e){return e.isProperty()&&!e.isAction()&&!e.isTopic()},m.prototype.doInitialize=function(n){var i=this;return s.prototype.doInitialize.call(this,n).then(function(){n.on("click","a.expandable",function(){var n=t(this).children("span.slotName").text();return i.doExpand(n).catch(e.error),!1}),n.on("click","a.link",function(e){var n=t(this),o=n.parents("li.property").attr("id");i.linkClicked(f(o),n)})})},m.prototype.doLoad=function(t){var n=this;e.strictArg(t,e.Complex);var i=this.$highlightedSlot;return this.makeListView(t).then(function(e){n.$ul=e,n.jq().empty().append(e).enhanceWithin(),i&&n.highlight(i)})},m.prototype.scrollExpandedDivIntoView=function(e){var i=g(),o=e.offset().top+e.height(),r=i.children(":jqmData(role=header)").height(),a=i.children(":jqmData(role=footer)").height(),l=t(window),s=l.scrollTop(),u=s+l.height()-a;if(o>u){var c=e.prev().offset().top-r;n.silentScroll(Math.min(c,s+(o-u)))}},m.prototype.doExpand=function(e){var n=this,o=function(e){return"ui-icon-carat-"+e},r=this.value().getSlot(e),a=p(r.getName()),l=this.$ul.children("li#"+a),s=l.children(".expandable").removeClass("udrl".split("").map(o).join(" ")),u=l.next(".expanded");return new i(function(e){var i=function(t){s.addClass(o(t)),n.scrollExpandedDivIntoView(u),e()};u.length?u.is(":visible")?u.hide("fast",function(){return i("d")}):u.show("fast",function(){return i("u")}):(u=t('<div class="expanded"/>').insertAfter(l).hide(),n.populateExpandedDiv(r,u),u.show("fast",function(){return i("u")}))})},m.prototype.highlight=function(e){this.removeHighlight();var t=this.$ul,n=p(e);this.$highlightedSlot=e,t.children("li#"+n).addClass("ui-btn-active")},m.prototype.removeHighlight=function(){delete this.$highlightedSlot,this.$ul.children().removeClass("ui-btn-active")},m.prototype.linkClicked=function(e,t){this.highlight(e)},m.prototype.populateExpandedDiv=function(e,t){},m.prototype.makeListView=function(e){var n=this,a=e.getSlots(function(e){return n.shouldIncludeSlot(e)&&!r.isHidden(e)}).toArray(),l=o.map(a,function(t){return n.makeListItem(e,t)});return i.all(l).then(function(e){return t('<ul data-role="listview" data-theme="c" />').html(e)})},m.prototype.prependIcons=function(e,t){return t?h(t).then(function(t){return e.find(".bajaImage").html(t)}):i.resolve()},m.prototype.makeListItem=function(e,n){var i=this,o=t('<li class="property" data-icon="carat-r"/>').attr("id",p(String(n))).append('<span class="bajaImage"></span>');return this.makeListItemParams(e,n).then(function(e){return i.prependIcons(o,e.icon).then(function(){if(t('<label class="title" />').text(e.title||"").appendTo(o),t('<span class="hidden slotName" />').text(String(n)).appendTo(o),t('<div class="display" />').text(e.display||"").appendTo(o),e.linkable||e.expandable){var i=t("<a />");i.jqmData("ord",e.ord),e.expandable?(i.addClass("expandable"),o.attr("data-icon","carat-d")):i.addClass("link"),o.wrapInner(i)}return o})})},m.prototype.makeListItemParams=function(t,n){var o=t.get(n),l=a.deriveOrd(o);return n.getType().is("baja:VirtualGateway")&&(l+="|virtual:/"),i.resolve({ord:l,title:t.getDisplayName(n),display:e.SlotPath.unescape(t.getDisplay(n)),icon:o.getIcon(),expandable:r.isEditable(n),linkable:d(n)&&!r.isReadonly(n)})},m.prototype.updateDisplay=function(e){if(!this.$ul)return i.resolve();var t=p(String(e)),n=this.$ul.find("li.property#"+t),o=n.find("div.display"),r=this.value(),a=r.get(e);return o.length&&o.text(r.getDisplay(e)),i.resolve(a&&a.getType().isComponent()&&this.prependIcons(n,a.getIcon()))},m.prototype.getSubscriber=function(){var t=this,n=this.$subscriber;return n||(n=this.$subscriber=new e.Subscriber,n.attach("changed",function(e){return t.updateDisplay(e)}),n.attach("renamed",function(e,n){var i=p(e.getName()),o=p(n),r=t.$ul.children("li.property#"+o),l=t.value(),s=a.deriveOrd(l.get(e));r.find("label.title").addClass("renamed").text(l.getDisplayName(e)),r.find("span.slotName").text(e.getName()),r.find("a.link").jqmData("ord",s),r.attr("id",i)}),n.attach("removed",function(e){var n=p(e.getName()),i=t.$ul.children("li.property#"+n);i.find("a").removeClass("link expandable"),i.find("label.title").addClass("removed").append(" (removed)")}),n.attach("added",function(n){var i=t.value();t.makeListItem(i,n).then(function(e){return t.$ul.append(e).listview("refresh")}).catch(e.error)}),n)},m}),define("mobile/util/mobile/views/PageView",["baja!","bajaux/Widget","jquery","jquerymobile","Promise","css!mobile/util/mobile/views/PageView"],function(e,t,n,i,o){"use strict";var r=function(n){t.call(this,"mobile","PageView"),n=e.objectify(n,"contentViewConstructor"),this.contentViewConstructor=n.contentViewConstructor,this.$title=n.title,this.$ignoreProfileClasses=""};return r.prototype=Object.create(t.prototype),r.prototype.constructor=r,r.prototype.ignoreProfileClasses=function(e){this.$ignoreProfileClasses=e||""},r.prototype.createPage=function(){var e=n('<div class="ux-fullscreen-support" data-role="page" data-theme="c" />'),t=n('<div data-role="header" data-position="fixed" data-tap-toggle="false" data-theme="a" />').appendTo(e),i=n('<a href="#" class="profileHeader profileHeaderBack" data-rel="back" data-icon="arrow-l" data-iconpos="notext"></a>').appendTo(t),o=n('<h1 class="profileHeader viewName"/>').appendTo(t);return n('<div data-role="content" class="ux-root ux-fullscreen"/>').appendTo(e),i.removeClass(this.$ignoreProfileClasses),o.removeClass(this.$ignoreProfileClasses),e},r.prototype.toDisplayName=function(){return o.resolve(this.$title||this.contentView&&this.contentView.toDisplayName()||void 0)},r.prototype.getPage=function(){return this.jq()},r.prototype.getHeaderDiv=function(){return this.jq().children(":jqmData(role=header)")},r.prototype.getContentDiv=function(){return this.jq().children(":jqmData(role=content)")},r.prototype.getFooterDiv=function(){return this.jq().children(":jqmData(role=footer)")},r.prototype.getViewQuery=function(){return this.viewQuery},r.prototype.instantiateContentView=function(e){var t=this.contentViewConstructor;if(t)return new t;throw new Error("instantiateContentView not implemented")},r.prototype.isModified=function(){var e=this.contentView;return e&&e.isModified()},r.prototype.doInitialize=function(e){var t,n=this;if("page"!==e.jqmData("role"))throw new Error("PageView requires a JQM page (data-role='page')");t=e.data("pageData"),n.viewQuery=t&&t.viewQuery,n.pageId=e.attr("id")},r.prototype.doLoad=function(e){var t=this,n=t.contentView;return o.resolve(n&&n.destroy()).then(function(){n=t.contentView=t.instantiateContentView(e);var i=t.getPage().data("ord");return o.all([i?n.resolve(i):o.resolve(e),n.initialize(t.getContentDiv())])}).then(function(t){var i=t[0];return i.getType().is(e.getType())||(i=e),n.load(i)}).then(function(){return n.toDisplayName()}).then(function(e){t.getHeaderDiv().find("h1").text(e)})},r.prototype.destroy=function(){var e=this,n=e.contentView,i=arguments;return o.resolve(n&&n.destroy()).then(function(){return t.prototype.destroy.apply(e,i)})},r.prototype.save=function(e){var t=this;return t.contentView.save(e).then(function(e){return o.resolve(t.setModified(!1)).then(function(){return e})})},r.prototype.getCommandGroup=function(){return this.contentView.getCommandGroup()},r.prototype.doLayout=function(){return o.resolve(this.contentView&&this.contentView.layout())},r}),define("mobile/util/views/views",["baja!","lex!mobile"],function(e,t){"use strict";function n(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()||i.get("propsheet.station")}var i=t[0];return{getComponentName:n}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/nav",["baja!","bajaux/Widget","Promise","underscore","mobile/util/views/views","mobile/util/ord","mobile/util/mobile/mobile"],function(e,t,n,i,o,r,a){"use strict";function l(n){return n instanceof c?n:n instanceof e.Ord||"string"==typeof n?new d(n):n instanceof t?new f(n):n instanceof e.Complex?new p(n):n&&"object"===(void 0===n?"undefined":_typeof(n))?new g(n):void 0}function s(e,t){return e?r.equivalent(e.getNavOrd(),t)?e:i.find(e.getNavChildren(),function(e){return s(e,t)}):null}var u=o.getComponentName,c=function(e){this.$navChildren=[],this.$value=e};c.prototype.getNavOrd=function(){return this.$navOrd},c.prototype.setNavOrd=function(e){this.$navOrd=e},c.prototype.getNavDescription=function(){return this.$navDescription},c.prototype.setNavDescription=function(e){this.$navDescription=e},c.prototype.getNavIcon=function(){return this.$navIcon},c.prototype.setNavIcon=function(e){this.$navIcon=e},c.prototype.getNavChildren=function(){return this.$navChildren},c.prototype.setNavChildren=function(e){this.$navChildren=e},c.prototype.getNavParent=function(){return this.$navParent},c.prototype.setNavParent=function(e){this.$navParent=e},c.prototype.getValue=function(){return this.$value},c.prototype.setValue=function(e){this.$value=e},c.prototype.toString=function(){return String(this.$navOrd)},c.prototype.toDisplayName=function(){return n.resolve(this.$navDescription)};var d=function(t){c.apply(this,arguments);var n=e.Ord.make(t),i=String(n),o=i.split("/");this.$navOrd=n,this.$navDescription=o[o.length-1]};d.prototype=Object.create(c.prototype),d.prototype.constructor=d;var p=function(e){c.apply(this,arguments),this.$navDescription=u(e),this.$navOrd=r.deriveOrd(e),this.$navIcon=e.getIcon()};p.prototype=Object.create(c.prototype),p.prototype.constructor=d;var f=function(t){c.apply(this,arguments);var n,i,o=t.value();this.$view=t,o instanceof e.Complex&&(n=r.deriveOrd(o),i=o.getIcon()),!n&&t.pageId&&(n=a.decodePageId(t.pageId),0===n.indexOf("ord?")&&(n=n.substring(4))),this.$navOrd=n,this.$navIcon=i};f.prototype=Object.create(c.prototype),f.prototype.constructor=f,f.prototype.toDisplayName=function(){var e=this,t=e.$displayName;return t?n.resolve(t):e.$view.toDisplayName().then(function(t){return e.$displayName=t,t})};var g=function(e){this.$navOrd=e.$navOrd,this.$navDescription=e.$navDescription,this.$navIcon=e.$navIcon,this.$navChildren=e.$navChildren||[],this.$navParent=e.$navParent,this.$value=e.$value};g.prototype=Object.create(c.prototype);var h=function(){this.$selectedNode=null,this.$nodes=[],this.$changeListeners=[],this.$cutListeners=[]};e.event.mixin(h.prototype),h.prototype.add=function(e){var t=l(e);return this.pruneOtherBranch(t),this.$nodes.push(t),this},h.prototype.cut=function(t){if(!t||this.indexOf(t)<0)return this;t=l(t);var n=this,i=n.next(t);return i&&n.cut(i),n.$nodes.pop(),n.fireHandlers("cut",e.error,this,t),n},h.prototype.getSelectedNode=function(){return this.$selectedNode},h.prototype.getSelectedIndex=function(){return this.indexOf(this.getSelectedNode())},h.prototype.setSelectedNode=function(t){t=l(t),this.indexOf(t)<0&&this.add(t),this.$selectedNode=t,this.fireHandlers("change",e.error,this)},h.prototype.getNodes=function(){return this.$nodes},h.prototype.getOrds=function(){var e=[]
;return this.each(function(t){e.push(t.getNavOrd())}),e},h.prototype.each=function(t){return e.iterate(this.$nodes,t)},h.prototype.isEmpty=function(){return 0===this.$nodes.length},h.prototype.first=function(){return this.get(0)},h.prototype.last=function(){return this.get(this.size()-1)},h.prototype.indexOf=function(e){if(!e)return-1;e=l(e);var t,n=this,i=e.getNavOrd();return t=n.each(function(e,t){var n=e.getNavOrd();if(r.equivalent(i,n))return t}),void 0===t?-1:t},h.prototype.get=function(e){return this.$nodes[e]},h.prototype.next=function(e){var t=this.indexOf(e);return t>=0?this.get(t+1):void 0},h.prototype.prev=function(e){var t=this.indexOf(e);return t>=0?this.get(t-1):void 0},h.prototype.size=function(){return this.$nodes.length},h.prototype.pruneOtherBranch=function(t){var n=this;n.isEmpty()||n.sameBranch(t,n.last())||e.iterate(1,this.size(),function(e){var i=n.get(e);if(!n.sameBranch(t,i))return n.cut(i)})},h.prototype.sameBranch=function(e,t){var n=decodeURIComponent(String(e.getNavOrd())),i=decodeURIComponent(String(t.getNavOrd()));return n=n.replace(/\/+/g,"/"),i=i.replace(/\/+/g,"/"),0===n.indexOf(i)||0===i.indexOf(n)};var m=function(){h.call(this)};m.prototype=Object.create(h.prototype),m.prototype.constructor=m,m.prototype.add=function(t){var n=this,i=l(t),o=n.$nodes,a={},s=[],u=i.getNavOrd(),c=r.makeOrdHistory(u);return n.pruneOtherBranch(i),e.iterate(0,c.length-1,function(e){if(!o[e]){var t=c[e],n=s.length;o[e]=l(t),a["ord"+n]={ord:t,origIndex:e},s.push(t)}}),s.length&&new e.BatchResolve(s).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];o[n.origIndex]=l(e)}),n.fireHandlers("change",e.error,this)},fail:e.error}),o[c.length-1]=i,n.fireHandlers("change",e.error,this),this};var v=function(){var t=this;h.call(t),t.$flattenedNavFile=void 0,e.nav.navfile.getRootNode()};return v.prototype=Object.create(h.prototype),v.prototype.constructor=v,v.prototype.makeNavFileOrdHistory=function(t){var n=this,i=r.makeOrdHistory(t),o=i.length,a=[],u=[];return e.iterate(0,o,function(e){var t=i[o-1-e],r=s(n.$flattenedNavFile,t);if(r){for(;r;)a.push(r),r=r.getNavParent();return!0}a.push(l(t))}),o=a.length,e.iterate(0,o,function(e){u.push(a[o-1-e])}),u},v.prototype.add=function(t){var n,i=l(t),o=this,a={},s=[],u=i.getNavOrd(),c=o.makeNavFileOrdHistory(u);return o.pruneOtherBranch(i),n=o.$nodes[c.length-1]||c[c.length-1],n&&n.$fromNavFile&&r.equivalent(n.getNavOrd(),i.getNavOrd())&&(i=n,i.setValue(t)),c[c.length-1]=i,o.$nodes.splice(0,c.length),o.$nodes=c.concat(o.$nodes),e.iterate(0,o.$nodes.length,function(t){var n=o.$nodes[t].getValue(),i=s.length;(n instanceof e.Ord||"string"==typeof n)&&(a["ord"+i]={ord:n,origIndex:t},s.push(n))}),s.length&&new e.BatchResolve(s).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];o.$nodes[n.origIndex]=l(e)}),o.fireHandlers("change",e.error,this)},fail:e.error}),o.fireHandlers("change",e.error,this),this},v.prototype.sameBranch=function(t,n){var i=this,o=t.getNavOrd(),a=n.getNavOrd(),l=i.makeNavFileOrdHistory(o),s=i.makeNavFileOrdHistory(a),u=l.length,c=s.length;return!e.iterate(0,Math.min(u,c),function(e){if(!r.equivalent(l[e],s[e]))return!0})},{NavModel:h,ComponentSpaceNavModel:m,NavFileNavModel:v}}),define("mobile/util/views/ViewManager",["baja!","bajaux/Widget","Promise"],function(e,t,n){"use strict";var i=function t(){e.callSuper(t,this,arguments),this.$selectedView=void 0};return i=e.subclass(i,t),i.prototype.loadView=function(e){return n.resolve()},i.prototype.getSelectedView=function(){return n.resolve(this.$selectedView)},i.prototype.setSelectedView=function(e){var n=this;return n.getSelectedView().then(function(i){e instanceof t&&e!==i&&(n.$selectedView=e)})},i}),define("mobile/util/mobile/views/PageViewManager",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/mobile","mobile/util/ord","mobile/util/nav","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/views/PageView","mobile/util/views/ViewManager"],function(e,t,n,i,o,r,a,l,s,u,c,d,p,f){"use strict";function g(e,t){var n,i,o,a=e,s=a.$selectedView;return!!(s&&(n=a.navModel.getOrds(),i=r.indexOf(n,l.deriveOrd(s.value())),(o=r.indexOf(n,t))>=0&&i>=0&&o<i))}var h,m=a.encodePageId,v=a.decodePageId,y=t[0];return h=e.subclass(function t(i){e.callSuper(t,this,["mobile","PageViewManager "]);var o=this;o.navModel=i||new s.NavModel,o.navModel.attach("cut",function(e){var t=e.getValue();t instanceof p&&(t.destroy(),n("#"+t.pageId).remove())}),window.onbeforeunload=function(){var e=o.$selectedView;if(e.isModified()){var t;return e.toDisplayName().then(function(e){t=e}),y.get({key:"message.viewModified",args:[t]})}},e.iterate(u.getDefaultCommands(),function(e){o.getCommandGroup().add(e)})},f),h.prototype.doResolveOrd=function(t){return e.Ord.make(t).get({lease:!0})},h.prototype.createPagesHandlers=function(){function t(t){var n,i=a.spinnerTicket(1e3,5e3),o=t.pageData,r=o.ord;c.doResolveOrd(r).then(function(e){return n=e,c.instantiateView(n,o)}).then(function(e){var i=e.createPage();i.jqmData("view",e),i.jqmData("value",n),i.jqmData("ord",r),t.ok(i)}).catch(e.error).finally(function(){i.hide()})}function n(e){return"/ord/"+(e.ord||"station:|slot")}function i(t){var n,i,o=decodeURI(t.pathname+t.search).replace("&ui-state=dialog","");return 0!==o.indexOf("/ord?")&&0!==o.indexOf("/ord/")?{ord:"station:|slot:"}:(n=o.substring(5),i=e.Ord.make(n).parse().get("view"),{ord:n,viewQuery:i})}function o(t){function n(t){c.addView(o,i,r,a).catch(e.error),i.off("pagelayout",n)}var i=t.page,o=i.jqmData("view"),r=i.jqmData("value"),a=i.jqmData("ord");i.on("pagelayout",n)}function r(e){var t=e.page,n=t.jqmData("view"),i=n.value(),o=i&&i.getType();o&&n.$layoutDone&&o.isComponent()&&o.is("baja:VirtualComponent")&&c.refresh(n),n.$layoutDone=!0}function l(t){var n=t.page,i=n.jqmData("view");i&&i.pageId&&(c.setSelectedView(i).catch(e.error),i.layout())}function s(e){var t,n=c.selectedView;n&&n.isModified()&&(t=v(e.nextPage.attr("id")),c.confirmAbandonChanges(t),e.event.preventDefault())}function u(e){return e.commands}var c=this;return{createPage:t,encodeUrl:n,decodeUrl:i,pagelayout:r,pageshow:l,pagecreate:o,pagebeforechange:s,getCommands:u}},h.prototype.registerPages=function(e){d.register(e||function(e){return e.match(/^ord/)},this.createPagesHandlers())},h.prototype.initializeView=function(e,t,n,i){var o=this;return e.initialize(t).then(function(){return e.load(n)}).then(function(){return o.armHandlers(e),o.attachSubscriberEvents(e),e})},h.prototype.instantiateView=function(e,t){return o.reject("instantiateView not implemented")},h.prototype.addView=function(e,t,n,i){var o=this;return o.initializeView(e,t,n,i).then(function(e){return o.navModel.add(e),o.setSelectedView(e).then(function(){return e})})},h.prototype.armHandlers=function(e){var t=this,i=e.jq();i.on("click","a.link",function(){t.linkToOrd(n(this).jqmData("ord"))}),i.on("click","a.commandsButton",function(){t.showCommands(e)})},h.prototype.showCommands=function(e){var t=e.getCommandGroup(),n=this.getCommandGroup(),i=t.merge(n,{mergeCommands:!1}).flatten({recurse:!0});u.showCommandsDialog(i)},h.prototype.attachSubscriberEvents=function(e){var t=this,i=t.navModel,o=e.contentView.getSubscriber&&e.contentView.getSubscriber();o&&(o.attach("renamed",function(t,i,o){var r=m(t.getName()),a=e.pageId+"_2F"+r,l=m(i),s=e.pageId+"_2F"+l;n("#"+s).attr("id",a)}),o.attach("unmount",function(){var n,o=i.prev(e),r=i.indexOf(o),a=i.indexOf(t.selectedView);a>r?(n=y.get({key:"propsheet.message.unmounted",def:'Component "{0}" has been unmounted.',args:[e.getDisplayName()]}),c.ok({content:n,ok:function(n){for(;o&&!o.getNavOrd();)o=i.prev(o),e=i.prev(e);var r=l.deriveOrd(o.getValue().value());r&&"null"!==r&&t.linkToOrdInternal(r),i.cut(e),n.ok()}})):i.cut(e)}))},h.prototype.confirmAbandonChanges=function(e){var t=this,n=this.$selectedView;return new o(function(i,o){n.isModified()?n.toDisplayName().then(function(r){return c.confirmAbandonChanges({yes:function(e){var r=this;n.save().then(function(){t.refresh(n).then(function(){i(),e.ok()},function(t){o(t),e.fail(t)})},function(t){r.redirect(v(n.pageId)),o(t),e.fail(t)})},no:function(e){n.setModified(!1),t.refresh(n).then(function(){i(),e.ok()},function(t){o(t),e.fail(t)})},viewName:r,redirect:e})}):i()})},h.prototype.save=function(e){return e.save()},h.prototype.saveSelected=function(){var e=this;return e.getSelectedView().then(function(t){return e.save(t)})},h.prototype.setSelectedView=function(t){var i=this;return e.callSuper("setSelectedView",h,this,[t]).then(function(){return t.toDisplayName()}).then(function(e){var o;document.title=e,o=n("#"+t.pageId.replace(/(:|\.)/g,"\\$1")),o.children(":jqmData(role=header)").children("h1.viewName").text(e),i.currentPage=o,i.navModel.setSelectedNode(t)})},h.prototype.refresh=function(e){var t=this;return e.load(e.value()).then(function(){t.attachSubscriberEvents(e)})},h.prototype.refreshSelected=function(){var e=this;return e.getSelectedView().then(function(t){return t.isModified()?e.confirmAbandonChanges(void 0):e.refresh(t)})},h.prototype.linkToOrd=function(e,t){function n(){return a.linkToOrd(e,{viewQuery:t,reverse:g(i,e)})}var i=this;return i.getSelectedView().then(function(e){return e.isModified()?i.confirmAbandonChanges(n):n()})},h.prototype.linkToOrdInternal=function(t,n){n=e.objectify(n),n.reverse=g(this,t),a.linkToOrdInternal(t,n)},h.prototype.linkToOrdExternal=function(e,t){a.linkToOrdExternal(e,t)},h.prototype.layout=function(){return this.getSelectedView().then(function(e){if(e)return e.layout()})},h}),define("mobile/desktop/desktop",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/mobile","mobile/util/mobile/commands","mobile/util/mobile/selectview","mobile/util/mobile/pages","mobile/util/mobile/views/ListView","mobile/util/mobile/views/PageView","mobile/util/mobile/views/PageViewManager","css!mobile/desktop/desktop"],function(e,t,n,i,o,r,a,l,s,u,c,d,p){"use strict";function f(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()}function g(){function e(){n(document).on("onShowCommands","a.commandsButton",function(){var e=y.$selectedView.value();s.getViewsCommand().setOrd(e.getNavOrd())}),a.linkToOrdInternal(niagara.view.ord,{transition:"none",changeHash:!1})}y=new v,y.registerPages(),u.register({pageshow:e})}var h,m,v,y,b=t[0];return m=e.subclass(function(){e.callSuper(m,this,arguments)},c),m.prototype.highlight=function(){},m.prototype.toDisplayName=function(){var e=this.value(),t=f(e);return o.resolve(t||b.get("propsheet.station"))},m.prototype.makeListItem=function(t,n){return e.callSuper("makeListItem",m,this,arguments).then(function(i){var o=t.get(n),r=i.children("a");return r.children("img").removeClass("ui-li-icon"),r.jqmData("ord",e.Ord.make({base:"station:",child:o.get("appSlotPath")})),i})},m.prototype.makeSubscriber=function(){var t=e.callSuper("makeSubscriber",m,this,arguments);return t.attach("topicFired",function(e){"appsModified"===e.getName()&&y.refreshAll()}),t},m.prototype.makeListItemParams=function(e,t){var n=e.get(t);return o.resolve({title:"",display:n.get("appDisplayName"),icon:n.get("appDisplayIcon"),expandable:!1,linkable:!0})},m.prototype.makeListView=function(e){var t=n("<ul />"),i=this;return e.serverSideCall({typeSpec:"mobile:DesktopServerSideCallHandler",methodName:"getAppDisplayInfo"}).then(function(e){var n=r.map(e.getSlots().toArray(),function(t){return i.makeListItem(e,t)});return o.all(n).then(function(e){return t.html(e)})})},h=e.subclass(function t(){e.callSuper(t,this,arguments)},d),h.prototype.instantiateContentView=function(){return new m},h.prototype.createPage=function(){var t=e.callSuper("createPage",h,this,arguments);return t.children(":jqmData(role=header)").append(l.getCommandsButton()),t},v=function(){p.call(this)},v.prototype=new p,v.prototype.instantiateView=function(e,t){return o.resolve(new h)},g}),require(["jquery","bajaux/bajaux.built.min"],function(e){"use strict";e(document).on("mobileinit",function(){e.mobile.autoInitializePage=!1,e.mobile.defaultPageTransition="slide"}),require(["jquerymobile","mobile/desktop/desktop"],function(e,t){t(),e.initializePage()})}),define("mobile/desktop/desktop.run",function(){});