/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver.points;

import javax.baja.sys.*;
import javax.baja.util.*;

/**
 * The Write Worker is a simple way to post actions asynchronously. 
 * This is used by the Proxy Extension write method to perform the
 * write request without tying up the calling thread. 
 *
 * @author J. Spangler
 *
 */
public class BWriteWorker
    extends BWorker
{
  /*-
   class BWriteWorker
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.points.BWriteWorker(3462322730)1.0$ @*/
/* Generated Wed Mar 20 15:45:55 EDT 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BWriteWorker.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  public Worker getWorker()
  {
    // if we do not already have a worker instance, create one
    if (null == worker)
    {
      // init our queue with max size of 1000 Runnable tasks. This
      // queue will be used by the Worker to hold all tasks to be
      // processed.
      queue = new CoalesceQueue(1000);
      worker = new Worker(queue);
    }

    return worker;
  }
  
  /**
   * This method is used to post work to our Worker thread. 
   * The task must be a {@link Runnable}.
   * 
   * @param r
   *          - {@link Runnable} to execute on background thread.
   */
  public void postWork(Runnable r)
  {
    // check to see that our BComponent is mounted in a station and
    // that the queue is non null. If either of these conditions are
    // not meant, throw an exception
    if (null == queue || !isRunning())
      throw new NotRunningException();

    // Enqueue our Runnable task on our Worker queue
    queue.enqueue(r);
  }  
  
//////////////////////////////////////////////////////////////// 
//  Attributes 
//////////////////////////////////////////////////////////////// 
 
  private CoalesceQueue queue; 
  private Worker worker;    

}
