/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver.points;

import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The Point Learn entry is a simple struct to contain the information
 * we obtain during initial discovery of a Point on the remote device.
 * This information is later used to create a new Point under the
 * device extension on the Station with the correct Proxy information
 * to represent and connect with the remote point. 
 *
 * @author J. Spangler
 *
 */
public class BPointLearnEntry
    extends BStruct
{
  /*-
   class BPointLearnEntry
   {
     properties
     {
       pointName: String
         default {[ "" ]}
       
       pointId: String
         default {[ "" ]}
         
       pointType: String
         default {[ "number" ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.points.BPointLearnEntry(1068386584)1.0$ @*/
/* Generated Tue Mar 05 15:45:13 EST 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pointName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pointName</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#getPointName
   * @see com.examples.envctrldriver.points.BPointLearnEntry#setPointName
   */
  public static final Property pointName = newProperty(0, "",null);
  
  /**
   * Get the <code>pointName</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointName
   */
  public String getPointName() { return getString(pointName); }
  
  /**
   * Set the <code>pointName</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointName
   */
  public void setPointName(String v) { setString(pointName,v,null); }

////////////////////////////////////////////////////////////////
// Property "pointId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pointId</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#getPointId
   * @see com.examples.envctrldriver.points.BPointLearnEntry#setPointId
   */
  public static final Property pointId = newProperty(0, "",null);
  
  /**
   * Get the <code>pointId</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointId
   */
  public String getPointId() { return getString(pointId); }
  
  /**
   * Set the <code>pointId</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointId
   */
  public void setPointId(String v) { setString(pointId,v,null); }

////////////////////////////////////////////////////////////////
// Property "pointType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pointType</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#getPointType
   * @see com.examples.envctrldriver.points.BPointLearnEntry#setPointType
   */
  public static final Property pointType = newProperty(0, "number",null);
  
  /**
   * Get the <code>pointType</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointType
   */
  public String getPointType() { return getString(pointType); }
  
  /**
   * Set the <code>pointType</code> property.
   * @see com.examples.envctrldriver.points.BPointLearnEntry#pointType
   */
  public void setPointType(String v) { setString(pointType,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPointLearnEntry.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
