/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver.points;

import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.examples.envctrldriver.BEnvCtrlDevice;

/**
 * Our Point Device Extension which will contain the Control Points
 * that reprsent point data on our remote EnvController device. The
 * points in this point extension must contain our special 
 * {@link BEnvCtrlPointProxyExt} extension.
 *
 * @author J. Spangler
 * @creation Mar 7, 2013
 *
 */
public class BEnvCtrlPointDeviceExt
    extends BPointDeviceExt
{
  /*-
   class BEnvCtrlPointDeviceExt
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.points.BEnvCtrlPointDeviceExt(1717868203)1.0$ @*/
/* Generated Wed Mar 20 15:45:55 EDT 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnvCtrlPointDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /**
   * Get the parent device Type.
   */
  public Type getDeviceType()
  {
    return BEnvCtrlDevice.TYPE;
  }

  /**
   * Get the Type of proxy extensions for this device.
   */
  public Type getProxyExtType()
  {
    return BEnvCtrlPointProxyExt.TYPE;
  }

  /**
   * Get the Type of point folder for this device.
   */
  public Type getPointFolderType()
  {
    return BEnvCtrlPointFolder.TYPE;
  }


}
