/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.driver.util.BIPollable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Simple poll scheduler interface implemented by components 
 * that wish to receive a poll callback from the poll scheduler. 
 *
 * @author J. Spangler
 * @creation Mar 20, 2013
 *
 */
public interface BIEnvCtrlPollable
    extends BIPollable
{
  /**
   * The poll() callback method called from {@link BEnvCtrlPollScheduler}
   * when it is time to poll this object.
   */
  public void poll();
  
  public static final Type TYPE = Sys.loadType(BIEnvCtrlPollable.class);

}
