/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.sys.*;


public class BEnvCtrlPollScheduler
    extends BPollScheduler
{
  /*-
   class BEnvCtrlPollScheduler
   {
     properties
     {
     }
     actions
     {
     }
     topics
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.BEnvCtrlPollScheduler(3687451301)1.0$ @*/
/* Generated Wed Mar 20 15:45:55 EDT 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnvCtrlPollScheduler.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * This method is called by the Poll Scheduler on components
   * which implement the {@link BIPollable} interface.
   */
  public void doPoll(BIPollable p) throws Exception
  {
    //flag indicating whether we should poll
    boolean shouldPoll = true;
    try
    {
      //check the state of our network to determine if we should
      //perform a poll
      BDeviceNetwork net = (BDeviceNetwork)getParent();
      shouldPoll = (!net.isDisabled()) && (!net.isDown()) && (!net.isFault());  
    }
    catch (Exception e)
    {
      shouldPoll = true;
    }
    
    //return if we're not performing a poll
    if (!shouldPoll) return;
    
    //poll the component which is an implementation of our interface
    BIEnvCtrlPollable dev = (BIEnvCtrlPollable)p;
    try { dev.poll(); }
    catch ( NotRunningException e)
    {
      //if we run into a problem, unsubscribe
      unsubscribe(dev);
    }

  }

}
