/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.naming.BOrd;
import javax.baja.sys.*;

/**
 * The Device Network represents our remote EnvController network,
 * which in our case is a remote server that we connect with for
 * information. 
 *
 * @author J. Spangler
 *
 */
public class BEnvCtrlDeviceNetwork
    extends BDeviceNetwork
{
  /*-
   class BEnvCtrlDeviceNetwork
   {
     properties
     {
        ipAddress : String
          default{["###.###.###.###"]}
          
        ipPort : int
          default{[-1]}
          
        tuningPolicies: BTuningPolicyMap 
          -- A container for tuning policies which determines how 
          -- and when proxy points are read and written.
          default {[ new BTuningPolicyMap() ]}  
         
        pollScheduler: BPollScheduler
          -- The basic poll scheduler
          default {[ new BEnvCtrlPollScheduler() ]}
                 
     }
     actions
     {
       submitDeviceDiscoveryJob() : BOrd
         -- Submit the discovery job to the Job service from the 
         -- station side. Returns the BOrd of the submitted Job.
     }
     topics
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.BEnvCtrlDeviceNetwork(20707214)1.0$ @*/
/* Generated Wed Mar 20 15:46:28 EDT 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ipAddress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipAddress</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#getIpAddress
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#setIpAddress
   */
  public static final Property ipAddress = newProperty(0, "###.###.###.###",null);
  
  /**
   * Get the <code>ipAddress</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#ipAddress
   */
  public String getIpAddress() { return getString(ipAddress); }
  
  /**
   * Set the <code>ipAddress</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#ipAddress
   */
  public void setIpAddress(String v) { setString(ipAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "ipPort"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipPort</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#getIpPort
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#setIpPort
   */
  public static final Property ipPort = newProperty(0, -1,null);
  
  /**
   * Get the <code>ipPort</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#ipPort
   */
  public int getIpPort() { return getInt(ipPort); }
  
  /**
   * Set the <code>ipPort</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#ipPort
   */
  public void setIpPort(int v) { setInt(ipPort,v,null); }

////////////////////////////////////////////////////////////////
// Property "tuningPolicies"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tuningPolicies</code> property.
   * A container for tuning policies which determines how
   * and when proxy points are read and written.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#getTuningPolicies
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#setTuningPolicies
   */
  public static final Property tuningPolicies = newProperty(0, new BTuningPolicyMap(),null);
  
  /**
   * Get the <code>tuningPolicies</code> property.
   * A container for tuning policies which determines how
   * and when proxy points are read and written.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#tuningPolicies
   */
  public BTuningPolicyMap getTuningPolicies() { return (BTuningPolicyMap)get(tuningPolicies); }
  
  /**
   * Set the <code>tuningPolicies</code> property.
   * A container for tuning policies which determines how
   * and when proxy points are read and written.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#tuningPolicies
   */
  public void setTuningPolicies(BTuningPolicyMap v) { set(tuningPolicies,v,null); }

////////////////////////////////////////////////////////////////
// Property "pollScheduler"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollScheduler</code> property.
   * The basic poll scheduler
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#getPollScheduler
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#setPollScheduler
   */
  public static final Property pollScheduler = newProperty(0, new BEnvCtrlPollScheduler(),null);
  
  /**
   * Get the <code>pollScheduler</code> property.
   * The basic poll scheduler
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#pollScheduler
   */
  public BPollScheduler getPollScheduler() { return (BPollScheduler)get(pollScheduler); }
  
  /**
   * Set the <code>pollScheduler</code> property.
   * The basic poll scheduler
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#pollScheduler
   */
  public void setPollScheduler(BPollScheduler v) { set(pollScheduler,v,null); }

////////////////////////////////////////////////////////////////
// Action "submitDeviceDiscoveryJob"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>submitDeviceDiscoveryJob</code> action.
   * Submit the discovery job to the Job service from the
   * station side. Returns the BOrd of the submitted Job.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#submitDeviceDiscoveryJob()
   */
  public static final Action submitDeviceDiscoveryJob = newAction(0,null);
  
  /**
   * Invoke the <code>submitDeviceDiscoveryJob</code> action.
   * Submit the discovery job to the Job service from the
   * station side. Returns the BOrd of the submitted Job.
   * @see com.examples.envctrldriver.BEnvCtrlDeviceNetwork#submitDeviceDiscoveryJob
   */
  public BOrd submitDeviceDiscoveryJob() { return (BOrd)invoke(submitDeviceDiscoveryJob,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnvCtrlDeviceNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * constructor
   * 
   * On creation, create a new TCP comm stack instance.
   */
  public BEnvCtrlDeviceNetwork()
  {
    this.comm = new TcpComm(this);
  }

  /**
   * Return the {@link Type} for the Device Folder that can be parented
   * under our network.
   */
  public Type getDeviceFolderType()
  {
    return BEnvCtrlDeviceFolder.TYPE;
  }

  /**
   * Return the {@link Type} for the {@link BDevice} that can be parented
   * under the network.
   */
  public Type getDeviceType()
  {
    return BEnvCtrlDevice.TYPE;
  }
  
  
/////////////////////////////////////////////////////////////////
// Actions
/////////////////////////////////////////////////////////////////
  
  /**
   * Submit a Device Discovery job to the job service. The job will
   * send a simple request to the network which will respond with the
   * remote device network response message which can be parsed into
   * discovery objects.
   * 
   * @param cx
   * @return
   */
  public BOrd doSubmitDeviceDiscoveryJob(Context cx)
  {
    BDeviceDiscoveryJob job = new BDeviceDiscoveryJob(this);
    BOrd jobOrd = job.submit(cx);
    return jobOrd;
  }
 
  /**
   * This method pings the remote device network to ensure that the
   * network is available to receive commands. 
   */
  public void doPing() throws Exception
  {
    String sendRequest = sendRequest("ping");
    
    if( sendRequest.equals("ping ok!"))
      pingOk();
    else 
      pingFail(sendRequest);;
  }
  
  /**
   * This simple method sends requests over the network to the remote
   * device network.
   * 
   * @param request
   * @return
   */
  public String sendRequest(String request)
  {
    return comm.sendRequest(request);
  }
/////////////////////////////////////////////////////////////////
//  Attributes
/////////////////////////////////////////////////////////////////
  
  private TcpComm comm;
}
