/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

import com.examples.envctrldriver.points.BEnvCtrlPointDeviceExt;
import com.examples.envctrldriver.points.BPointDiscoveryJob;

/**
 * This class represents the remote device on the remote network.
 *   
 * @author J. Spangler
 */
public class BEnvCtrlDevice
    extends BDevice
{
  /*-
   class BEnvCtrlDevice
   {
     properties
     {
       deviceId: int
         default {[ -1 ]}

       points: BEnvCtrlPointDeviceExt
        -- Point container
        default {[ new BEnvCtrlPointDeviceExt() ]}         
     }
     actions
     {
       submitPointDiscoveryJob(): BOrd
         -- submits a point discovery job and returns ORD to job
         -- in the job service
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.BEnvCtrlDevice(3392169072)1.0$ @*/
/* Generated Wed Mar 06 10:35:20 EST 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDevice#getDeviceId
   * @see com.examples.envctrldriver.BEnvCtrlDevice#setDeviceId
   */
  public static final Property deviceId = newProperty(0, -1,null);
  
  /**
   * Get the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDevice#deviceId
   */
  public int getDeviceId() { return getInt(deviceId); }
  
  /**
   * Set the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BEnvCtrlDevice#deviceId
   */
  public void setDeviceId(int v) { setInt(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>points</code> property.
   * Point container
   * @see com.examples.envctrldriver.BEnvCtrlDevice#getPoints
   * @see com.examples.envctrldriver.BEnvCtrlDevice#setPoints
   */
  public static final Property points = newProperty(0, new BEnvCtrlPointDeviceExt(),null);
  
  /**
   * Get the <code>points</code> property.
   * Point container
   * @see com.examples.envctrldriver.BEnvCtrlDevice#points
   */
  public BEnvCtrlPointDeviceExt getPoints() { return (BEnvCtrlPointDeviceExt)get(points); }
  
  /**
   * Set the <code>points</code> property.
   * Point container
   * @see com.examples.envctrldriver.BEnvCtrlDevice#points
   */
  public void setPoints(BEnvCtrlPointDeviceExt v) { set(points,v,null); }

////////////////////////////////////////////////////////////////
// Action "submitPointDiscoveryJob"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>submitPointDiscoveryJob</code> action.
   * submits a point discovery job and returns ORD to job
   * in the job service
   * @see com.examples.envctrldriver.BEnvCtrlDevice#submitPointDiscoveryJob()
   */
  public static final Action submitPointDiscoveryJob = newAction(0,null);
  
  /**
   * Invoke the <code>submitPointDiscoveryJob</code> action.
   * submits a point discovery job and returns ORD to job
   * in the job service
   * @see com.examples.envctrldriver.BEnvCtrlDevice#submitPointDiscoveryJob
   */
  public BOrd submitPointDiscoveryJob() { return (BOrd)invoke(submitPointDiscoveryJob,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnvCtrlDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /**
   * The doPing callback is called to determine the availability 
   * of the device on the network.
   */
  public void doPing() throws Exception
  {
    BEnvCtrlDeviceNetwork network = (BEnvCtrlDeviceNetwork)getNetwork();
    String sendRequest = network.sendRequest("ping " + getDeviceId());
    
    if( sendRequest.equals("ping ok!"))
      pingOk();
    else 
      pingFail(sendRequest);
    
  }
  
  /**
   * This post ping is called asynchronously. 
   */
  protected IFuture postPing()
  {
    try
    {
      doPing();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    return null;
  }

  /**
   * Get the Type of the parent network.
   */
  public Type getNetworkType()
  {
    return BEnvCtrlDeviceNetwork.TYPE;
  }

/////////////////////////////////////////////////////////////////
//Actions
/////////////////////////////////////////////////////////////////

  /**
   * This action is used to launch the Discovery Job for points
   * under this device on the remote device.
   * 
   * @param cx
   * @return {@link BOrd} to the submitted job.
   */
  public BOrd doSubmitPointDiscoveryJob(Context cx)
  {
    BEnvCtrlDeviceNetwork network = (BEnvCtrlDeviceNetwork) getNetwork();
    BPointDiscoveryJob job = new BPointDiscoveryJob(network, getDeviceId());
    BOrd submit = job.submit(cx);
    return submit;
  }
}
